@extends('layouts.admin')

@section('title', 'Staff Details')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            @if($staff->user)
                <h1 class="h3 mb-0">{{ $staff->user->first_name }} {{ $staff->user->last_name }}</h1>
                <p class="text-muted">{{ $staff->user->email }}</p>
            @else
                <h1 class="h3 mb-0">{{ $staff->email ?? 'Pending Staff' }}</h1>
                <p class="text-muted">
                    <span class="badge bg-warning">Pending Invitation</span>
                </p>
            @endif
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.staff.edit', $staff) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('admin.staff.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Staff Information</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="text-muted small">Business</label>
                        <p class="mb-0">
                            <a href="{{ route('admin.businesses.show', $staff->business) }}">
                                {{ $staff->business->business_name }}
                            </a>
                        </p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Email</label>
                        <p class="mb-0">{{ $staff->user->email }}</p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Phone</label>
                        <p class="mb-0">{{ $staff->user->phone ?? 'N/A' }}</p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Role</label>
                        <p class="mb-0">
                            <span class="badge bg-primary">{{ ucfirst($staff->role) }}</span>
                        </p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Team</label>
                        <p class="mb-0">
                            @if($staff->team)
                                <span class="badge bg-secondary">{{ $staff->team->name }}</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Status</label>
                        <p class="mb-0">
                            <span class="badge bg-{{ $staff->status === 'active' ? 'success' : 'warning' }}">
                                {{ ucfirst(str_replace('_', ' ', $staff->status)) }}
                            </span>
                        </p>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Timeline</h6>
                </div>
                <div class="card-body">
                    <div class="mb-2">
                        <label class="text-muted small">Invited</label>
                        <p class="mb-0">{{ $staff->invited_at?->format('M d, Y H:i') ?? 'N/A' }}</p>
                    </div>
                    <div class="mb-2">
                        <label class="text-muted small">Joined</label>
                        <p class="mb-0">{{ $staff->joined_at?->format('M d, Y H:i') ?? 'N/A' }}</p>
                    </div>
                    <div class="mb-0">
                        <label class="text-muted small">Created</label>
                        <p class="mb-0">{{ $staff->created_at->format('M d, Y H:i') }}</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">User Details</h6>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="text-muted small">First Name</label>
                            <p class="mb-0">{{ $staff->user->first_name }}</p>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">Last Name</label>
                            <p class="mb-0">{{ $staff->user->last_name }}</p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="text-muted small">Account Type</label>
                            <p class="mb-0">
                                <span class="badge bg-info">{{ ucfirst($staff->user->account_type) }}</span>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">User Status</label>
                            <p class="mb-0">
                                <span class="badge bg-{{ $staff->user->status === 'active' ? 'success' : 'secondary' }}">
                                    {{ ucfirst($staff->user->status) }}
                                </span>
                            </p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="text-muted small">Email Verified</label>
                            <p class="mb-0">
                                @if($staff->user->email_verified_at)
                                    <span class="badge bg-success">{{ $staff->user->email_verified_at->format('M d, Y') }}</span>
                                @else
                                    <span class="badge bg-warning">Pending</span>
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">Phone Verified</label>
                            <p class="mb-0">
                                @if($staff->user->phone_verified_at)
                                    <span class="badge bg-success">{{ $staff->user->phone_verified_at->format('M d, Y') }}</span>
                                @else
                                    <span class="badge bg-warning">Pending</span>
                                @endif
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="mb-0">Permissions</h6>
                </div>
                <div class="card-body">
                    @if(!empty($staff->permissions))
                        <div class="row">
                            @foreach(json_decode($staff->permissions, true) ?? [] as $permission)
                            <div class="col-md-4 mb-2">
                                <span class="badge bg-secondary">{{ $permission }}</span>
                            </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-muted mb-0">No custom permissions assigned.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

