@extends('layouts.admin')

@section('title', 'Edit Subscription Plan')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 fw-bold mb-0">
                <i class="fas fa-edit me-2"></i>Edit Subscription Plan
            </h1>
            <p class="text-muted">Update plan details, pricing, and features</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.subscription-plans.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to Plans
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-light py-3">
                    <h5 class="mb-0 fw-bold">Plan Information</h5>
                </div>
                <div class="card-body p-4">
                    <form action="{{ route('admin.subscription-plans.update', $plan->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <!-- Basic Info -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Plan Name <span class="text-danger">*</span></label>
                                <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                                       value="{{ old('name', $plan->name) }}" required>
                                @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Plan Name (Arabic)</label>
                                <input type="text" name="name_ar" class="form-control @error('name_ar') is-invalid @enderror"
                                       value="{{ old('name_ar', $plan->name_ar) }}">
                                @error('name_ar')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                        </div>

                        <!-- Pricing -->
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Price (AED) <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" name="price" class="form-control @error('price') is-invalid @enderror"
                                       value="{{ old('price', $plan->price) }}" required>
                                @error('price')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Duration Days <span class="text-danger">*</span></label>
                                <input type="number" name="duration_days" class="form-control @error('duration_days') is-invalid @enderror"
                                       value="{{ old('duration_days', $plan->duration_days) }}" required>
                                @error('duration_days')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Duration Type</label>
                                <select name="duration_type" class="form-select">
                                    <option value="monthly" {{ $plan->duration_type === 'monthly' ? 'selected' : '' }}>Monthly</option>
                                    <option value="quarterly" {{ $plan->duration_type === 'quarterly' ? 'selected' : '' }}>Quarterly</option>
                                    <option value="yearly" {{ $plan->duration_type === 'yearly' ? 'selected' : '' }}>Yearly</option>
                                </select>
                            </div>
                        </div>

                        <!-- Type & Tier -->
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Type <span class="text-danger">*</span></label>
                                <select name="type" class="form-select @error('type') is-invalid @enderror" required>
                                    <option value="">Select Type</option>
                                    <option value="business" {{ $plan->type === 'business' ? 'selected' : '' }}>Business</option>
                                    <option value="user" {{ $plan->type === 'user' ? 'selected' : '' }}>User</option>
                                    <option value="marketing" {{ $plan->type === 'marketing' ? 'selected' : '' }}>Marketing</option>
                                </select>
                                @error('type')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Tier</label>
                                <select name="tier" class="form-select">
                                    <option value="">Select Tier</option>
                                    <option value="basic" {{ $plan->tier === 'basic' ? 'selected' : '' }}>Basic</option>
                                    <option value="professional" {{ $plan->tier === 'professional' ? 'selected' : '' }}>Professional</option>
                                    <option value="enterprise" {{ $plan->tier === 'enterprise' ? 'selected' : '' }}>Enterprise</option>
                                    <option value="premium" {{ $plan->tier === 'premium' ? 'selected' : '' }}>Premium</option>
                                    <option value="vip" {{ $plan->tier === 'vip' ? 'selected' : '' }}>VIP</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Sort Order</label>
                                <input type="number" name="sort_order" class="form-control"
                                       value="{{ old('sort_order', $plan->sort_order) }}">
                            </div>
                        </div>

                        <!-- Limits for Business Plans -->
                        @if($plan->type === 'business')
                        <div class="card bg-light mb-4">
                            <div class="card-header">
                                <h6 class="mb-0 fw-bold">Business Plan Limits</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="form-label">Max Venues</label>
                                        <input type="number" name="max_venues" class="form-control"
                                               value="{{ old('max_venues', $plan->max_venues) }}" placeholder="-1 for unlimited">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Max Offers</label>
                                        <input type="number" name="max_offers" class="form-control"
                                               value="{{ old('max_offers', $plan->max_offers) }}" placeholder="-1 for unlimited">
                                    </div>
                                    <div class="col-md-6 mt-3">
                                        <label class="form-label">Max Staff</label>
                                        <input type="number" name="max_staff" class="form-control"
                                               value="{{ old('max_staff', $plan->max_staff) }}" placeholder="-1 for unlimited">
                                    </div>
                                    <div class="col-md-6 mt-3">
                                        <label class="form-label">Max Photos per Venue</label>
                                        <input type="number" name="max_photos_per_venue" class="form-control"
                                               value="{{ old('max_photos_per_venue', $plan->max_photos_per_venue) }}">
                                    </div>
                                    <div class="col-md-6 mt-3">
                                        <label class="form-label">Storage (GB)</label>
                                        <input type="number" name="storage_gb" class="form-control"
                                               value="{{ old('storage_gb', $plan->storage_gb) }}">
                                    </div>
                                    <div class="col-md-6 mt-3">
                                        <label class="form-label">Campaigns per Month</label>
                                        <input type="number" name="monthly_campaigns" class="form-control"
                                               value="{{ old('monthly_campaigns', $plan->monthly_campaigns) }}" placeholder="-1 for unlimited">
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif

                        <!-- Features -->
                        <div class="card bg-light mb-4">
                            <div class="card-header">
                                <h6 class="mb-0 fw-bold">Features</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="checkbox" name="analytics_access"
                                                   value="1" {{ $plan->analytics_access ? 'checked' : '' }}>
                                            <label class="form-check-label">Analytics Access</label>
                                        </div>
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="checkbox" name="priority_support"
                                                   value="1" {{ $plan->priority_support ? 'checked' : '' }}>
                                            <label class="form-check-label">Priority Support</label>
                                        </div>
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="checkbox" name="custom_branding"
                                                   value="1" {{ $plan->custom_branding ? 'checked' : '' }}>
                                            <label class="form-check-label">Custom Branding</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="checkbox" name="api_access"
                                                   value="1" {{ $plan->api_access ? 'checked' : '' }}>
                                            <label class="form-check-label">API Access</label>
                                        </div>
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="checkbox" name="featured_listing"
                                                   value="1" {{ $plan->featured_listing ? 'checked' : '' }}>
                                            <label class="form-check-label">Featured Listing</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="is_popular"
                                                   value="1" {{ $plan->is_popular ? 'checked' : '' }}>
                                            <label class="form-check-label">Mark as Popular</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Status -->
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="is_active"
                                           name="is_active" value="1" {{ $plan->is_active ? 'checked' : '' }}>
                                    <label class="form-check-label fw-bold" for="is_active">Active</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="is_private"
                                           name="is_private" value="1" {{ $plan->is_private ? 'checked' : '' }}>
                                    <label class="form-check-label fw-bold" for="is_private">Private</label>
                                </div>
                            </div>
                        </div>

                        <!-- Submit -->
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Update Plan
                            </button>
                            <a href="{{ route('admin.subscription-plans.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Plan Summary -->
        <div class="col-lg-4">
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-header bg-light py-3">
                    <h6 class="mb-0 fw-bold">Plan Summary</h6>
                </div>
                <div class="card-body p-3">
                    <div class="mb-3">
                        <p class="text-muted small mb-1">Plan Type</p>
                        <p class="fw-bold mb-0">{{ ucfirst($plan->type) }}</p>
                    </div>
                    <div class="mb-3">
                        <p class="text-muted small mb-1">Tier</p>
                        <p class="fw-bold mb-0">{{ $plan->tier ? ucfirst($plan->tier) : 'N/A' }}</p>
                    </div>
                    <div class="mb-3">
                        <p class="text-muted small mb-1">Monthly Price</p>
                        <p class="fw-bold mb-0">AED {{ number_format($plan->price, 2) }}</p>
                    </div>
                    <div class="mb-3">
                        <p class="text-muted small mb-1">Status</p>
                        <p class="fw-bold mb-0">
                            @if($plan->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </p>
                    </div>
                    <div class="mb-3">
                        <p class="text-muted small mb-1">Created</p>
                        <p class="fw-bold mb-0">{{ $plan->created_at->format('M d, Y') }}</p>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm border-0">
                <div class="card-header bg-light py-3">
                    <h6 class="mb-0 fw-bold">Actions</h6>
                </div>
                <div class="card-body p-3">
                    <button class="btn btn-danger btn-sm w-100" onclick="deletePlan({{ $plan->id }})">
                        <i class="fas fa-trash me-2"></i>Delete Plan
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function deletePlan(planId) {
    if (confirm('Are you sure you want to delete this plan?')) {
        // Implement delete functionality
        console.log('Delete plan:', planId);
    }
}
</script>
@endsection

