@extends('layouts.admin')

@section('title', 'Subscription Plans Management')

@section('content')
<div class="container-fluid py-4">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 fw-bold mb-0">
                <i class="fas fa-credit-card me-2"></i>Subscription Plans Management
            </h1>
            <p class="text-muted">Create and manage business subscription plans with campaign allowances</p>
        </div>
        <div class="col-md-4 text-end">
            <button class="btn btn-primary btn-lg" data-bs-toggle="modal" data-bs-target="#createPlanModal">
                <i class="fas fa-plus-circle me-2"></i>Create New Plan
            </button>
        </div>
    </div>

    <!-- Plan Type Tabs with Professional Styling -->
    <ul class="nav nav-tabs border-bottom mb-4" role="tablist">
        <li class="nav-item" role="presentation">
            <a class="nav-link {{ $type === 'business' ? 'active' : '' }}"
               href="{{ route('admin.subscription-plans.index', ['type' => 'business']) }}"
               role="tab">
                <i class="fas fa-store me-2"></i>
                <strong>Business Plans</strong>
                <span class="badge bg-primary ms-2">{{ $businessPlansCount }}</span>
            </a>
        </li>
        <li class="nav-item" role="presentation">
            <a class="nav-link {{ $type === 'user' ? 'active' : '' }}"
               href="{{ route('admin.subscription-plans.index', ['type' => 'user']) }}"
               role="tab">
                <i class="fas fa-user me-2"></i>
                <strong>User Plans</strong>
                <span class="badge bg-info ms-2">{{ $userPlansCount }}</span>
            </a>
        </li>
    </ul>

    <!-- Plan Type Info Alert -->
    <div class="alert alert-info alert-dismissible fade show mb-4" role="alert">
        <i class="fas fa-lightbulb me-2"></i>
        <strong>Plan Type Information:</strong>
        @if($type === 'business')
            Business plans include venue management, offer creation, staff limits, and monthly campaign allowances for promotional content.
        @else
            User plans are designed for end-users of the mobile and web application with various subscription tiers.
        @endif
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small fw-bold mb-1">TOTAL PLANS</p>
                            <h2 class="mb-0 fw-bold">{{ $stats['total_plans'] }}</h2>
                        </div>
                        <div class="bg-primary bg-opacity-10 rounded-circle p-4">
                            <i class="fas fa-th-large text-primary fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small fw-bold mb-1">ACTIVE PLANS</p>
                            <h2 class="mb-0 fw-bold text-success">{{ $stats['active_plans'] }}</h2>
                        </div>
                        <div class="bg-success bg-opacity-10 rounded-circle p-4">
                            <i class="fas fa-check-circle text-success fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small fw-bold mb-1">TOTAL SUBSCRIBERS</p>
                            <h2 class="mb-0 fw-bold text-info">{{ number_format($stats['total_subscriptions']) }}</h2>
                        </div>
                        <div class="bg-info bg-opacity-10 rounded-circle p-4">
                            <i class="fas fa-users text-info fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted small fw-bold mb-1">MONTHLY REVENUE</p>
                            <h2 class="mb-0 fw-bold text-warning">AED {{ number_format($stats['monthly_revenue'], 2) }}</h2>
                        </div>
                        <div class="bg-warning bg-opacity-10 rounded-circle p-4">
                            <i class="fas fa-coins text-warning fs-5"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="card shadow-sm border-0 mb-4">
        <div class="card-body">
            <div class="row g-3 align-items-end">
                <div class="col-md-6">
                    <label class="form-label small fw-bold">Search Plans</label>
                    <input type="text" class="form-control" id="searchInput" placeholder="Plan name, description...">
                </div>
                <div class="col-md-3">
                    <label class="form-label small fw-bold">Status</label>
                    <select class="form-select" id="statusFilter">
                        <option value="">All Status</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <button class="btn btn-outline-secondary w-100" onclick="resetFilters()">
                        <i class="fas fa-redo me-1"></i>Reset Filters
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Plans Grid -->
    <div class="row" id="plansGrid">
        @forelse($plans as $plan)
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card h-100 shadow-sm border-0 position-relative {{ $plan->is_popular ? 'border-primary border-3' : '' }}">
                    <!-- Popular Badge -->
                    @if($plan->is_popular)
                        <div class="position-absolute top-0 end-0 p-3">
                            <span class="badge bg-primary animate-pulse">
                                <i class="fas fa-star me-1"></i>POPULAR
                            </span>
                        </div>
                    @endif

                    <!-- Status Badge -->
                    @if(!$plan->is_active)
                        <div class="position-absolute top-0 start-0 p-3">
                            <span class="badge bg-secondary">
                                <i class="fas fa-eye-slash me-1"></i>INACTIVE
                            </span>
                        </div>
                    @endif

                    <div class="card-body d-flex flex-column">
                        <!-- Plan Header -->
                        <div class="mb-4 text-center">
                            <h4 class="fw-bold mb-2">{{ $plan->name }}</h4>
                            @if($plan->name_ar)
                                <p class="text-muted small mb-3" dir="rtl">{{ $plan->name_ar }}</p>
                            @endif

                            <!-- Price Display -->
                            <div class="mb-3">
                                <span class="display-5 fw-bold text-primary">AED {{ number_format($plan->price, 2) }}</span>
                                <p class="text-muted small mt-1">
                                    per {{ ucfirst($plan->duration_type) }}
                                    @if($plan->duration_type === 'custom')
                                        ({{ $plan->duration_days }} days)
                                    @endif
                                </p>
                            </div>
                        </div>

                        <!-- Description -->
                        @if($plan->description)
                            <p class="text-muted small mb-4">{{ $plan->description }}</p>
                        @endif

                        <!-- Features Section -->
                        <div class="mb-4 flex-grow-1">
                            <h6 class="fw-bold small mb-3">
                                <i class="fas fa-check-circle text-success me-2"></i>Features
                            </h6>
                            @php $features = json_decode($plan->features, true); @endphp
                            @if($features && is_array($features))
                                <ul class="list-unstyled small">
                                    @forelse($features as $feature)
                                        <li class="mb-2 ps-3">
                                            <i class="fas fa-check text-success position-absolute ms-n3"></i>
                                            {{ $feature }}
                                        </li>
                                    @empty
                                        <li class="text-muted">No features listed</li>
                                    @endforelse
                                </ul>
                            @endif
                        </div>

                        <!-- Limits Section -->
                        @if($plan->max_venues || $plan->max_offers || $plan->max_staff || $plan->max_photos_per_venue)
                            <div class="mb-4 p-3 bg-light rounded-2">
                                <h6 class="fw-bold small mb-3">
                                    <i class="fas fa-sliders-h text-info me-2"></i>Plan Limits
                                </h6>
                                <div class="row g-2 small">
                                    @if($plan->max_venues)
                                        <div class="col-6">
                                            <span class="badge bg-light text-dark">
                                                <i class="fas fa-building me-1"></i>{{ $plan->max_venues }} Venues
                                            </span>
                                        </div>
                                    @endif
                                    @if($plan->max_offers)
                                        <div class="col-6">
                                            <span class="badge bg-light text-dark">
                                                <i class="fas fa-tag me-1"></i>{{ $plan->max_offers }} Offers
                                            </span>
                                        </div>
                                    @endif
                                    @if($plan->max_staff)
                                        <div class="col-6">
                                            <span class="badge bg-light text-dark">
                                                <i class="fas fa-users me-1"></i>{{ $plan->max_staff }} Staff
                                            </span>
                                        </div>
                                    @endif
                                    @if($plan->max_photos_per_venue)
                                        <div class="col-6">
                                            <span class="badge bg-light text-dark">
                                                <i class="fas fa-images me-1"></i>{{ $plan->max_photos_per_venue }} Photos
                                            </span>
                                        </div>
                                    @endif
                                    @if($plan->monthly_campaigns)
                                        <div class="col-6">
                                            <span class="badge bg-warning text-dark">
                                                <i class="fas fa-bullhorn me-1"></i>{{ $plan->monthly_campaigns }} Campaigns/Month
                                            </span>
                                        </div>
                                    @elseif($plan->type === 'business')
                                        <div class="col-6">
                                            <span class="badge bg-secondary text-light">
                                                <i class="fas fa-ban me-1"></i>No Campaigns
                                            </span>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif

                        <!-- Premium Features Section -->
                        @if($plan->analytics_access || $plan->priority_support || $plan->featured_listing || $plan->custom_branding || $plan->api_access)
                            <div class="mb-4">
                                <h6 class="fw-bold small mb-2">
                                    <i class="fas fa-crown text-warning me-2"></i>Premium Features
                                </h6>
                                <div class="d-flex flex-wrap gap-2">
                                    @if($plan->analytics_access)
                                        <span class="badge bg-info">Analytics</span>
                                    @endif
                                    @if($plan->priority_support)
                                        <span class="badge bg-success">Priority Support</span>
                                    @endif
                                    @if($plan->featured_listing)
                                        <span class="badge bg-warning text-dark">Featured</span>
                                    @endif
                                    @if($plan->custom_branding)
                                        <span class="badge bg-primary">Custom Branding</span>
                                    @endif
                                    @if($plan->api_access)
                                        <span class="badge bg-dark">API Access</span>
                                    @endif
                                </div>
                            </div>
                        @endif

                        <!-- Statistics -->
                        <div class="mb-4 p-3 bg-light rounded-2 text-center">
                            <div class="row">
                                <div class="col-6 border-end">
                                    <small class="text-muted d-block mb-1">Total Subscribers</small>
                                    <h5 class="mb-0 fw-bold">{{ $plan->subscriptions_count ?? 0 }}</h5>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted d-block mb-1">Active</small>
                                    <h5 class="mb-0 fw-bold text-success">{{ $plan->active_subscriptions_count ?? 0 }}</h5>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="d-grid gap-2">
                            <div class="btn-group-vertical" role="group">
                                <button type="button" onclick="editPlan({{ $plan->id }})" class="btn btn-primary btn-sm fw-bold">
                                    <i class="fas fa-edit me-2"></i>Edit Plan
                                </button>
                                <a href="{{ route('admin.subscription-plans.subscribers', $plan->id) }}" class="btn btn-outline-info btn-sm">
                                    <i class="fas fa-users me-2"></i>View Subscribers
                                </a>
                                <button type="button" onclick="toggleStatus({{ $plan->id }})" class="btn btn-outline-{{ $plan->is_active ? 'danger' : 'success' }} btn-sm">
                                    <i class="fas bi-{{ $plan->is_active ? 'toggle-on' : 'toggle-off' }} me-2"></i>
                                    {{ $plan->is_active ? 'Deactivate' : 'Activate' }}
                                </button>
                                <button type="button" onclick="togglePopular({{ $plan->id }})" class="btn btn-outline-warning btn-sm">
                                    <i class="fas fa-star{{ $plan->is_popular ? ' fa-fill' : '' }} me-2"></i>
                                    {{ $plan->is_popular ? 'Remove Popular' : 'Mark Popular' }}
                                </button>
                                <button type="button" onclick="deletePlan({{ $plan->id }})" class="btn btn-outline-danger btn-sm">
                                    <i class="fas fa-trash me-2"></i>Delete Plan
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-body text-center py-5">
                        <i class="fas fa-inbox text-muted" style="font-size: 64px; opacity: 0.5;"></i>
                        <p class="text-muted mt-4 mb-4 fw-semibold">No {{ $type }} plans found for this category</p>
                        <button class="btn btn-primary btn-lg" data-bs-toggle="modal" data-bs-target="#createPlanModal">
                            <i class="fas fa-plus-circle me-2"></i>Create Your First {{ ucfirst($type) }} Plan
                        </button>
                    </div>
                </div>
            </div>
        @endforelse
    </div>
</div>

    <!-- Create Plan Modal -->
    <div class="modal fade" id="createPlanModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-primary text-white py-3">
                    <h5 class="modal-title fw-bold">
                        <i class="fas fa-plus-circle me-2"></i>Create New Subscription Plan
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <!-- Error Alert -->
                <div id="createErrorAlert" class="alert alert-danger alert-dismissible fade show m-3" style="display: none;">
                    <button type="button" class="btn-close" onclick="this.parentElement.style.display='none'"></button>
                    <div id="createErrorMessage"></div>
                </div>

                <form id="createPlanForm">
                    @csrf
                    <div class="modal-body">
                        <div class="row g-3">
                            <!-- Basic Information Section -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-info-circle me-2"></i>Basic Information
                                </h6>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Plan Name (English) <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" placeholder="e.g., Premium" required>
                                <small class="text-danger d-none error-name"></small>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Plan Name (Arabic)</label>
                                <input type="text" class="form-control" name="name_ar" dir="rtl" placeholder="مثال: متقدم">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Plan Type <span class="text-danger">*</span></label>
                                <select class="form-select" name="type" required>
                                    <option value="business" {{ $type === 'business' ? 'selected' : '' }}>Business Plan</option>
                                    <option value="user" {{ $type === 'user' ? 'selected' : '' }}>User Plan</option>
                                    <option value="marketing" {{ $type === 'marketing' ? 'selected' : '' }}>Marketing Plan</option>
                                </select>
                                <small class="text-muted d-block mt-1">Business: Venue management, User: App users, Marketing: Campaigns</small>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Status</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="is_active" value="1" id="createActive" checked>
                                    <label class="form-check-label" for="createActive">Active</label>
                                </div>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (English)</label>
                                <textarea class="form-control" name="description" rows="2" placeholder="Brief plan description"></textarea>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (Arabic)</label>
                                <textarea class="form-control" name="description_ar" rows="2" dir="rtl" placeholder="وصف موجز للخطة"></textarea>
                            </div>

                            <!-- Pricing Section -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-coins me-2"></i>Pricing & Duration
                                </h6>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label fw-bold">Price (AED) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" name="price" step="0.01" min="0" placeholder="99.99" required>
                                <small class="text-danger d-none error-price"></small>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label fw-bold">Duration Type <span class="text-danger">*</span></label>
                                <select class="form-select" name="duration_type" required>
                                    <option value="monthly">Monthly</option>
                                    <option value="yearly">Yearly</option>
                                    <option value="custom">Custom</option>
                                </select>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label fw-bold">Duration Days <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" name="duration_days" value="30" min="1" required>
                                <small class="text-danger d-none error-duration_days"></small>
                            </div>

                            <!-- Features Section -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-list-check me-2"></i>Features <span class="text-danger">*</span>
                                </h6>
                            </div>

                            <div class="col-12">
                                <div id="featuresContainer">
                                    <div class="input-group mb-2">
                                        <input type="text" class="form-control" name="features[]" placeholder="e.g., Analytics Dashboard">
                                        <button type="button" class="btn btn-outline-success" onclick="addFeature()">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                    </div>
                                </div>
                                <small class="text-muted">Click + to add more features</small>
                                <small class="text-danger d-none error-features d-block mt-1"></small>
                            </div>

                            <!-- Plan Limits -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-sliders-h me-2"></i>Plan Limits (Optional)
                                </h6>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Max Venues</label>
                                <input type="number" class="form-control" name="max_venues" min="1" placeholder="10">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Max Offers</label>
                                <input type="number" class="form-control" name="max_offers" min="1" placeholder="50">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Max Staff Members</label>
                                <input type="number" class="form-control" name="max_staff" min="1" placeholder="20">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Max Photos per Venue</label>
                                <input type="number" class="form-control" name="max_photos_per_venue" min="1" placeholder="50">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Monthly Campaigns</label>
                                <input type="number" class="form-control" name="monthly_campaigns" min="0" placeholder="0" value="0">
                                <small class="text-muted">Number of promotional campaigns allowed per month. Set to 0 for no campaigns.</small>
                            </div>

                            <!-- Premium Features -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-crown me-2"></i>Premium Features
                                </h6>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="analytics_access" value="1" id="createAnalytics">
                                    <label class="form-check-label" for="createAnalytics">
                                        <strong>Analytics Access</strong>
                                        <br><small class="text-muted">Full analytics dashboard</small>
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="priority_support" value="1" id="createSupport">
                                    <label class="form-check-label" for="createSupport">
                                        <strong>Priority Support</strong>
                                        <br><small class="text-muted">24/7 dedicated support</small>
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="featured_listing" value="1" id="createFeatured">
                                    <label class="form-check-label" for="createFeatured">
                                        <strong>Featured Listing</strong>
                                        <br><small class="text-muted">Prominent marketplace placement</small>
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="custom_branding" value="1" id="createBranding">
                                    <label class="form-check-label" for="createBranding">
                                        <strong>Custom Branding</strong>
                                        <br><small class="text-muted">White-label solutions</small>
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="api_access" value="1" id="createAPI">
                                    <label class="form-check-label" for="createAPI">
                                        <strong>API Access</strong>
                                        <br><small class="text-muted">Developer API integration</small>
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_popular" value="1" id="createPopular">
                                    <label class="form-check-label" for="createPopular">
                                        <strong>Mark as Popular</strong>
                                        <br><small class="text-muted">Highlight in marketplace</small>
                                    </label>
                                </div>
                            </div>

                            <!-- Display Options -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-eye me-2"></i>Display Options
                                </h6>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Sort Order</label>
                                <input type="number" class="form-control" name="sort_order" value="0" min="0">
                                <small class="text-muted">Lower numbers appear first</small>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer bg-light py-3">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times me-1"></i>Cancel
                        </button>
                        <button type="submit" class="btn btn-primary fw-bold">
                            <i class="fas fa-check me-1"></i>Create Plan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Edit Plan Modal -->
    <div class="modal fade" id="editPlanModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-primary text-white py-3">
                    <h5 class="modal-title fw-bold">
                        <i class="fas fa-edit me-2"></i>Edit Subscription Plan
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <!-- Error Alert -->
                <div id="editErrorAlert" class="alert alert-danger alert-dismissible fade show m-3" style="display: none;">
                    <button type="button" class="btn-close" onclick="this.parentElement.style.display='none'"></button>
                    <div id="editErrorMessage"></div>
                </div>

                <form id="editPlanForm">
                    @csrf
                    <input type="hidden" name="id" id="edit_id">

                    <div class="modal-body">
                        <div class="row g-3">
                            <!-- Basic Information Section -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-info-circle me-2"></i>Basic Information
                                </h6>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Plan Name (English)</label>
                                <input type="text" class="form-control" name="name" id="edit_name" required>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Plan Name (Arabic)</label>
                                <input type="text" class="form-control" name="name_ar" id="edit_name_ar" dir="rtl">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Plan Type</label>
                                <select class="form-select" name="type" id="edit_type">
                                    <option value="business">Business Plan</option>
                                    <option value="user">User Plan</option>
                                    <option value="marketing">Marketing Plan</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Status</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="is_active" value="1" id="edit_is_active">
                                    <label class="form-check-label" for="edit_is_active">Active</label>
                                </div>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (English)</label>
                                <textarea class="form-control" name="description" id="edit_description" rows="2"></textarea>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (Arabic)</label>
                                <textarea class="form-control" name="description_ar" id="edit_description_ar" dir="rtl" rows="2"></textarea>
                            </div>

                            <!-- Pricing Section -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-coins me-2"></i>Pricing & Duration
                                </h6>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label fw-bold">Price (AED)</label>
                                <input type="number" class="form-control" name="price" id="edit_price" step="0.01">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Duration Type</label>
                                <select class="form-select" name="duration_type" id="edit_duration_type">
                                    <option value="monthly">Monthly</option>
                                    <option value="yearly">Yearly</option>
                                    <option value="custom">Custom</option>
                                </select>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Duration Days</label>
                                <input type="number" class="form-control" name="duration_days" id="edit_duration_days">
                            </div>

                            <!-- Features Section -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-list-check me-2"></i>Features
                                </h6>
                            </div>

                            <div class="col-12">
                                <div id="editFeaturesContainer"></div>
                                <button type="button" class="btn btn-outline-success btn-sm mt-2" onclick="addEditFeature()">
                                    <i class="fas fa-plus me-1"></i>Add Feature
                                </button>
                            </div>

                            <!-- Plan Limits -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-sliders-h me-2"></i>Plan Limits
                                </h6>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Max Venues</label>
                                <input type="number" class="form-control" id="edit_max_venues" name="max_venues">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Max Offers</label>
                                <input type="number" class="form-control" id="edit_max_offers" name="max_offers">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Max Staff Members</label>
                                <input type="number" class="form-control" id="edit_max_staff" name="max_staff">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Max Photos per Venue</label>
                                <input type="number" class="form-control" id="edit_max_photos_per_venue" name="max_photos_per_venue">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-bold">Monthly Campaigns</label>
                                <input type="number" class="form-control" id="edit_monthly_campaigns" name="monthly_campaigns">
                                <small class="text-muted">Number of promotional campaigns allowed per month. Set to 0 for no campaigns.</small>
                            </div>

                            <!-- Premium Features -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-crown me-2"></i>Premium Features
                                </h6>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="edit_analytics_access" name="analytics_access" value="1">
                                    <label class="form-check-label" for="edit_analytics_access">Analytics Access</label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="edit_priority_support" name="priority_support" value="1">
                                    <label class="form-check-label" for="edit_priority_support">Priority Support</label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="edit_featured_listing" name="featured_listing" value="1">
                                    <label class="form-check-label" for="edit_featured_listing">Featured Listing</label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="edit_custom_branding" name="custom_branding" value="1">
                                    <label class="form-check-label" for="edit_custom_branding">Custom Branding</label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="edit_api_access" name="api_access" value="1">
                                    <label class="form-check-label" for="edit_api_access">API Access</label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="edit_is_popular" name="is_popular" value="1">
                                    <label class="form-check-label" for="edit_is_popular">Mark as Popular</label>
                                </div>
                            </div>

                            <!-- Display Options -->
                            <div class="col-12">
                                <h6 class="fw-bold text-secondary mb-3">
                                    <i class="fas fa-eye me-2"></i>Display Options
                                </h6>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Sort Order</label>
                                <input type="number" class="form-control" name="sort_order" id="edit_sort_order">
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer bg-light py-3">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times me-1"></i>Close
                        </button>
                        <button type="submit" class="btn btn-primary fw-bold">
                            <i class="fas fa-check me-1"></i>Update Plan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function addFeature() {
            const container = document.getElementById('featuresContainer');
            const div = document.createElement('div');
            div.className = 'input-group mb-2';
            div.innerHTML = `
        <input type="text" class="form-control" name="features[]" placeholder="Enter feature">
        <button type="button" class="btn btn-danger" onclick="this.parentElement.remove()">
            <i class="bi bi-dash"></i>
        </button>
    `;
            container.appendChild(div);
        }

        document.getElementById('createPlanForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = new FormData(this);
            const data = {};

            formData.forEach((value, key) => {
                if (key === 'features[]') {
                    if (!data.features) data.features = [];
                    if (value.trim()) data.features.push(value);
                } else if (key.includes('[')) {
                    return;
                } else {
                    data[key] = value;
                }
            });

            fetch('{{ route('admin.subscription-plans.store') }}', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(data)
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                });
        });

        function toggleStatus(id) {
            fetch(`/admin/subscription-plans/${id}/toggle`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                });
        }

        function togglePopular(id) {
            fetch(`/admin/subscription-plans/${id}/toggle-popular`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                });
        }

        function deletePlan(id) {
            if (confirm('Are you sure you want to delete this plan?')) {
                fetch(`/admin/subscription-plans/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert(data.message);
                        }
                    });
            }
        }
        function editPlan(id) {
            // Fetch plan data as JSON
            fetch(`/admin/subscription-plans/${id}`)
                .then(res => res.json())
                .then(response => {
                    const plan = response.plan;
                    console.log('Plan data:', plan);

                    // Basic fields
                    document.getElementById('edit_id').value = plan.id;
                    document.getElementById('edit_name').value = plan.name;
                    document.getElementById('edit_name_ar').value = plan.name_ar ?? '';
                    document.getElementById('edit_description').value = plan.description ?? '';
                    document.getElementById('edit_description_ar').value = plan.description_ar ?? '';
                    document.getElementById('edit_type').value = plan.type;
                    document.getElementById('edit_price').value = plan.price;
                    document.getElementById('edit_duration_type').value = plan.duration_type;
                    document.getElementById('edit_duration_days').value = plan.duration_days;

                    // Limits
                    document.getElementById('edit_max_venues').value = plan.max_venues ?? '';
                    document.getElementById('edit_max_offers').value = plan.max_offers ?? '';
                    document.getElementById('edit_max_staff').value = plan.max_staff ?? '';
                    document.getElementById('edit_max_photos_per_venue').value = plan.max_photos_per_venue ?? '';

                    // Extra features
                    document.getElementById('edit_analytics_access').checked = plan.analytics_access == 1;
                    document.getElementById('edit_priority_support').checked = plan.priority_support == 1;
                    document.getElementById('edit_featured_listing').checked = plan.featured_listing == 1;
                    document.getElementById('edit_custom_branding').checked = plan.custom_branding == 1;
                    document.getElementById('edit_api_access').checked = plan.api_access == 1;
                    document.getElementById('edit_is_popular').checked = plan.is_popular == 1;
                    document.getElementById('edit_is_active').checked = plan.is_active == 1;

                    // Handle Features
                    const container = document.getElementById('editFeaturesContainer');
                    container.innerHTML = '';

                    let features = [];
                    if (plan.features) {
                        try {
                            features = typeof plan.features === 'string' ? JSON.parse(plan.features) : plan.features;
                        } catch (e) {
                            features = [];
                        }
                    }

                    if (Array.isArray(features)) {
                        features.forEach(f => {
                            container.innerHTML += `
                        <div class="input-group mb-2">
                            <input type="text" class="form-control" name="features[]" value="${f}">
                            <button class="btn btn-danger" type="button" onclick="this.parentElement.remove()">
                                <i class="bi bi-dash"></i>
                            </button>
                        </div>`;
                        });
                    }

                    new bootstrap.Modal(document.getElementById('editPlanModal')).show();
                })
                .catch(error => {
                    console.error('Error fetching plan:', error);
                    alert('Failed to load plan data');
                });
        }
        function addEditFeature() {
            const container = document.getElementById('editFeaturesContainer');
            container.innerHTML += `
        <div class="input-group mb-2">
            <input type="text" class="form-control" name="features[]" placeholder="Enter feature">
            <button class="btn btn-danger" type="button" onclick="this.parentElement.remove()">
                <i class="bi bi-dash"></i>
            </button>
        </div>`;
        }
        document.getElementById('editPlanForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = new FormData(this);
            const id = document.getElementById('edit_id').value;

            const data = {};
            formData.forEach((value, key) => {
                if (key === 'features[]') {
                    if (!data.features) data.features = [];
                    if (value.trim()) data.features.push(value);
                } else {
                    data[key] = value;
                }
            });

            fetch(`/admin/subscription-plans/${id}`, {
                method: 'PUT',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(data)
            })
                .then(res => res.json())
                .then(res => {
                    if (res.success) location.reload();
                });
        });

    </script>
@endsection
