@extends('layouts.admin')

@section('title', 'Subscription Plans Management')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">Subscription Plans</h1>
            <p class="text-muted">Manage subscription plans for businesses, users, and marketing</p>
        </div>
        <div class="col-md-4 text-end">
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createPlanModal">
                <i class="fas fa-plus"></i> Create New Plan
            </button>
        </div>
    </div>

    <!-- Plan Type Tabs -->
    <ul class="nav nav-tabs mb-4">
        <li class="nav-item">
            <a class="nav-link {{ request('type', 'business') === 'business' ? 'active' : '' }}"
               href="{{ route('admin.subscription-plans.index', ['type' => 'business']) }}">
                <i class="fas fa-building me-2"></i>Business Plans
                <span class="badge bg-primary ms-2">{{ $businessPlans->count() }}</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request('type') === 'user' ? 'active' : '' }}"
               href="{{ route('admin.subscription-plans.index', ['type' => 'user']) }}">
                <i class="fas fa-user me-2"></i>User Plans
                <span class="badge bg-info ms-2">{{ $userPlans->count() }}</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request('type') === 'marketing' ? 'active' : '' }}"
               href="{{ route('admin.subscription-plans.index', ['type' => 'marketing']) }}">
                <i class="fas fa-megaphone me-2"></i>Marketing Plans
                <span class="badge bg-success ms-2">{{ $marketingPlans->count() }}</span>
            </a>
        </li>
    </ul>

    @if(request('type', 'business') === 'business')
        <!-- Business Plans -->
        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="card border-primary h-100">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Basic Plan</h5>
                        <small>Entry Level</small>
                    </div>
                    <div class="card-body">
                        <h3 class="mb-3">AED 29<small>/month</small></h3>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i> 1 Venue</li>
                            <li><i class="fas fa-check text-success me-2"></i> 5 Offers per Venue</li>
                            <li><i class="fas fa-check text-success me-2"></i> 1 Staff Member</li>
                            <li><i class="fas fa-check text-success me-2"></i> 1GB Storage</li>
                            <li><i class="fas fa-check text-success me-2"></i> 1 Campaign/Month</li>
                            <li><i class="fas fa-check text-success me-2"></i> Basic Analytics</li>
                        </ul>
                        <div class="d-grid gap-2 mt-4">
                            <a href="#" class="btn btn-sm btn-outline-primary">Edit Plan</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-4">
                <div class="card border-info h-100">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Professional Plan</h5>
                        <small>Recommended</small>
                    </div>
                    <div class="card-body">
                        <h3 class="mb-3">AED 79<small>/month</small></h3>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i> 5 Venues</li>
                            <li><i class="fas fa-check text-success me-2"></i> 20 Offers per Venue</li>
                            <li><i class="fas fa-check text-success me-2"></i> 5 Staff Members</li>
                            <li><i class="fas fa-check text-success me-2"></i> 5GB Storage</li>
                            <li><i class="fas fa-check text-success me-2"></i> 10 Campaigns/Month</li>
                            <li><i class="fas fa-check text-success me-2"></i> Advanced Analytics</li>
                        </ul>
                        <div class="d-grid gap-2 mt-4">
                            <a href="#" class="btn btn-sm btn-outline-info">Edit Plan</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-4">
                <div class="card border-success h-100">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">Enterprise Plan</h5>
                        <small>Premium</small>
                    </div>
                    <div class="card-body">
                        <h3 class="mb-3">AED 199<small>/month</small></h3>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i> Unlimited Venues</li>
                            <li><i class="fas fa-check text-success me-2"></i> Unlimited Offers</li>
                            <li><i class="fas fa-check text-success me-2"></i> 20 Staff Members</li>
                            <li><i class="fas fa-check text-success me-2"></i> 50GB Storage</li>
                            <li><i class="fas fa-check text-success me-2"></i> Unlimited Campaigns</li>
                            <li><i class="fas fa-check text-success me-2"></i> Full Analytics + Reports</li>
                        </ul>
                        <div class="d-grid gap-2 mt-4">
                            <a href="#" class="btn btn-sm btn-outline-success">Edit Plan</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    @elseif(request('type') === 'user')
        <!-- User Plans -->
        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="card border-secondary h-100">
                    <div class="card-header bg-secondary text-white">
                        <h5 class="mb-0">Free Plan</h5>
                    </div>
                    <div class="card-body">
                        <h3 class="mb-3">FREE</h3>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i> Browse Venues</li>
                            <li><i class="fas fa-check text-success me-2"></i> 5 Favorites Max</li>
                            <li><i class="fas fa-check text-success me-2"></i> Limited Redemptions</li>
                            <li><i class="fas fa-check text-success me-2"></i> Write Reviews</li>
                            <li><i class="fas fa-times text-danger me-2"></i> No Cashback</li>
                        </ul>
                        <div class="d-grid gap-2 mt-4">
                            <a href="#" class="btn btn-sm btn-outline-secondary">Edit Plan</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-4">
                <div class="card border-warning h-100">
                    <div class="card-header bg-warning text-white">
                        <h5 class="mb-0">Premium Plan</h5>
                    </div>
                    <div class="card-body">
                        <h3 class="mb-3">AED 4.99<small>/month</small></h3>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i> Unlimited Favorites</li>
                            <li><i class="fas fa-check text-success me-2"></i> Unlimited Redemptions</li>
                            <li><i class="fas fa-check text-success me-2"></i> 2% Cashback</li>
                            <li><i class="fas fa-check text-success me-2"></i> Ad-Free Experience</li>
                            <li><i class="fas fa-check text-success me-2"></i> Priority Support</li>
                        </ul>
                        <div class="d-grid gap-2 mt-4">
                            <a href="#" class="btn btn-sm btn-outline-warning">Edit Plan</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-4">
                <div class="card border-danger h-100">
                    <div class="card-header bg-danger text-white">
                        <h5 class="mb-0">VIP Plan</h5>
                        <small>Premium</small>
                    </div>
                    <div class="card-body">
                        <h3 class="mb-3">AED 9.99<small>/month</small></h3>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i> All Premium Features</li>
                            <li><i class="fas fa-check text-success me-2"></i> 5% Cashback</li>
                            <li><i class="fas fa-check text-success me-2"></i> VIP Exclusive Offers</li>
                            <li><i class="fas fa-check text-success me-2"></i> Birthday Reward</li>
                            <li><i class="fas fa-check text-success me-2"></i> 2x Loyalty Points</li>
                        </ul>
                        <div class="d-grid gap-2 mt-4">
                            <a href="#" class="btn btn-sm btn-outline-danger">Edit Plan</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    @else
        <!-- Marketing Plans -->
        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="card border-primary h-100">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Starter Package</h5>
                    </div>
                    <div class="card-body">
                        <h3 class="mb-3">AED 49</h3>
                        <p class="text-muted small">One-time</p>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i> 7 Days Duration</li>
                            <li><i class="fas fa-check text-success me-2"></i> 1 Banner</li>
                            <li><i class="fas fa-check text-success me-2"></i> 10K Impressions</li>
                            <li><i class="fas fa-check text-success me-2"></i> Basic Targeting</li>
                            <li><i class="fas fa-check text-success me-2"></i> Analytics</li>
                        </ul>
                        <div class="d-grid gap-2 mt-4">
                            <a href="#" class="btn btn-sm btn-outline-primary">Edit Plan</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-4">
                <div class="card border-info h-100">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0">Standard Package</h5>
                    </div>
                    <div class="card-body">
                        <h3 class="mb-3">AED 99</h3>
                        <p class="text-muted small">One-time</p>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i> 14 Days Duration</li>
                            <li><i class="fas fa-check text-success me-2"></i> 3 Banners</li>
                            <li><i class="fas fa-check text-success me-2"></i> 50K Impressions</li>
                            <li><i class="fas fa-check text-success me-2"></i> A/B Testing</li>
                            <li><i class="fas fa-check text-success me-2"></i> Conversion Tracking</li>
                        </ul>
                        <div class="d-grid gap-2 mt-4">
                            <a href="#" class="btn btn-sm btn-outline-info">Edit Plan</a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-4">
                <div class="card border-success h-100">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0">Premium Package</h5>
                    </div>
                    <div class="card-body">
                        <h3 class="mb-3">AED 199</h3>
                        <p class="text-muted small">One-time</p>
                        <ul class="list-unstyled">
                            <li><i class="fas fa-check text-success me-2"></i> 30 Days Duration</li>
                            <li><i class="fas fa-check text-success me-2"></i> 10 Banners</li>
                            <li><i class="fas fa-check text-success me-2"></i> 250K Impressions</li>
                            <li><i class="fas fa-check text-success me-2"></i> Retargeting</li>
                            <li><i class="fas fa-check text-success me-2"></i> Dedicated Manager</li>
                        </ul>
                        <div class="d-grid gap-2 mt-4">
                            <a href="#" class="btn btn-sm btn-outline-success">Edit Plan</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

@endsection

