@extends('layouts.admin')

@section('title', 'Plan Subscribers')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">{{ $plan->name }} - Subscribers</h2>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.subscription-plans.index') }}">Plans</a></li>
                            <li class="breadcrumb-item active">Subscribers</li>
                        </ol>
                    </nav>
                </div>
                <div>
                    <a href="{{ route('admin.subscription-plans.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Back to Plans
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Plan Summary Card -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <h5 class="mb-1">{{ $plan->name }}</h5>
                            <p class="text-muted mb-0">AED {{ number_format($plan->price, 2) }} / {{ $plan->duration_type }}</p>
                        </div>
                        <div class="col-md-9">
                            <div class="row text-center">
                                <div class="col">
                                    <h3 class="mb-0">{{ $subscriptions->total() }}</h3>
                                    <small class="text-muted">Total Subscribers</small>
                                </div>
                                <div class="col">
                                    <h3 class="mb-0">{{ $plan->activeSubscriptions()->count() }}</h3>
                                    <small class="text-muted">Active</small>
                                </div>
                                <div class="col">
                                    <h3 class="mb-0">{{ $plan->subscriptions()->where('status', 'expired')->count() }}</h3>
                                    <small class="text-muted">Expired</small>
                                </div>
                                <div class="col">
                                    <h3 class="mb-0">AED {{ number_format($plan->payments()->sum('amount'), 2) }}</h3>
                                    <small class="text-muted">Revenue</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Subscribers Table -->
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th>Business</th>
                            <th>Owner</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Amount</th>
                            <th>Payment Method</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($subscriptions as $subscription)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    @if($subscription->business && $subscription->business->logo)
                                        <img src="{{ Storage::url($subscription->business->logo) }}"
                                             class="rounded me-2" width="40" height="40" style="object-fit: cover;">
                                    @endif
                                    <div>
                                        <div class="fw-medium">{{ $subscription->business->business_name ?? 'N/A' }}</div>
                                        <small class="text-muted">ID: #{{ $subscription->business_id }}</small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                @if($subscription->business && $subscription->business->owner)
                                    <div>{{ $subscription->business->owner->full_name }}</div>
                                    <small class="text-muted">{{ $subscription->business->owner->email }}</small>
                                @else
                                    <span class="text-muted">—</span>
                                @endif
                            </td>
                            <td>{{ $subscription->start_date->format('M d, Y') }}</td>
                            <td>{{ $subscription->end_date->format('M d, Y') }}</td>
                            <td>AED {{ number_format($subscription->amount, 2) }}</td>
                            <td>
                                <span class="badge bg-info">{{ ucfirst($subscription->payment_method) }}</span>
                            </td>
                            <td>
                                @if($subscription->status === 'active')
                                    <span class="badge bg-success">Active</span>
                                @elseif($subscription->status === 'expired')
                                    <span class="badge bg-danger">Expired</span>
                                @elseif($subscription->status === 'cancelled')
                                    <span class="badge bg-secondary">Cancelled</span>
                                @else
                                    <span class="badge bg-warning">{{ ucfirst($subscription->status) }}</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('admin.businesses.show', $subscription->business_id) }}"
                                       class="btn btn-outline-primary" title="View Business">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center py-5">
                                <i class="bi bi-inbox text-muted" style="font-size: 48px;"></i>
                                <p class="text-muted mt-2">No subscribers yet</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        @if($subscriptions->hasPages())
        <div class="card-footer">
            {{ $subscriptions->links() }}
        </div>
        @endif
    </div>
</div>
@endsection
