@extends('layouts.admin')

@section('title', 'Edit Subscription')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">Edit Subscription</h1>
            <p class="text-muted">Business: {{ $subscription->business->business_name }}</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.subscriptions.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('admin.subscriptions.update', $subscription->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <!-- Business Info (Read-only) -->
                        <div class="mb-3">
                            <label class="form-label">Business</label>
                            <input type="text" class="form-control" value="{{ $subscription->business->business_name }}" disabled>
                        </div>

                        <!-- Subscription Plan -->
                        <div class="mb-3">
                            <label class="form-label" for="subscription_plan_id">Subscription Plan <span class="text-danger">*</span></label>
                            <select class="form-select @error('subscription_plan_id') is-invalid @enderror"
                                    id="subscription_plan_id" name="subscription_plan_id" required>
                                <option value="">Select Plan</option>
                                @foreach($plans as $plan)
                                <option value="{{ $plan->id }}"
                                        {{ $subscription->subscription_plan_id == $plan->id ? 'selected' : '' }}>
                                    {{ $plan->name }} - AED {{ $plan->price }} ({{ $plan->tier }})
                                </option>
                                @endforeach
                            </select>
                            @error('subscription_plan_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Status -->
                        <div class="mb-3">
                            <label class="form-label" for="status">Status <span class="text-danger">*</span></label>
                            <select class="form-select @error('status') is-invalid @enderror"
                                    id="status" name="status" required>
                                <option value="trial" {{ $subscription->status == 'trial' ? 'selected' : '' }}>Trial</option>
                                <option value="active" {{ $subscription->status == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="paused" {{ $subscription->status == 'paused' ? 'selected' : '' }}>Paused</option>
                                <option value="cancelled" {{ $subscription->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            </select>
                            @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Start Date -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="start_date">Start Date <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                                           id="start_date" name="start_date"
                                           value="{{ $subscription->start_date->format('Y-m-d') }}" required>
                                    @error('start_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- End Date -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="end_date">End Date <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                                           id="end_date" name="end_date"
                                           value="{{ $subscription->end_date->format('Y-m-d') }}" required>
                                    @error('end_date')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Auto Renew -->
                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="auto_renew"
                                       name="auto_renew" value="1"
                                       {{ $subscription->auto_renew ? 'checked' : '' }}>
                                <label class="form-check-label" for="auto_renew">
                                    Auto-renew on expiration
                                </label>
                            </div>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Subscription
                            </button>
                            <a href="{{ route('admin.subscriptions.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Subscription Info</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <p class="text-muted mb-1">Current Plan</p>
                        <h6>{{ $subscription->plan->name }}</h6>
                    </div>

                    <div class="mb-3">
                        <p class="text-muted mb-1">Status</p>
                        <h6>
                            <span class="badge bg-{{ $subscription->status === 'active' ? 'success' : ($subscription->status === 'trial' ? 'info' : 'secondary') }}">
                                {{ ucfirst($subscription->status) }}
                            </span>
                        </h6>
                    </div>

                    <div class="mb-3">
                        <p class="text-muted mb-1">Created</p>
                        <h6>{{ $subscription->created_at->format('M d, Y') }}</h6>
                    </div>

                    <div class="mb-3">
                        <p class="text-muted mb-1">Days Remaining</p>
                        <h6>{{ $subscription->isActive() ? $subscription->daysRemaining() : 'Expired' }}</h6>
                    </div>

                    <hr>

                    @if($subscription->status !== 'cancelled')
                    <button type="button" class="btn btn-danger btn-sm w-100"
                            onclick="cancelSubscription({{ $subscription->id }})">
                        <i class="fas fa-times me-2"></i> Cancel Subscription
                    </button>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function cancelSubscription(subscriptionId) {
    if (confirm('Are you sure you want to cancel this subscription?')) {
        fetch(`/admin/subscriptions/${subscriptionId}/cancel`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Subscription cancelled successfully');
                location.reload();
            } else {
                alert('Error: ' + (data.message || 'Failed to cancel subscription'));
            }
        });
    }
}
</script>
@endsection

