@extends('layouts.admin')

@section('title', 'Teams Management')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="fas fa-users"></i> Teams
            </h1>
            <p class="text-muted">Manage all business teams and their members</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('admin.teams.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create Team
            </a>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control form-control-sm"
                        placeholder="Search teams..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select form-select-sm">
                        <option value="">All Status</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="archived" {{ request('status') === 'archived' ? 'selected' : '' }}>Archived</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="business_id" class="form-select form-select-sm">
                        <option value="">All Businesses</option>
                        @if(isset($businesses))
                        @foreach($businesses as $bid => $bname)
                            <option value="{{ $bid }}" {{ request('business_id') == $bid ? 'selected' : '' }}>
                                {{ $bname }}
                            </option>
                        @endforeach
                        @endif
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary btn-sm w-100">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
                <div class="col-md-2">
                    <a href="{{ route('admin.teams.index') }}" class="btn btn-secondary btn-sm w-100">
                        <i class="fas fa-sync"></i> Reset
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Teams</h6>
                    <h3 class="mb-0">{{ $teams->total() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active Teams</h6>
                    <h3 class="mb-0">{{ $stats['active'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Members</h6>
                    <h3 class="mb-0">{{ $stats['members'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Chats</h6>
                    <h3 class="mb-0">{{ $stats['chats'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Teams Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Team Name</th>
                        <th>Business</th>
                        <th>Description</th>
                        <th>Members</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($teams as $team)
                    <tr>
                        <td>
                            <strong>{{ $team->name }}</strong>
                        </td>
                        <td>
                            <a href="{{ route('admin.businesses.show', $team->business) }}">
                                {{ $team->business->business_name }}
                            </a>
                        </td>
                        <td>
                            <small class="text-muted">{{ Str::limit($team->description, 40) }}</small>
                        </td>
                        <td>
                            <span class="badge bg-info">{{ $team->member_count }}</span>
                        </td>
                        <td>
                            <span class="badge bg-{{ $team->status === 'active' ? 'success' : 'secondary' }}">
                                {{ ucfirst($team->status) }}
                            </span>
                        </td>
                        <td><small>{{ $team->created_at->format('M d, Y') }}</small></td>
                        <td>
                            <a href="{{ route('admin.teams.show', $team->id) }}" class="btn btn-sm btn-info" title="View">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="{{ route('admin.teams.edit', $team->id) }}" class="btn btn-sm btn-warning" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.teams.destroy', $team->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')" title="Delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            No teams found.
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            Showing {{ $teams->firstItem() ?? 0 }} to {{ $teams->lastItem() ?? 0 }} of {{ $teams->total() }} teams
        </div>
        <div>
            {{ $teams->links() }}
        </div>
    </div>
</div>
@endsection

