@extends('layouts.admin')

@section('title', 'Support Tickets')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Support Tickets</h2>
            <p class="text-muted mb-0">Manage customer support tickets</p>
        </div>
    </div>

    <div class="admin-card">
        <div class="admin-card-header">
            <h5 class="mb-0 fw-bold">All Tickets</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                    <tr>
                        <th>Ticket #</th>
                        <th>Subject</th>
                        <th>User</th>
                        <th>Category</th>
                        <th>Priority</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($tickets as $ticket)
                        <tr>
                            <td><code>{{ $ticket->ticket_number }}</code></td>
                            <td>{{ $ticket->subject }}</td>
                            <td>{{ $ticket->user->full_name ?? 'N/A' }}</td>
                            <td>{{ ucfirst($ticket->category) }}</td>
                            <td>
                            <span class="badge bg-{{ $ticket->priority === 'high' ? 'danger' : ($ticket->priority === 'medium' ? 'warning' : 'info') }}">
                                {{ ucfirst($ticket->priority) }}
                            </span>
                            </td>
                            <td>
                            <span class="badge bg-{{ $ticket->status === 'closed' ? 'success' : ($ticket->status === 'open' ? 'primary' : 'secondary') }}">
                                {{ ucfirst($ticket->status) }}
                            </span>
                            </td>
                            <td>{{ $ticket->created_at->format('M d, Y') }}</td>
                            <td>
                                <a href="{{route('admin.tickets.show', $ticket->id)}}" class="btn btn-sm btn-outline-primary">View</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">No tickets found</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if(isset($tickets) && $tickets->hasPages())
            <div class="admin-card-footer">
                {{ $tickets->links() }}
            </div>
        @endif
    </div>
@endsection
