@extends('layouts.admin')
@section('title', 'Ticket #' . $ticket->id . ' Details')
@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0 text-gray-800">Ticket #{{ $ticket->id }}</h1>
            <p class="text-muted">{{ $ticket->subject }}</p>
        </div>
        <div class="col-md-4 text-right">
            <span class="badge @if($ticket->status === 'open') badge-primary @elseif($ticket->status === 'in_progress') badge-warning @elseif($ticket->status === 'resolved') badge-success @else badge-secondary @endif">
                {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
            </span>
        </div>
    </div>

    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8">
            <!-- Ticket Details Card -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0">Ticket Details</h5>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <p class="text-muted small">Priority</p>
                            <p class="font-weight-bold">
                                <span class="badge @if($ticket->priority == 'high') bg-danger @elseif($ticket->priority == 'medium') bg-warning @else bg-info @endif">
                                    {{ ucfirst($ticket->priority) }}
                                </span>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p class="text-muted small">Category</p>
                            <p class="font-weight-bold">{{ $ticket->category ?? 'N/A' }}</p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <p class="text-muted small">User</p>
                            <p class="font-weight-bold">
                                <a href="{{ route('admin.users.show', $ticket->user->id) }}">{{ $ticket->user->first_name }}</a>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p class="text-muted small">Created At</p>
                            <p class="font-weight-bold">{{ $ticket->created_at->format('M d, Y H:i A') }}</p>
                        </div>
                    </div>
                    <hr>
                    <p class="text-muted small">Description</p>
                    <p class="text-gray-800">{{ $ticket->description }}</p>
                </div>
            </div>

            <!-- Messages Section -->
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0">Messages</h5>
                </div>
                <div class="card-body">
                    <div class="messages-container" style="max-height: 400px; overflow-y: auto; margin-bottom: 20px;">
                        @forelse($ticket->replies as $message)
                        <div class="message-item mb-3 @if($message->user_id === auth()->id()) text-right @endif">
                            <div class="@if($message->user_id === auth()->id()) float-right @else float-left @endif" style="max-width: 75%;">
                                <div class="@if($message->user_id === auth()->id()) bg-primary text-white @else bg-light @endif p-3 rounded">
                                    <p class="mb-2">
                                        <strong>{{ $message->user->name }}</strong>
                                        @if($message->user->hasRole('admin') || $message->user->hasRole('super_admin'))
                                        <span class="badge badge-info ml-2">Admin</span>
                                        @endif
                                    </p>
                                    <p class="mb-0">{{ $message->message }}</p>
                                    @if($message->attachments)
                                        <div class="mt-2">
                                            <strong>Attachments:</strong>
                                            <ul class="list-unstyled">
                                                {{--                                            attachment json decode--}}
                                                @php $attachments = json_decode($message->attachments); @endphp
                                                @foreach($attachments as $attachment)
                                                    <li>
                                                        <a href="{{ Storage::url($attachment) }}"
                                                           target="_blank">
                                                            {{ $attachment }}
                                                        </a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                </div>
                                <small class="text-muted d-block mt-1">{{ $message->created_at->diffForHumans() }}</small>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        @empty
                        <p class="text-center text-muted py-3">No messages yet</p>
                        @endforelse
                    </div>

                    <hr>

                    <!-- Add Reply Form -->
                    <form action="{{ route('admin.tickets.reply', $ticket->id) }}" method="POST">
                        @csrf
                        <div class="form-group">
                            <label for="message">Add Reply</label>
                            <textarea name="message" id="message" class="form-control @error('message') is-invalid @enderror" rows="4" placeholder="Type your message..." required></textarea>
                            @error('message')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-primary">Send Reply</button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Status Update Card -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0">Update Status</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.tickets.update-status', $ticket->id) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <div class="form-group mb-3">
                            <select name="status" class="form-control @error('status') is-invalid @enderror">
                                <option value="open" @if($ticket->status === 'open') selected @endif>Open</option>
                                <option value="pending" @if($ticket->status === 'pending') selected @endif>Pending</option>
                                <option value="resolved" @if($ticket->status === 'resolved') selected @endif>Resolved</option>
                                <option value="closed" @if($ticket->status === 'closed') selected @endif>Closed</option>
                            </select>
                            @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-success btn-block">Update Status</button>
                    </form>
                </div>
            </div>

            <!-- Assign Card -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0">Assign To</h5>
                </div>
                <div class="card-body">
                    <p class="mb-3">
                        <strong>{{ $ticket->assignedTo?->name ?? 'Unassigned' }}</strong>
                    </p>
                    @php $admins =  \App\Models\User::where('account_type', 'admin')->get(); @endphp
                    <form action="{{ route('admin.tickets.assign', $ticket->id) }}" method="POST">
                        @csrf
                        @method('PATCH')
                        <div class="form-group mb-3">
                            <select name="assigned_to" class="form-control @error('assigned_to') is-invalid @enderror">
                                <option value="">Unassigned</option>
                                @foreach($admins as $admin)
                                <option value="{{ $admin->id }}" @if($ticket->assigned_to === $admin->id) selected @endif>{{ $admin->name }}</option>
                                @endforeach
                            </select>
                            @error('assigned_to')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-info btn-block">Assign</button>
                    </form>
                </div>
            </div>

            <!-- Actions Card -->
            <div class="card shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0">Actions</h5>
                </div>
                <div class="card-body">
                    <a href="{{ route('admin.tickets.index') }}" class="btn btn-secondary btn-block mb-2">Back to Tickets</a>
                    <form action="{{ route('admin.tickets.destroy', $ticket->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this ticket?');" class="d-inline-block w-100">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-block">Delete Ticket</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
