@extends('layouts.admin')

@section('title', 'User Activity Tracking')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="fas fa-history"></i> User Activity Tracking
            </h1>
            <p class="text-muted">Monitor business owners and staff member activities</p>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Users</h6>
                    <h3 class="mb-0">{{ $stats['total_users'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active Today</h6>
                    <h3 class="mb-0">{{ $stats['active_today'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active This Week</h6>
                    <h3 class="mb-0">{{ $stats['active_this_week'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Inactive 7+ Days</h6>
                    <h3 class="mb-0">{{ $stats['inactive_7_days'] ?? 0 }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="Search by name or email" value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <select name="account_type" class="form-select">
                        <option value="">All Types</option>
                        <option value="business" {{ request('account_type') === 'business' ? 'selected' : '' }}>Business Owner</option>
                        <option value="user" {{ request('account_type') === 'user' ? 'selected' : '' }}>Staff/User</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value="">All Status</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="days" class="form-select">
                        <option value="">Any Time</option>
                        <option value="1" {{ request('days') === '1' ? 'selected' : '' }}>Today</option>
                        <option value="7" {{ request('days') === '7' ? 'selected' : '' }}>This Week</option>
                        <option value="30" {{ request('days') === '30' ? 'selected' : '' }}>This Month</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Users Activity Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>User</th>
                        <th>Email</th>
                        <th>Account Type</th>
                        <th>Last Active</th>
                        <th>Last Active Ago</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($users as $user)
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm me-2">
                                    @if($user->profile_image)
                                    <img src="{{ asset($user->profile_image) }}" alt="{{ $user->first_name }}" class="rounded-circle">
                                    @else
                                    <span class="avatar-title rounded-circle bg-primary text-white">
                                        {{ strtoupper(substr($user->first_name ?? 'U', 0, 1)) }}
                                    </span>
                                    @endif
                                </div>
                                <div>
                                    <h6 class="mb-0">{{ $user->first_name }} {{ $user->last_name }}</h6>
                                </div>
                            </div>
                        </td>
                        <td>{{ $user->email }}</td>
                        <td>
                            <span class="badge bg-{{ $user->account_type === 'business' ? 'info' : 'secondary' }}">
                                {{ ucfirst($user->account_type) }}
                            </span>
                        </td>
                        <td>
                            @if($user->last_active_at)
                                <small>{{ $user->last_active_at->format('M d, Y H:i') }}</small>
                            @else
                                <span class="text-muted">Never</span>
                            @endif
                        </td>
                        <td>
                            @if($user->last_active_at)
                                <small class="text-muted">{{ $user->last_active_at->diffForHumans() }}</small>
                            @else
                                <span class="text-muted">N/A</span>
                            @endif
                        </td>
                        <td>
                            @if($user->last_active_at)
                                @php
                                    $daysSinceActive = $user->last_active_at->diffInDays(now());
                                @endphp
                                @if($daysSinceActive === 0)
                                    <span class="badge bg-success">Active Today</span>
                                @elseif($daysSinceActive <= 7)
                                    <span class="badge bg-info">Active This Week</span>
                                @elseif($daysSinceActive <= 30)
                                    <span class="badge bg-warning">Active This Month</span>
                                @else
                                    <span class="badge bg-danger">Inactive</span>
                                @endif
                            @else
                                <span class="badge bg-secondary">Never Active</span>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('admin.users.show', $user->id) }}" class="btn btn-sm btn-info" title="View Details">
                                <i class="fas fa-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            No users found
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($users->hasPages())
        <div class="card-footer">
            {{ $users->links() }}
        </div>
        @endif
    </div>
</div>
@endsection

