@extends('layouts.admin')

@section('title', 'User Details')

@section('content')
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">User Details</h2>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">Users</a></li>
                            <li class="breadcrumb-item active">{{ $user->full_name }}</li>
                        </ol>
                    </nav>
                </div>
                <div>
                    <a href="{{ route('admin.users.edit', $user->id) }}" class="btn btn-primary">
                        <i class="bi bi-pencil me-2"></i>Edit User
                    </a>
                </div>
{{--                check if the user is buiness owner and has no busines then create business--}}



                @if($user->account_type == 'business_owner' && !$user->business)
                    <div class="ms-2">
                        <a href="{{ route('admin.businesses.create-for-user', $user->id) }}" class="btn btn-success">
                            <i class="bi bi-building me-2"></i>Create Business
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <div class="row">
        <!-- User Info Card -->
        <div class="col-md-4 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <div class="mb-3">
                        @if($user->avatar)
                            <img src="{{ Storage::url($user->avatar) }}" class="rounded-circle" width="120" height="120" alt="Avatar">
                        @else
                            <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 120px; height: 120px; font-size: 48px;">
                                {{ strtoupper(substr($user->first_name, 0, 1)) }}{{ strtoupper(substr($user->last_name, 0, 1)) }}
                            </div>
                        @endif
                    </div>
                    <h4 class="mb-1">{{ $user->full_name }}</h4>
                    <p class="text-muted mb-2">{{ ucfirst($user->role) }}</p>
                    <span class="badge bg-{{ $user->status === 'active' ? 'success' : 'danger' }}">
                        {{ ucfirst($user->status) }}
                    </span>
                </div>
                <div class="card-body border-top">
                    <div class="mb-3">
                        <small class="text-muted">Email</small>
                        <p class="mb-0">{{ $user->email }}</p>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Phone</small>
                        <p class="mb-0">{{ $user->phone }}</p>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Joined</small>
                        <p class="mb-0">{{ $user->created_at->format('M d, Y') }}</p>
                    </div>
                    <div class="mb-0">
                        <small class="text-muted">Last Login</small>
                        <p class="mb-0">{{ $user->last_login_at ? $user->last_login_at->diffForHumans() : 'Never' }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Details Tabs -->
        <div class="col-md-8 mb-4">
            <div class="card">
                <div class="card-header">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#details">Details</a>
                        </li>
                        @if($user->business)
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#business">Business</a>
                        </li>
                        @endif
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#subscriptions">Subscriptions</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#activity">Activity</a>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content">
                        <!-- Details Tab -->
                        <div class="tab-pane fade show active" id="details">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="200">User ID</th>
                                    <td>#{{ $user->id }}</td>
                                </tr>
                                <tr>
                                    <th>Full Name</th>
                                    <td>{{ $user->full_name }}</td>
                                </tr>
                                <tr>
                                    <th>Email</th>
                                    <td>
                                        {{ $user->email }}
                                        @if($user->email_verified_at)
                                            <span class="badge bg-success ms-2">Verified</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>Phone</th>
                                    <td>
                                        {{ $user->phone }}
                                        @if($user->phone_verified_at)
                                            <span class="badge bg-success ms-2">Verified</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>Account Type</th>
                                    <td>{{ ucfirst(str_replace('_', ' ', $user->account_type)) }}</td>
                                </tr>
                                <tr>
                                    <th>Role</th>
                                    <td><span class="badge bg-primary">{{ ucfirst($user->role) }}</span></td>
                                </tr>
                                <tr>
                                    <th>Status</th>
                                    <td><span class="badge bg-{{ $user->status === 'active' ? 'success' : 'danger' }}">{{ ucfirst($user->status) }}</span></td>
                                </tr>
                                <tr>
                                    <th>Date of Birth</th>
                                    <td>{{ $user->date_of_birth ?? 'Not provided' }}</td>
                                </tr>
                                <tr>
                                    <th>Registered</th>
                                    <td>{{ $user->created_at->format('M d, Y h:i A') }}</td>
                                </tr>
                                <tr>
                                    <th>Last Updated</th>
                                    <td>{{ $user->updated_at->format('M d, Y h:i A') }}</td>
                                </tr>
                                <tr>
                                    <th>Last Login</th>
                                    <td>{{ $user->last_login_at ? $user->last_login_at->format('M d, Y h:i A') : 'Never' }}</td>
                                </tr>
                            </table>
                        </div>

                        <!-- Business Tab -->
                        @if($user->business)
                        <div class="tab-pane fade" id="business">
                            <h5 class="mb-3">Business Information</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="200">Business Name</th>
                                    <td>{{ $user->business->business_name }}</td>
                                </tr>
                                <tr>
                                    <th>License Number</th>
                                    <td>{{ $user->business->trade_license_number }}</td>
                                </tr>
                                <tr>
                                    <th>Status</th>
                                    <td><span class="badge bg-{{ $user->business->status === 'verified' ? 'success' : 'warning' }}">{{ ucfirst($user->business->status) }}</span></td>
                                </tr>
                                <tr>
                                    <th>Subscription</th>
                                    <td><span class="badge bg-info">{{ ucfirst($user->business->subscription_status) }}</span></td>
                                </tr>
                                <tr>
                                    <th>Total Venues</th>
                                    <td>{{ $user->business->total_venues }}</td>
                                </tr>
                                <tr>
                                    <th>Total Offers</th>
                                    <td>{{ $user->business->total_offers }}</td>
                                </tr>
                            </table>
                            <a href="{{ route('admin.businesses.show', $user->business->id) }}" class="btn btn-sm btn-primary">
                                View Business Details
                            </a>
                        </div>
                        @endif

                        <!-- Subscriptions Tab -->
                        <div class="tab-pane fade" id="subscriptions">
                            @if($user->subscriptions && $user->subscriptions->count() > 0)
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Plan</th>
                                                <th>Status</th>
                                                <th>Start Date</th>
                                                <th>End Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($user->subscriptions as $subscription)
                                            <tr>
                                                <td>{{ $subscription->plan->name ?? 'N/A' }}</td>
                                                <td><span class="badge bg-{{ $subscription->status === 'active' ? 'success' : 'secondary' }}">{{ ucfirst($subscription->status) }}</span></td>
                                                <td>{{ $subscription->start_date->format('M d, Y') }}</td>
                                                <td>{{ $subscription->end_date->format('M d, Y') }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="text-center py-4">
                                    <i class="bi bi-inbox text-muted" style="font-size: 48px;"></i>
                                    <p class="text-muted mt-2">No subscriptions</p>
                                </div>
                            @endif
                        </div>

                        <!-- Activity Tab -->
                        <div class="tab-pane fade" id="activity">
                            <div class="timeline">
                                <div class="timeline-item">
                                    <i class="bi bi-person-check bg-success"></i>
                                    <div class="timeline-content">
                                        <h6>Account Created</h6>
                                        <p class="text-muted mb-0">{{ $user->created_at->format('M d, Y h:i A') }}</p>
                                    </div>
                                </div>
                                @if($user->email_verified_at)
                                <div class="timeline-item">
                                    <i class="bi bi-envelope-check bg-info"></i>
                                    <div class="timeline-content">
                                        <h6>Email Verified</h6>
                                        <p class="text-muted mb-0">{{ $user->email_verified_at->format('M d, Y h:i A') }}</p>
                                    </div>
                                </div>
                                @endif
                                @if($user->last_login_at)
                                <div class="timeline-item">
                                    <i class="bi bi-box-arrow-in-right bg-primary"></i>
                                    <div class="timeline-content">
                                        <h6>Last Login</h6>
                                        <p class="text-muted mb-0">{{ $user->last_login_at->format('M d, Y h:i A') }}</p>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.timeline {
    position: relative;
    padding: 20px 0;
}

.timeline-item {
    position: relative;
    padding-left: 60px;
    margin-bottom: 30px;
}

.timeline-item i {
    position: absolute;
    left: 0;
    top: 0;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 18px;
}

.timeline-item:not(:last-child)::before {
    content: '';
    position: absolute;
    left: 20px;
    top: 40px;
    width: 2px;
    height: calc(100% + 10px);
    background: #e9ecef;
}
</style>
@endsection
