@extends('layouts.admin')

@section('title', 'Edit Venue - ' . $venue->name)

@section('content')
    <div class="admin-header mb-4">
        <div>
            <h2>Edit Venue</h2>
            <p class="text-muted mb-0">Update venue details</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.venues.show', $venue->id) }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <form action="{{ route('admin.venues.update', $venue->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Basic Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Venue Name (English) <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                       name="name" value="{{ old('name', $venue->name) }}" required>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Venue Name (Arabic)</label>
                                <input type="text" class="form-control @error('name_ar') is-invalid @enderror"
                                       name="name_ar" value="{{ old('name_ar', $venue->name_ar) }}" dir="rtl">
                                @error('name_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Business <span class="text-danger">*</span></label>
                                <select class="form-select @error('business_id') is-invalid @enderror" name="business_id" required>
                                    <option value="">Select Business</option>
                                    @foreach($businesses as $business)
                                        <option value="{{ $business->id }}" {{ old('business_id', $venue->business_id) == $business->id ? 'selected' : '' }}>
                                            {{ $business->business_name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('business_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Category <span class="text-danger">*</span></label>
                                <select class="form-select @error('category_id') is-invalid @enderror" name="category_id" required>
                                    <option value="">Select Category</option>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ old('category_id', $venue->category_id) == $category->id ? 'selected' : '' }}>
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('category_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (English)</label>
                                <textarea class="form-control @error('description') is-invalid @enderror"
                                          name="description" rows="4">{{ old('description', $venue->description) }}</textarea>
                                @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (Arabic)</label>
                                <textarea class="form-control @error('description_ar') is-invalid @enderror"
                                          name="description_ar" rows="4" dir="rtl">{{ old('description_ar', $venue->description_ar) }}</textarea>
                                @error('description_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Location Details</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12">
                                <label class="form-label">Address <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('address') is-invalid @enderror"
                                       name="address" value="{{ old('address', $venue->address) }}" required>
                                @error('address')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">City <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('city') is-invalid @enderror"
                                       name="city" value="{{ old('city', $venue->city) }}" required>
                                @error('city')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">State/Emirate</label>
                                <input type="text" class="form-control @error('state') is-invalid @enderror"
                                       name="state" value="{{ old('state', $venue->state) }}">
                                @error('state')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Country <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('country') is-invalid @enderror"
                                       name="country" value="{{ old('country', $venue->country) }}" required>
                                @error('country')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Postal Code</label>
                                <input type="text" class="form-control @error('postal_code') is-invalid @enderror"
                                       name="postal_code" value="{{ old('postal_code', $venue->postal_code) }}">
                                @error('postal_code')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Latitude</label>
                                <input type="number" step="any" class="form-control @error('latitude') is-invalid @enderror"
                                       name="latitude" value="{{ old('latitude', $venue->latitude) }}">
                                @error('latitude')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Longitude</label>
                                <input type="number" step="any" class="form-control @error('longitude') is-invalid @enderror"
                                       name="longitude" value="{{ old('longitude', $venue->longitude) }}">
                                @error('longitude')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Contact Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label">Phone</label>
                                <input type="text" class="form-control @error('phone') is-invalid @enderror"
                                       name="phone" value="{{ old('phone', $venue->phone) }}">
                                @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Email</label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror"
                                       name="email" value="{{ old('email', $venue->email) }}">
                                @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Website</label>
                                <input type="url" class="form-control @error('website') is-invalid @enderror"
                                       name="website" value="{{ old('website', $venue->website) }}">
                                @error('website')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Settings</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Status <span class="text-danger">*</span></label>
                                <select class="form-select @error('status') is-invalid @enderror" name="status" required>
                                    <option value="active" {{ old('status', $venue->status) == 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="inactive" {{ old('status', $venue->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                    <option value="pending" {{ old('status', $venue->status) == 'pending' ? 'selected' : '' }}>Pending</option>
                                </select>
                                @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Featured</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="is_featured"
                                           value="1" {{ old('is_featured', $venue->is_featured) ? 'checked' : '' }}>
                                    <label class="form-check-label">Mark as featured venue</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-2"></i>Update Venue
                    </button>
                    <a href="{{ route('admin.venues.show', $venue->id) }}" class="btn btn-outline-secondary">
                        Cancel
                    </a>
                </div>
            </form>
        </div>

        <div class="col-lg-4">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Current Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="text-muted small">Business</label>
                        <div class="fw-semibold">{{ $venue->business->business_name }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Category</label>
                        <div class="fw-semibold">{{ $venue->category->name }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Status</label>
                        <div>
                            @if($venue->status === 'active')
                                <span class="badge bg-success">Active</span>
                            @elseif($venue->status === 'inactive')
                                <span class="badge bg-secondary">Inactive</span>
                            @else
                                <span class="badge bg-warning">Pending</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Total Offers</label>
                        <div class="fw-semibold">{{ $venue->offers()->count() }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Created</label>
                        <div>{{ $venue->created_at->format('M d, Y') }}</div>
                    </div>

                    <div class="mb-0">
                        <label class="text-muted small">Last Updated</label>
                        <div>{{ $venue->updated_at->format('M d, Y') }}</div>
                    </div>
                </div>
            </div>

            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <a href="{{ route('admin.venues.show', $venue->id) }}" class="btn btn-outline-primary w-100 mb-2">
                        <i class="bi bi-eye me-2"></i>View Venue
                    </a>
                    <a href="{{ route('admin.offers.index', ['venue_id' => $venue->id]) }}" class="btn btn-outline-secondary w-100">
                        <i class="bi bi-tag me-2"></i>View Offers
                    </a>
                </div>
            </div>
        </div>
    </div>
@endsection
