@extends('layouts.admin')

@section('title', 'Venues Management')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Venues Management</h2>
            <p class="text-muted mb-0">Manage and moderate business venues</p>
        </div>
    </div>

    <!-- Stats -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Total Venues</div>
                <div class="stat-value">{{ number_format($stats['total'] ?? 0) }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Active Venues</div>
                <div class="stat-value text-success">{{ number_format($stats['active'] ?? 0) }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Inactive Venues</div>
                <div class="stat-value text-danger">{{ number_format($stats['inactive'] ?? 0) }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-label">Featured Venues</div>
                <div class="stat-value text-primary">{{ number_format($stats['featured'] ?? 0) }}</div>
            </div>
        </div>
    </div>

    <!-- Venues Table -->
    <div class="admin-card">
        <div class="admin-card-header">
            <h5 class="mb-0 fw-bold">All Venues ({{ $venues->total() }})</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                    <tr>
                        <th>Venue</th>
                        <th>Business</th>
                        <th>Category</th>
                        <th>City</th>
                        <th>Status</th>
                        <th>Rating</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($venues as $venue)
                        <tr>
                            <td>
                                <div class="fw-semibold">{{ $venue->name }}</div>
                                <small class="text-muted">{{ Str::limit($venue->address ?? '', 30) }}</small>
                            </td>
                            <td>{{ $venue->business->business_name ?? 'N/A' }}</td>
                            <td>{{ $venue->category->name ?? 'N/A' }}</td>
                            <td>{{ $venue->city }}</td>
                            <td>
                            <span class="badge bg-{{ $venue->status === 'active' ? 'success' : 'danger' }}">
                                {{ ucfirst($venue->status) }}
                            </span>
                            </td>
                            <td>
                                <i class="bi bi-star-fill text-warning"></i> {{ number_format($venue->rating ?? 0, 1) }}
                            </td>
                            <td>{{ $venue->created_at->format('M d, Y') }}</td>
                            <td>
                                <a href="{{ route('admin.venues.show', $venue->id) }}" class="btn btn-sm btn-outline-primary" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="{{ route('admin.venues.edit', $venue->id) }}" class="btn btn-sm btn-outline-secondary" title="Edit">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                @if($venue->status !== 'active')
                                <form action="{{ route('admin.venues.approve', $venue->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-outline-success" title="Approve" onclick="return confirm('Approve this venue?')">
                                        <i class="bi bi-check-circle"></i>
                                    </button>
                                </form>
                                <a href="{{ route('admin.venues.reject-form', $venue->id) }}" class="btn btn-sm btn-outline-danger" title="Reject">
                                    <i class="bi bi-x-circle"></i>
                                </a>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">
                                <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                                No venues found
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($venues->hasPages())
            <div class="admin-card-footer">
                {{ $venues->links() }}
            </div>
        @endif
    </div>
@endsection
