@extends('layouts.business')

@section('title', 'Analytics Dashboard')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Analytics Dashboard</h2>
        <p class="text-muted mb-0">Track your business performance and insights</p>
    </div>
    <div class="btn-group">
        <button class="btn btn-outline-primary active">7 Days</button>
        <button class="btn btn-outline-primary">30 Days</button>
        <button class="btn btn-outline-primary">90 Days</button>
        <button class="btn btn-outline-primary">Custom</button>
    </div>
</div>

<!-- Key Metrics -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <i class="bi bi-eye text-white"></i>
            </div>
            <div class="stat-label">Total Views</div>
            <div class="stat-value">{{ number_format($analytics['total_views'] ?? 0) }}</div>
            <div class="stat-change positive">
                <i class="bi bi-arrow-up"></i> 23% vs last period
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                <i class="bi bi-qr-code text-white"></i>
            </div>
            <div class="stat-label">Redemptions</div>
            <div class="stat-value">{{ number_format($analytics['redemptions'] ?? 0) }}</div>
            <div class="stat-change positive">
                <i class="bi bi-arrow-up"></i> 15% vs last period
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                <i class="bi bi-percent text-white"></i>
            </div>
            <div class="stat-label">Conversion Rate</div>
            <div class="stat-value">{{ number_format($analytics['conversion_rate'] ?? 0, 1) }}%</div>
            <div class="stat-change negative">
                <i class="bi bi-arrow-down"></i> 2% vs last period
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                <i class="bi bi-people text-white"></i>
            </div>
            <div class="stat-label">Unique Users</div>
            <div class="stat-value">{{ number_format($analytics['unique_users'] ?? 0) }}</div>
            <div class="stat-change positive">
                <i class="bi bi-arrow-up"></i> 18% vs last period
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row g-4 mb-4">
    <!-- Views vs Redemptions Chart -->
    <div class="col-lg-8">
        <div class="table-card">
            <div class="card-header">
                <h5 class="mb-0 fw-bold">Views vs Redemptions</h5>
            </div>
            <div class="card-body">
                <canvas id="viewsRedemptionsChart" height="80"></canvas>
            </div>
        </div>
    </div>

    <!-- Traffic Sources -->
    <div class="col-lg-4">
        <div class="table-card h-100">
            <div class="card-header">
                <h5 class="mb-0 fw-bold">Traffic Sources</h5>
            </div>
            <div class="card-body">
                <canvas id="trafficSourcesChart"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Performance Tables -->
<div class="row g-4 mb-4">
    <!-- Top Performing Offers -->
    <div class="col-lg-6">
        <div class="table-card">
            <div class="card-header">
                <h5 class="mb-0 fw-bold">Top Performing Offers</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Offer</th>
                                <th>Views</th>
                                <th>Redemptions</th>
                                <th>Rate</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($topOffers ?? [] as $offer)
                            <tr>
                                <td>
                                    <div class="fw-semibold">{{ Str::limit($offer->title, 30) }}</div>
                                    <small class="text-muted">{{ $offer->venue->name ?? '' }}</small>
                                </td>
                                <td>{{ number_format($offer->view_count) }}</td>
                                <td>{{ $offer->redemption_count }}</td>
                                <td>
                                    <span class="badge bg-success">
                                        {{ number_format(($offer->redemption_count / max($offer->view_count, 1)) * 100, 1) }}%
                                    </span>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="4" class="text-center text-muted py-4">No data available</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Performing Venues -->
    <div class="col-lg-6">
        <div class="table-card">
            <div class="card-header">
                <h5 class="mb-0 fw-bold">Top Performing Venues</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Venue</th>
                                <th>Total Views</th>
                                <th>Rating</th>
                                <th>Reviews</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($topVenues ?? [] as $venue)
                            <tr>
                                <td>
                                    <div class="fw-semibold">{{ $venue->name }}</div>
                                    <small class="text-muted">{{ $venue->city }}</small>
                                </td>
                                <td>{{ number_format($venue->view_count) }}</td>
                                <td>
                                    <i class="bi bi-star-fill text-warning"></i>
                                    {{ number_format($venue->rating, 1) }}
                                </td>
                                <td>{{ $venue->total_reviews }}</td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="4" class="text-center text-muted py-4">No data available</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Peak Hours & Demographics -->
<div class="row g-4">
    <div class="col-lg-6">
        <div class="table-card">
            <div class="card-header">
                <h5 class="mb-0 fw-bold">Peak Activity Hours</h5>
            </div>
            <div class="card-body">
                <canvas id="peakHoursChart" height="60"></canvas>
            </div>
        </div>
    </div>

    <div class="col-lg-6">
        <div class="table-card">
            <div class="card-header">
                <h5 class="mb-0 fw-bold">User Demographics</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Female</span>
                        <span class="fw-semibold">{{ $demographics['female'] ?? 0 }}%</span>
                    </div>
                    <div class="progress" style="height: 8px;">
                        <div class="progress-bar" style="width: {{ $demographics['female'] ?? 0 }}%; background: #f093fb;"></div>
                    </div>
                </div>
                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Male</span>
                        <span class="fw-semibold">{{ $demographics['male'] ?? 0 }}%</span>
                    </div>
                    <div class="progress" style="height: 8px;">
                        <div class="progress-bar" style="width: {{ $demographics['male'] ?? 0 }}%; background: #667eea;"></div>
                    </div>
                </div>
                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Age 18-24</span>
                        <span class="fw-semibold">{{ $demographics['age_18_24'] ?? 0 }}%</span>
                    </div>
                    <div class="progress" style="height: 8px;">
                        <div class="progress-bar bg-info" style="width: {{ $demographics['age_18_24'] ?? 0 }}%;"></div>
                    </div>
                </div>
                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Age 25-34</span>
                        <span class="fw-semibold">{{ $demographics['age_25_34'] ?? 0 }}%</span>
                    </div>
                    <div class="progress" style="height: 8px;">
                        <div class="progress-bar bg-success" style="width: {{ $demographics['age_25_34'] ?? 0 }}%;"></div>
                    </div>
                </div>
                <div>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Age 35+</span>
                        <span class="fw-semibold">{{ $demographics['age_35_plus'] ?? 0 }}%</span>
                    </div>
                    <div class="progress" style="height: 8px;">
                        <div class="progress-bar bg-warning" style="width: {{ $demographics['age_35_plus'] ?? 0 }}%;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Views vs Redemptions Chart
    new Chart(document.getElementById('viewsRedemptionsChart'), {
        type: 'line',
        data: {
            labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
            datasets: [
                {
                    label: 'Views',
                    data: [120, 145, 132, 168, 155, 189, 175],
                    borderColor: '#667eea',
                    backgroundColor: 'rgba(102, 126, 234, 0.1)',
                    tension: 0.4,
                    fill: true
                },
                {
                    label: 'Redemptions',
                    data: [45, 52, 48, 65, 58, 72, 68],
                    borderColor: '#f093fb',
                    backgroundColor: 'rgba(240, 147, 251, 0.1)',
                    tension: 0.4,
                    fill: true
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: '#f3f4f6'
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });

    // Traffic Sources Chart
    new Chart(document.getElementById('trafficSourcesChart'), {
        type: 'doughnut',
        data: {
            labels: ['Direct', 'Social Media', 'Search', 'Referral'],
            datasets: [{
                data: [35, 30, 25, 10],
                backgroundColor: ['#667eea', '#f093fb', '#4facfe', '#43e97b']
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    // Peak Hours Chart
    new Chart(document.getElementById('peakHoursChart'), {
        type: 'bar',
        data: {
            labels: ['9AM', '11AM', '1PM', '3PM', '5PM', '7PM', '9PM'],
            datasets: [{
                label: 'Activity',
                data: [25, 45, 65, 55, 85, 95, 70],
                backgroundColor: 'rgba(102, 126, 234, 0.8)'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: '#f3f4f6'
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });
</script>
@endpush
