@extends('layouts.business')

@section('content')
<div class="container mt-4">
    <div class="row mb-4">
        <div class="col">
            <h1>Start New Chat</h1>
            <p class="text-muted">Create a conversation with your team members</p>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    @if(count($participants) > 0)
                        <form action="{{ route('business.chats.store') }}" method="POST">
                            @csrf

                            <!-- Subject -->
                            <div class="mb-4">
                                <label for="subject" class="form-label fw-bold">Chat Subject</label>
                                <input type="text" class="form-control @error('subject') is-invalid @enderror"
                                       id="subject" name="subject" value="{{ old('subject') }}"
                                       placeholder="e.g., Project Discussion" required>
                                @error('subject')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Participants -->
                            <div class="mb-4">
                                <label for="participants" class="form-label fw-bold">Select Team Members</label>
                                <div class="list-group" id="participants-list">
                                    @foreach($participants as $participant)
                                        <div class="list-group-item">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox"
                                                       id="participant{{ $participant['id'] }}"
                                                       name="participant_ids[]"
                                                       value="{{ $participant['id'] }}"
                                                       {{ in_array($participant['id'], old('participant_ids', [])) ? 'checked' : '' }}>
                                                <label class="form-check-label w-100" for="participant{{ $participant['id'] }}">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <div>
                                                            <strong>{{ $participant['name'] }}</strong>
                                                            <br>
                                                            <small class="text-muted">{{ $participant['email'] }}</small>
                                                        </div>
                                                        <span class="badge bg-info">{{ ucfirst($participant['role']) }}</span>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                <small class="text-muted d-block mt-2">
                                    Select one or more team members to include in the chat
                                </small>
                                @error('participant_ids')
                                    <div class="text-danger mt-2">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Initial Message -->
                            <div class="mb-4">
                                <label for="message" class="form-label fw-bold">Initial Message (Optional)</label>
                                <textarea class="form-control @error('message') is-invalid @enderror"
                                          id="message" name="message" rows="4"
                                          placeholder="Type your first message...">{{ old('message') }}</textarea>
                                @error('message')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Buttons -->
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-chat-dots"></i> Start Chat
                                </button>
                                <a href="{{ route('business.chats.index') }}" class="btn btn-secondary">
                                    Cancel
                                </a>
                            </div>
                        </form>
                    @else
                        <div class="alert alert-info text-center">
                            <i class="bi bi-info-circle" style="font-size: 2rem;"></i>
                            <h5 class="mt-3">No Team Members Available</h5>
                            <p class="text-muted mb-0">You need to have active team members to start a chat. Please invite team members first.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card bg-light">
                <div class="card-body">
                    <h5 class="card-title">Tips</h5>
                    <ul class="small mb-0">
                        <li>Only active team members appear here</li>
                        <li>You can start a direct message or group chat</li>
                        <li>All participants will be notified</li>
                        <li>Optionally send a first message</li>
                        <li>Only you can delete the chat</li>
                    </ul>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-body">
                    <h5 class="card-title text-info">Business Only</h5>
                    <p class="small mb-0">
                        <strong>Only your business team members</strong> are shown here. You can only chat with people in your organization.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

