@extends('layouts.business')

@section('content')
<div class="container mt-4">
    <div class="row mb-4">
        <div class="col">
            <h1>Chat</h1>
            <p class="text-muted">Communicate with your team members</p>
        </div>
        <div class="col-auto">
            <a href="{{ route('business.chats.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> New Chat
            </a>
        </div>
    </div>

    @if($chats->count() > 0)
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="list-group list-group-flush">
                        @foreach($chats as $chat)
                            <a href="{{ route('business.chats.show', $chat) }}" class="list-group-item list-group-item-action {{ !$chat->is_active ? 'disabled opacity-50' : '' }}">
                                <div class="d-flex w-100 justify-content-between align-items-start">
                                    <div class="flex-grow-1">
                                        <h6 class="mb-1">
                                            @if($chat->type === 'group')
                                                <i class="bi bi-people-fill"></i>
                                            @else
                                                <i class="bi bi-person-circle"></i>
                                            @endif
                                            {{ $chat->subject }}
                                            @if(!$chat->is_active)
                                            <span class="badge bg-danger">Disabled</span>
                                            @endif
                                        </h6>
                                        <p class="mb-1 text-muted small">
                                            @if($chat->messages->count() > 0)
                                                {{ Str::limit($chat->messages->first()->content, 60) }}
                                            @else
                                                No messages yet
                                            @endif
                                        </p>
                                        <small class="text-muted">
                                            {{ $chat->participants->count() }} participant{{ $chat->participants->count() !== 1 ? 's' : '' }}
                                        </small>
                                    </div>
                                    <div class="text-end">
                                        <small class="text-muted">{{ $chat->updated_at->diffForHumans() }}</small>
                                    </div>
                                </div>
                            </a>
                        @endforeach
                    </div>
                </div>

                <!-- Pagination -->
                <div class="mt-4">
                    {{ $chats->links() }}
                </div>
            </div>
        </div>
    @else
        <div class="row">
            <div class="col">
                <div class="alert alert-info text-center">
                    <i class="bi bi-chat-left-text" style="font-size: 3rem;"></i>
                    <h4 class="mt-3">No chats yet</h4>
                    <p class="text-muted mb-3">Start a conversation with your team members</p>
                    <a href="{{ route('business.chats.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Create New Chat
                    </a>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection

