@extends('layouts.business')

@section('content')
<div class="container-fluid mt-4">
    <div class="row" style="height: calc(100vh - 100px);">
        <!-- Chat Header -->
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-3 pb-3 border-bottom">
                <div>
                    <h4 class="mb-0">
                        @if($chat->type === 'group')
                            <i class="bi bi-people-fill"></i>
                        @else
                            <i class="bi bi-person-circle"></i>
                        @endif
                        {{ $chat->subject }}
                    </h4>
                    <small class="text-muted">{{ $chat->participants->count() }} participant{{ $chat->participants->count() !== 1 ? 's' : '' }}</small>
                </div>
                <div>
                    <a href="{{ route('business.chats.index') }}" class="btn btn-sm btn-secondary">
                        <i class="bi bi-arrow-left"></i> Back
                    </a>
                    @if(auth()->id() === $chat->created_by)
                        <form action="{{ route('business.chats.destroy', $chat) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this chat?')">
                                <i class="bi bi-trash"></i>
                            </button>
                        </form>
                    @endif
                </div>
            </div>
        </div>

        <!-- Messages Area -->
        <div class="col-12" style="overflow-y: auto; height: calc(100% - 120px); background: #f8f9fa;">
            @if(!$chat->is_active)
            <div class="alert alert-warning m-3" role="alert">
                <i class="bi bi-exclamation-triangle"></i>
                <strong>Chat Disabled</strong> - This chat has been disabled by an administrator. You can view previous messages but cannot send new messages.
            </div>
            @endif
            <div id="messages-container" class="p-3">
                @forelse($messages as $message)
                    <div class="mb-3 d-flex {{ $message->sender_id === auth()->id() ? 'justify-content-end' : '' }}">
                        <div class="card {{ $message->sender_id === auth()->id() ? 'bg-primary text-white' : 'bg-white' }}"
                             style="max-width: 70%;">
                            <div class="card-body py-2 px-3">
                                @if($chat->type === 'group' && $message->sender_id !== auth()->id())
                                    <small class="d-block fw-bold mb-1">{{ $message->sender->first_name }} {{ $message->sender->last_name }}</small>
                                @endif
                                <p class="mb-0">{{ $message->content }}</p>
                                <small class="d-block mt-2 {{ $message->sender_id === auth()->id() ? 'text-white-50' : 'text-muted' }}">
                                    {{ $message->created_at->format('H:i') }}
                                </small>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="alert alert-info text-center">
                        <p class="mb-0">No messages yet. Start the conversation!</p>
                    </div>
                @endforelse
            </div>
        </div>

        <!-- Message Input Area -->
        @if($chat->is_active)
        <div class="col-12 border-top pt-3" style="height: auto;">
            <form action="{{ route('business.chats.send-message', $chat) }}" method="POST" class="d-flex gap-2">
                @csrf
                <input type="text" class="form-control" name="message" placeholder="Type a message..." required
                       autocomplete="off">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-send"></i> Send
                </button>
            </form>
        </div>
        @else
        <div class="col-12 border-top pt-3 bg-light" style="height: auto;">
            <div class="alert alert-danger mb-0">
                <i class="bi bi-lock-fill"></i> This chat is disabled. Messages cannot be sent.
            </div>
        </div>
        @endif
    </div>
</div>

<script>
// Auto-scroll to latest message
document.getElementById('messages-container').scrollTop = document.getElementById('messages-container').scrollHeight;
</script>
@endsection

