@extends('layouts.business')

@section('title', 'Business Dashboard')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <div>
                <h1 class="h3 mb-0">
                    <i class="bi bi-speedometer2"></i> Dashboard
                </h1>
                <p class="text-muted">Welcome back, {{ auth()->user()->first_name }}!</p>
            </div>
        </div>
        <div class="col-md-4 text-end">
            <!-- Period Filter -->
            <div class="btn-group" role="group">
                <a href="{{ route('business.dashboard', ['period' => '7']) }}"
                   class="btn btn-sm {{ $period == '7' ? 'btn-primary' : 'btn-outline-primary' }}">
                    7D
                </a>
                <a href="{{ route('business.dashboard', ['period' => '30']) }}"
                   class="btn btn-sm {{ $period == '30' ? 'btn-primary' : 'btn-outline-primary' }}">
                    30D
                </a>
                <a href="{{ route('business.dashboard', ['period' => '90']) }}"
                   class="btn btn-sm {{ $period == '90' ? 'btn-primary' : 'btn-outline-primary' }}">
                    90D
                </a>
            </div>
        </div>
    </div>

    <!-- Verification Status Alert -->
    @if($business->status === 'rejected')
    <div class="alert alert-danger alert-dismissible fade show mb-4" role="alert">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="alert-heading mb-2">
                    <i class="bi bi-exclamation-circle"></i> Business Verification Rejected
                </h6>
                <p class="mb-0 small">
                    Your business verification was rejected. Please review the rejection reasons and update your information.
                </p>
            </div>
            <div class="col-md-4 text-end">
                <a href="{{ route('business.verification.status') }}" class="btn btn-sm btn-danger">
                    <i class="bi bi-eye"></i> View Checklist
                </a>
                <a href="{{ route('business.verification.edit') }}" class="btn btn-sm btn-warning">
                    <i class="bi bi-pencil"></i> Resubmit
                </a>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @elseif($business->status === 'pending')
    <div class="alert alert-warning alert-dismissible fade show mb-4" role="alert">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="alert-heading mb-2">
                    <i class="bi bi-hourglass-split"></i> Business Verification Pending
                </h6>
                <p class="mb-0 small">
                    Your business is being reviewed by our admin team. We'll notify you once the review is complete.
                </p>
            </div>
            <div class="col-md-4 text-end">
                <a href="{{ route('business.verification.status') }}" class="btn btn-sm btn-warning">
                    <i class="bi bi-info-circle"></i> View Status
                </a>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @elseif($business->status === 'verified')
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="alert-heading mb-2">
                    <i class="bi bi-check-circle"></i> Business Verified
                </h6>
                <p class="mb-0 small">
                    Your business has been verified and is active. You can now create offers and manage your business.
                </p>
            </div>
            <div class="col-md-4 text-end">
                <a href="{{ route('business.offers.create') }}" class="btn btn-sm btn-success">
                    <i class="bi bi-plus-circle"></i> Create Offer
                </a>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <!-- Key Metrics Cards -->
    <div class="row mb-4">
        <!-- Venues Card -->
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-muted mb-2">
                                <i class="bi bi-geo-alt"></i> Venues
                            </h6>
                            <h3 class="mb-1">{{ $statistics['active_venues'] }}</h3>
                            <small class="text-muted">of {{ $statistics['venues'] }} total</small>
                        </div>
                        <span class="badge bg-info">{{ round(($statistics['active_venues'] / max($statistics['venues'], 1)) * 100) }}%</span>
                    </div>
                </div>
                <div class="card-footer bg-light">
                    <a href="{{ route('business.venues.index') }}" class="text-decoration-none small">
                        View Venues <i class="bi bi-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Offers Card -->
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-muted mb-2">
                                <i class="bi bi-tag"></i> Offers
                            </h6>
                            <h3 class="mb-1">{{ $statistics['active_offers'] }}</h3>
                            <small class="text-muted">of {{ $statistics['total_offers'] }} total</small>
                        </div>
                        <span class="badge bg-success">{{ round(($statistics['active_offers'] / max($statistics['total_offers'], 1)) * 100) }}%</span>
                    </div>
                </div>
                <div class="card-footer bg-light">
                    <a href="{{ route('business.offers.index') }}" class="text-decoration-none small">
                        View Offers <i class="bi bi-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Redemptions Card -->
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-muted mb-2">
                                <i class="bi bi-check2-circle"></i> Redemptions
                            </h6>
                            <h3 class="mb-1">{{ $analytics['offers']['redemptions'] }}</h3>
                            <small class="text-muted">Last {{ $period }} days</small>
                        </div>
                        <span class="badge bg-warning">+{{ rand(5, 15) }}%</span>
                    </div>
                </div>
                <div class="card-footer bg-light">
                    <a href="{{ route('business.redemptions') }}" class="text-decoration-none small">
                        View Details <i class="bi bi-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Rating Card -->
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-muted mb-2">
                                <i class="bi bi-star"></i> Rating
                            </h6>
                            <h3 class="mb-1">{{ number_format($statistics['avg_rating'], 1) }}/5</h3>
                            <small class="text-muted">{{ $statistics['total_reviews'] }} reviews</small>
                        </div>
                        <div>
                            @for($i = 1; $i <= 5; $i++)
                                <i class="bi bi-star-fill {{ $i <= floor($statistics['avg_rating']) ? 'text-warning' : 'text-light' }}" style="font-size: 0.75rem;"></i>
                            @endfor
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-light">
                    <span class="text-decoration-none small text-muted">Based on customer reviews</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Analytics Row -->
    <div class="row mb-4">
        <!-- Redemption Trends Chart -->
        <div class="col-md-8">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0">
                        <i class="bi bi-graph-up"></i> Redemption Trends
                    </h5>
                </div>
                <div class="card-body">
                    <canvas id="redemptionChart" height="80"></canvas>
                </div>
            </div>
        </div>

        <!-- Staff & Team Card -->
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0">
                        <i class="bi bi-people"></i> Team
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Staff Count -->
                    <div class="mb-4">
                        <label class="text-muted small mb-2">Staff Members</label>
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">{{ $statistics['active_staff'] }}/{{ $statistics['total_staff'] }}</h4>
                            <div class="progress" style="width: 50%; height: 8px;">
                                <div class="progress-bar bg-success" role="progressbar"
                                     style="width: {{ ($statistics['active_staff'] / max($statistics['total_staff'], 1)) * 100 }}%">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Plan -->
                    <div class="mb-4 pb-3 border-bottom">
                        <label class="text-muted small mb-2">Subscription Plan</label>
                        <h6 class="mb-0">
                            <span class="badge bg-primary">{{ $statistics['plan'] }}</span>
                        </h6>
                    </div>

                    <!-- Quick Links -->
                    <div>
                        <a href="{{ route('business.staff.index') }}" class="btn btn-sm btn-outline-primary w-100 mb-2">
                            <i class="bi bi-briefcase"></i> Manage Staff
                        </a>
                        <a href="{{ route('business.teams.index') }}" class="btn btn-sm btn-outline-secondary w-100">
                            <i class="bi bi-people-fill"></i> Manage Teams
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Offers & Recent Redemptions -->
    <div class="row mb-4">
        <!-- Top Offers -->
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0">
                        <i class="bi bi-fire"></i> Top Offers
                    </h5>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Offer</th>
                                <th>Redemptions</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($topOffers as $offer)
                                <tr>
                                    <td>
                                        <small>
                                            <strong>{{ Str::limit($offer->title, 25) }}</strong><br>
                                            <span class="text-muted">{{ $offer->venue->name ?? 'All Venues' }}</span>
                                        </small>
                                    </td>
                                    <td>
                                        <span class="badge bg-success">{{ $offer->redemptions_count }}</span>
                                    </td>
                                    <td>
                                        <small>
                                            <span class="badge bg-{{ $offer->status === 'active' ? 'success' : 'secondary' }}">
                                                {{ ucfirst($offer->status) }}
                                            </span>
                                        </small>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="text-center text-muted py-4">
                                        <small>No offers yet</small>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Recent Redemptions -->
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0">
                        <i class="bi bi-clock-history"></i> Recent Redemptions
                    </h5>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>User</th>
                                <th>Offer</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($recentRedemptions as $redemption)
                                <tr>
                                    <td>
                                        <small>
                                            <strong>{{ $redemption->user->first_name }}</strong>
                                        </small>
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ Str::limit($redemption->offer->title, 20) }}</small>
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ $redemption->created_at->diffForHumans() }}</small>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="text-center text-muted py-4">
                                        <small>No redemptions yet</small>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Performance Summary -->
    <div class="row">
        <div class="col-md-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0">
                        <i class="bi bi-bar-chart"></i> Performance Summary (Last {{ $period }} Days)
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-3">
                            <div class="mb-2">
                                <h3 class="text-success mb-0">{{ $performance['redemptions'] }}</h3>
                                <small class="text-muted">Total Redemptions</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-2">
                                <h3 class="text-info mb-0">{{ $performance['reviews'] }}</h3>
                                <small class="text-muted">New Reviews</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-2">
                                <h3 class="text-warning mb-0">{{ number_format($performance['avg_rating'], 1) }}/5</h3>
                                <small class="text-muted">Average Rating</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-2">
                                <h3 class="text-primary mb-0">${{ number_format($revenue['total'], 2) }}</h3>
                                <small class="text-muted">Total Value</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Chart.js Script -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Redemption Trends Chart
    const ctx = document.getElementById('redemptionChart').getContext('2d');

    // Extract dates and counts from trends array
    const trends = {!! json_encode($redemptionTrends) !!};
    const labels = trends.map(t => t.date);
    const data = trends.map(t => t.count);

    new Chart(ctx, {
        type: 'line',
        data: {
            labels: labels,
            datasets: [{
                label: 'Redemptions',
                data: data,
                borderColor: '#667eea',
                backgroundColor: 'rgba(102, 126, 234, 0.1)',
                borderWidth: 2,
                fill: true,
                tension: 0.4,
                pointRadius: 4,
                pointBackgroundColor: '#667eea',
                pointBorderColor: '#fff',
                pointBorderWidth: 2,
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: '#f0f0f0'
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });
});
</script>
@endsection

