@extends('layouts.business')

@section('title', 'My Campaigns')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h1 class="h3 mb-0">My Marketing Campaigns</h1>
            <p class="text-muted">Manage and monitor your marketing campaigns</p>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0">{{ $stats['total'] ?? 0 }}</h3>
                    <p class="text-muted mb-0">Total Campaigns</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0 text-success">{{ $stats['active'] ?? 0 }}</h3>
                    <p class="text-muted mb-0">Active</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0 text-warning">{{ $stats['pending'] ?? 0 }}</h3>
                    <p class="text-muted mb-0">Pending</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="mb-0 text-info">{{ $stats['completed'] ?? 0 }}</h3>
                    <p class="text-muted mb-0">Completed</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Horizontal Tabs Navigation -->
{{--    <div class="card mb-4">--}}
{{--        <div class="card-body p-0">--}}
{{--            <ul class="nav nav-tabs" id="campaignsFilterTabs" role="tablist">--}}
{{--                <li class="nav-item" role="presentation">--}}
{{--                    <a class="nav-link active" id="all-tab" href="{{ route('business.marketing.campaigns') }}" role="tab">--}}
{{--                        <i class="bi bi-list me-2"></i> All Campaigns--}}
{{--                    </a>--}}
{{--                </li>--}}
{{--                <li class="nav-item" role="presentation">--}}
{{--                    <a class="nav-link" id="active-tab" href="{{ route('business.marketing.campaigns', ['status' => 'active']) }}" role="tab">--}}
{{--                        <i class="bi bi-play-circle me-2"></i> Active--}}
{{--                    </a>--}}
{{--                </li>--}}
{{--                <li class="nav-item" role="presentation">--}}
{{--                    <a class="nav-link" id="pending-tab" href="{{ route('business.marketing.campaigns', ['status' => 'pending']) }}" role="tab">--}}
{{--                        <i class="bi bi-hourglass-split me-2"></i> Pending--}}
{{--                    </a>--}}
{{--                </li>--}}
{{--                <li class="nav-item" role="presentation">--}}
{{--                    <a class="nav-link" id="paused-tab" href="{{ route('business.marketing.campaigns', ['status' => 'paused']) }}" role="tab">--}}
{{--                        <i class="bi bi-pause-circle me-2"></i> Paused--}}
{{--                    </a>--}}
{{--                </li>--}}
{{--                <li class="nav-item" role="presentation">--}}
{{--                    <a class="nav-link" id="completed-tab" href="{{ route('business.marketing.campaigns', ['status' => 'completed']) }}" role="tab">--}}
{{--                        <i class="bi bi-check-circle me-2"></i> Completed--}}
{{--                    </a>--}}
{{--                </li>--}}
{{--            </ul>--}}
{{--        </div>--}}
{{--    </div>--}}

    <!-- Campaigns Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Campaign Name</th>
                        <th>Type</th>
                        <th>Duration</th>
                        <th>Budget</th>
                        <th>Status</th>
                        <th>Performance</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($campaigns as $campaign)
                    <tr>
                        <td>
                            <strong>{{ $campaign->name }}</strong>
                            <br>
                            <small class="text-muted">{{ Str::limit($campaign->description, 40) }}</small>
                        </td>
                        <td>
                            <span class="badge bg-secondary">{{ ucfirst($campaign->type ?? 'N/A') }}</span>
                        </td>
                        <td>
                            <small>{{ $campaign->start_date->format('M d') }} - {{ $campaign->end_date->format('M d, Y') }}</small>
                        </td>
                        <td>
                            <strong>AED {{ number_format($campaign->budget, 2) }}</strong>
                        </td>
                        <td>
                            <span class="badge bg-{{ $campaign->status === 'active' ? 'success' : ($campaign->status === 'pending' ? 'warning' : ($campaign->status === 'paused' ? 'secondary' : 'info')) }}">
                                {{ ucfirst($campaign->status) }}
                            </span>
                        </td>
                        <td>
                            @if($campaign->analytics && count($campaign->analytics) > 0)
                                @php
                                    $totalClicks = $campaign->analytics->sum('clicks');
                                    $totalImpressions = $campaign->analytics->sum('impressions');
                                    $ctr = $totalImpressions > 0 ? round(($totalClicks / $totalImpressions) * 100, 2) : 0;
                                @endphp
                                <small>
                                    <i class="bi bi-eye"></i> {{ number_format($totalImpressions) }}
                                    <i class="bi bi-hand-index"></i> {{ number_format($totalClicks) }}
                                    <br>
                                    <strong>CTR: {{ $ctr }}%</strong>
                                </small>
                            @else
                                <small class="text-muted">No data yet</small>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('business.marketing.campaign.view', $campaign->id) }}" class="btn btn-sm btn-info" title="View Details">
                                <i class="bi bi-eye"></i>
                            </a>
                            @if($campaign->status === 'active')
                            <button class="btn btn-sm btn-warning" onclick="pauseCampaign({{ $campaign->id }})" title="Pause">
                                <i class="bi bi-pause-circle"></i>
                            </button>
                            @elseif($campaign->status === 'paused')
                            <button class="btn btn-sm btn-success" onclick="resumeCampaign({{ $campaign->id }})" title="Resume">
                                <i class="bi bi-play-circle"></i>
                            </button>
                            @endif
                            @if($campaign->status === 'pending')
                            <button class="btn btn-sm btn-danger" onclick="deleteCampaign({{ $campaign->id }})" title="Delete">
                                <i class="bi bi-trash"></i>
                            </button>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center py-4 text-muted">
                            <i class="bi bi-inbox" style="font-size: 2rem;"></i>
                            <p class="mt-2">No campaigns found</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($campaigns->hasPages())
        <div class="card-footer">
            {{ $campaigns->links() }}
        </div>
        @endif
    </div>
</div>

<script>
function pauseCampaign(campaignId) {
    if (confirm('Are you sure you want to pause this campaign?')) {
        fetch(`/business/marketing/campaign/${campaignId}/pause`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Campaign paused successfully');
                location.reload();
            } else {
                alert('Error: ' + (data.message || 'Failed to pause campaign'));
            }
        })
        .catch(error => alert('Error: ' + error.message));
    }
}

function resumeCampaign(campaignId) {
    if (confirm('Are you sure you want to resume this campaign?')) {
        fetch(`/business/marketing/campaign/${campaignId}/resume`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Campaign resumed successfully');
                location.reload();
            } else {
                alert('Error: ' + (data.message || 'Failed to resume campaign'));
            }
        })
        .catch(error => alert('Error: ' + error.message));
    }
}

function deleteCampaign(campaignId) {
    if (confirm('Are you sure you want to delete this campaign? This cannot be undone.')) {
        fetch(`/business/marketing/campaign/${campaignId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Campaign deleted successfully');
                location.reload();
            } else {
                alert('Error: ' + (data.message || 'Failed to delete campaign'));
            }
        })
        .catch(error => alert('Error: ' + error.message));
    }
}
</script>
@endsection

