@extends('layouts.business')

@section('title', 'Create Campaign')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h2 fw-bold mb-0">
                <i class="fas fa-plus me-2"></i>Create Marketing Campaign
            </h1>
            <p class="text-muted">Create a new banner campaign to promote your business</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('business.marketing.campaigns') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to Campaigns
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow-sm border-0">
                <div class="card-header bg-light py-3">
                    <h5 class="mb-0 fw-bold">Campaign Details</h5>
                </div>
                <div class="card-body p-4">
                    <form action="{{ route('business.marketing.campaigns.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <!-- Campaign Name -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Campaign Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                                   value="{{ old('name') }}" placeholder="e.g., Summer Sale 2025" required>
                            @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Description -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Description <span class="text-danger">*</span></label>
                            <textarea name="description" class="form-control @error('description') is-invalid @enderror"
                                      rows="3" placeholder="Describe your campaign" required>{{ old('description') }}</textarea>
                            @error('description')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Campaign Type -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Campaign Type <span class="text-danger">*</span></label>
                            <select name="type" class="form-select @error('type') is-invalid @enderror" required>
                                <option value="">Select Type</option>
                                <option value="banner" {{ old('type') === 'banner' ? 'selected' : '' }}>Banner</option>
                                <option value="spotlight" {{ old('type') === 'spotlight' ? 'selected' : '' }}>Spotlight</option>
                            </select>
                            @error('type')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Banner Image -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Banner Image <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="file" name="banner_image" class="form-control @error('banner_image') is-invalid @enderror"
                                       accept="image/*" required>
                                <small class="form-text text-muted d-block mt-1">Recommended size: 1200x300px. Max 5MB</small>
                            </div>
                            @error('banner_image')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <!-- Date Range -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Start Date <span class="text-danger">*</span></label>
                                <input type="datetime-local" name="start_date" class="form-control @error('start_date') is-invalid @enderror"
                                       value="{{ old('start_date') }}" required>
                                @error('start_date')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold">End Date <span class="text-danger">*</span></label>
                                <input type="datetime-local" name="end_date" class="form-control @error('end_date') is-invalid @enderror"
                                       value="{{ old('end_date') }}" required>
                                @error('end_date')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                        </div>

                        <!-- Budget -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Budget (AED) <span class="text-danger">*</span></label>
                                <input type="number" step="0.01" name="budget" class="form-control @error('budget') is-invalid @enderror"
                                       value="{{ old('budget') }}" required>
                                @error('budget')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Currency</label>
                                <select name="currency" class="form-select">
                                    <option value="AED" selected>AED</option>
                                    <option value="USD">USD</option>
                                    <option value="EUR">EUR</option>
                                </select>
                            </div>
                        </div>

                        <!-- Goals -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Campaign Goals (Optional)</label>
                            <textarea name="goals" class="form-control" rows="2"
                                      placeholder="e.g., Increase brand awareness, Drive sales...">{{ old('goals') }}</textarea>
                        </div>

                        <!-- Submit -->
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-check me-2"></i>Create Campaign
                            </button>
                            <a href="{{ route('business.marketing.campaigns') }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Info Sidebar -->
        <div class="col-lg-4">
            <div class="card shadow-sm border-0 mb-3">
                <div class="card-header bg-light py-3">
                    <h6 class="mb-0 fw-bold">Campaign Tips</h6>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled small">
                        <li class="mb-2">
                            <i class="fas fa-lightbulb text-warning me-2"></i>
                            Use clear, attractive banner images
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-lightbulb text-warning me-2"></i>
                            Write compelling descriptions
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-lightbulb text-warning me-2"></i>
                            Set realistic budgets
                        </li>
                        <li class="mb-2">
                            <i class="fas fa-lightbulb text-warning me-2"></i>
                            Target your audience
                        </li>
                    </ul>
                </div>
            </div>

            <div class="card shadow-sm border-0">
                <div class="card-header bg-light py-3">
                    <h6 class="mb-0 fw-bold">Check Your Plan</h6>
                </div>
                <div class="card-body">
                    <p class="text-muted small mb-3">Make sure your plan includes campaigns</p>
                    <a href="{{ route('business.subscription.index') }}" class="btn btn-sm btn-outline-primary w-100">
                        <i class="fas fa-check me-1"></i>View Plan Details
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

