@extends('layouts.business')

@section('title', 'Campaign Details')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">{{ $campaign->name }}</h1>
            <p class="text-muted">Campaign Details & Performance</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('business.marketing.campaigns') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <!-- Campaign Status -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <p class="text-muted mb-1">Status</p>
                            <h5 class="mb-0">
                                <span class="badge bg-{{ $campaign->status === 'active' ? 'success' : ($campaign->status === 'pending' ? 'warning' : 'secondary') }}">
                                    {{ ucfirst($campaign->status) }}
                                </span>
                            </h5>
                        </div>
                        <div class="col-md-3">
                            <p class="text-muted mb-1">Duration</p>
                            <h5 class="mb-0">{{ $campaign->start_date->format('M d') }} - {{ $campaign->end_date->format('M d, Y') }}</h5>
                        </div>
                        <div class="col-md-3">
                            <p class="text-muted mb-1">Budget</p>
                            <h5 class="mb-0">AED {{ number_format($campaign->budget, 2) }}</h5>
                        </div>
                        <div class="col-md-3">
                            <p class="text-muted mb-1">Type</p>
                            <h5 class="mb-0">{{ ucfirst($campaign->type) }}</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Campaign Details & Performance Tabs -->
    <div class="row mb-4">
        <div class="col-md-12">
            <ul class="nav nav-tabs mb-3" id="campaignTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="details-tab" data-bs-toggle="tab" data-bs-target="#details" type="button" role="tab" aria-controls="details" aria-selected="true">
                        <i class="bi bi-info-circle me-2"></i> Details
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="performance-tab" data-bs-toggle="tab" data-bs-target="#performance" type="button" role="tab" aria-controls="performance" aria-selected="false">
                        <i class="bi bi-graph-up me-2"></i> Performance
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="analytics-tab" data-bs-toggle="tab" data-bs-target="#analytics" type="button" role="tab" aria-controls="analytics" aria-selected="false">
                        <i class="bi bi-bar-chart me-2"></i> Analytics
                    </button>
                </li>
            </ul>

            <div class="tab-content" id="campaignTabContent">
                <!-- Details Tab -->
                <div class="tab-pane fade show active" id="details" role="tabpanel" aria-labelledby="details-tab">
                    <div class="card">
                        <div class="card-body">
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Campaign Name</p>
                                    <h5>{{ $campaign->name }}</h5>
                                </div>
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Package</p>
                                    <h5>{{ $campaign->package->name ?? 'N/A' }}</h5>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <p class="text-muted mb-1">Description</p>
                                    <p>{{ $campaign->description ?? 'No description' }}</p>
                                </div>
                            </div>

                            @if($campaign->venue)
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Target Venue</p>
                                    <p>{{ $campaign->venue->name }}</p>
                                </div>
                            </div>
                            @endif

                            @if($campaign->offer)
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Target Offer</p>
                                    <p>{{ $campaign->offer->name }}</p>
                                </div>
                            </div>
                            @endif

                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <p class="text-muted mb-1">Campaign Goals</p>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <p><strong>Impressions Target:</strong> {{ number_format($campaign->goals['impressions'] ?? 0) }}</p>
                                        </div>
                                        <div class="col-md-4">
                                            <p><strong>Clicks Target:</strong> {{ number_format($campaign->goals['clicks'] ?? 0) }}</p>
                                        </div>
                                        <div class="col-md-4">
                                            <p><strong>Conversions Target:</strong> {{ number_format($campaign->goals['conversions'] ?? 0) }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Performance Tab -->
                <div class="tab-pane fade" id="performance" role="tabpanel" aria-labelledby="performance-tab">
                    <div class="card">
                        <div class="card-body">
                            <div class="row mb-4">
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <h3 class="mb-1">{{ $aggregatedStats['total_impressions'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">Total Impressions</p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <h3 class="mb-1">{{ $aggregatedStats['total_clicks'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">Total Clicks</p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <h3 class="mb-1">{{ $aggregatedStats['total_conversions'] ?? 0 }}</h3>
                                        <p class="text-muted mb-0">Total Conversions</p>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <h3 class="mb-1">{{ round($aggregatedStats['average_ctr'] ?? 0, 2) }}%</h3>
                                        <p class="text-muted mb-0">Click-through Rate</p>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Cost Per Click</p>
                                    <h4>AED {{ $aggregatedStats['cost_per_click'] ?? '0.00' }}</h4>
                                </div>
                                <div class="col-md-6">
                                    <p class="text-muted mb-1">Cost Per Impression (CPM)</p>
                                    <h4>AED {{ $aggregatedStats['cost_per_impression'] ?? '0.00' }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Analytics Tab -->
                <div class="tab-pane fade" id="analytics" role="tabpanel" aria-labelledby="analytics-tab">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="mb-3">Daily Analytics</h5>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Date</th>
                                            <th>Impressions</th>
                                            <th>Clicks</th>
                                            <th>Conversions</th>
                                            <th>CTR</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($analytics as $analytic)
                                        <tr>
                                            <td>{{ $analytic->date->format('M d, Y') }}</td>
                                            <td>{{ number_format($analytic->impressions) }}</td>
                                            <td>{{ number_format($analytic->clicks) }}</td>
                                            <td>{{ number_format($analytic->conversions) }}</td>
                                            <td>{{ round($analytic->ctr, 2) }}%</td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="5" class="text-center text-muted py-4">No analytics data available</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Campaign Actions -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="mb-3">Campaign Actions</h5>
                    <div class="btn-group" role="group">
                        @if($campaign->status === 'active')
                        <button type="button" class="btn btn-warning" onclick="pauseCampaign({{ $campaign->id }})">
                            <i class="bi bi-pause-circle me-2"></i> Pause Campaign
                        </button>
                        @elseif($campaign->status === 'paused')
                        <button type="button" class="btn btn-success" onclick="resumeCampaign({{ $campaign->id }})">
                            <i class="bi bi-play-circle me-2"></i> Resume Campaign
                        </button>
                        @endif

                        <button type="button" class="btn btn-info" onclick="exportReport({{ $campaign->id }})">
                            <i class="bi bi-download me-2"></i> Export Report
                        </button>

                        @if($campaign->status === 'pending')
                        <button type="button" class="btn btn-danger" onclick="deleteCampaign({{ $campaign->id }})">
                            <i class="bi bi-trash me-2"></i> Delete Campaign
                        </button>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function pauseCampaign(campaignId) {
    if (confirm('Are you sure you want to pause this campaign?')) {
        fetch(`/business/marketing/campaign/${campaignId}/pause`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Campaign paused successfully');
                location.reload();
            }
        });
    }
}

function resumeCampaign(campaignId) {
    if (confirm('Are you sure you want to resume this campaign?')) {
        fetch(`/business/marketing/campaign/${campaignId}/resume`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Campaign resumed successfully');
                location.reload();
            }
        });
    }
}

function deleteCampaign(campaignId) {
    if (confirm('Are you sure you want to delete this campaign? This cannot be undone.')) {
        fetch(`/business/marketing/campaign/${campaignId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Campaign deleted successfully');
                window.location.href = '{{ route("business.marketing.campaigns") }}';
            }
        });
    }
}

function exportReport(campaignId) {
    window.location.href = `/business/marketing/campaign/${campaignId}/export`;
}
</script>
@endsection

