@extends('layouts.business')

@section('title', 'Edit Offer')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Edit Offer</h2>
        <p class="text-muted mb-0">Create an attractive offer for your customers</p>
    </div>
    <a href="{{ route('business.offers.index') }}" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left me-2"></i>Back to Offers
    </a>
</div>
@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<form action="{{ route('business.offers.update', $offer->id) }}" method="POST" enctype="multipart/form-data">
    @csrf
    @method('PUT')

    <div class="row g-4">
        <!-- Left Column -->
        <div class="col-lg-8">
            <!-- Basic Information -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Basic Information</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Title (English) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('title') is-invalid @enderror"
                                   name="title" value="{{ old('title',$offer->title) }}" required placeholder="e.g., 50% Off All Items">
                            @error('title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Title (Arabic)</label>
                            <input type="text" class="form-control @error('title_ar') is-invalid @enderror"
                                   name="title_ar" value="{{ old('title_ar',$offer->title_ar) }}" dir="rtl" placeholder="خصم 50٪ على جميع المنتجات">
                            @error('title_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description (English) <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('description') is-invalid @enderror"
                                      name="description" rows="4" required>{{ old('description',$offer->description) }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description (Arabic)</label>
                            <textarea class="form-control @error('description_ar') is-invalid @enderror"
                                      name="description_ar" rows="4" dir="rtl">{{ old('description_ar',$offer->description_ar) }}</textarea>
                            @error('description_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Venue <span class="text-danger">*</span></label>
                            <select class="form-select @error('venue_id') is-invalid @enderror" name="venue_id" required>
                                <option value="">Select Venue</option>
                                @foreach($venues ?? [] as $venue)
                                    <option value="{{ $venue->id }}" {{ old('venue_id',$offer->venue_id) == $venue->id ? 'selected' : '' }}>
                                        {{ $venue->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('venue_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Category</label>
                            <select class="form-select @error('category_id') is-invalid @enderror" name="category_id">
                                <option value="">Select Category</option>
                                @foreach($categories ?? [] as $category)
                                    <option value="{{ $category->id }}" {{ old('category_id',$offer->category_id) == $category->id ? 'selected' : '' }}>
                                        {{ $category->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('category_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <!-- Discount Details -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Discount Details</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Offer Type <span class="text-danger">*</span></label>
                            <select class="form-select @error('offer_type') is-invalid @enderror" name="offer_type" required>
                                <option value="regular" {{ old('offer_type',$offer->offer_type) === 'regular' ? 'selected' : '' }}>Regular</option>
{{--                                <option value="special" {{ old('offer_type',$offer->offer_type) === 'special' ? 'selected' : '' }}>Special</option>--}}
{{--                                <option value="exclusive" {{ old('offer_type',$offer->offer_type) === 'exclusive' ? 'selected' : '' }}>Exclusive</option>--}}
                            </select>
                            @error('offer_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Discount Type <span class="text-danger">*</span></label>
                            <select class="form-select @error('discount_type') is-invalid @enderror"
                                    name="discount_type" id="discountType" required>
                                <option value="percentage" {{ old('discount_type',$offer->discount_type) === 'percentage' ? 'selected' : '' }}>Percentage Off</option>
                                <option value="fixed" {{ old('discount_type',$offer->discount_type) === 'fixed' ? 'selected' : '' }}>Fixed Amount Off</option>
                                <option value="bogo" {{ old('discount_type',$offer->discount_type) === 'bogo' ? 'selected' : '' }}>Buy One Get One</option>
                                <option value="free" {{ old('discount_type',$offer->discount_type) === 'free' ? 'selected' : '' }}>Free Item/Service</option>
                            </select>
                            @error('discount_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4" id="discountValueField">
                            <label class="form-label">Discount Value <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="number" class="form-control @error('discount_value') is-invalid @enderror"
                                       name="discount_value" value="{{ old('discount_value',$offer->discount_value) }}" step="0.01">
                                <span class="input-group-text" id="discountUnit">%</span>
                            </div>
                            @error('discount_value')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Original Price</label>
                            <div class="input-group">
                                <span class="input-group-text">AED</span>
                                <input type="number" class="form-control @error('original_price') is-invalid @enderror"
                                       name="original_price" value="{{ old('original_price',$offer->original_price) }}" step="0.01">
                            </div>
                            @error('original_price')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Discounted Price</label>
                            <div class="input-group">
                                <span class="input-group-text">AED</span>
                                <input type="number" class="form-control @error('discounted_price') is-invalid @enderror"
                                       name="discounted_price" value="{{ old('discounted_price',$offer->discounted_price) }}" step="0.01">
                            </div>
                            @error('discounted_price')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <!-- Terms & Conditions -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Terms & Conditions</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-12">
                            <label class="form-label">Terms & Conditions (English)</label>
                            <textarea class="form-control @error('terms_conditions') is-invalid @enderror"
                                      name="terms_conditions" rows="4">{{ old('terms_conditions',$offer->terms_conditions) }}</textarea>
                            @error('terms_conditions')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">List any restrictions or requirements</small>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Terms & Conditions (Arabic)</label>
                            <textarea class="form-control @error('terms_conditions_ar') is-invalid @enderror"
                                      name="terms_conditions_ar" rows="4" dir="rtl">{{ old('terms_conditions_ar',$offer->terms_conditions_ar) }}</textarea>
                            @error('terms_conditions_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Column -->
        <div class="col-lg-4">
            <!-- Validity Period -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Validity Period</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Start Date <span class="text-danger">*</span></label>
                        @php
                            // Convert to Y-m-d format so HTML <input type="date"> accepts it
                            $startDateRaw = old('start_date', $offer->start_date ?? now());
                            $startDate = \Carbon\Carbon::parse($startDateRaw)->format('Y-m-d');
                        @endphp

                        <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                               name="start_date" value="{{ $startDate }}" required>
                        @error('start_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label">End Date <span class="text-danger">*</span></label>
                        @php
                            // Convert to Y-m-d format so HTML <input type="date"> accepts it
                                $endDateRaw = old('start_date', $offer->end_date ?? now());
                                $endDate = \Carbon\Carbon::parse($endDateRaw)->format('Y-m-d');
                        @endphp
                        <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                               name="end_date" value="{{ $endDate }}" required>
                        @error('end_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Redemption Limits -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Redemption Limits</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Total Redemption Limit</label>
                        <input type="number" class="form-control @error('redemption_limit') is-invalid @enderror"
                               name="redemption_limit" value="{{ old('redemption_limit',$offer->redemption_limit) }}" min="1">
                        @error('redemption_limit')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Leave empty for unlimited</small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Per User Limit <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('max_redemptions_per_user') is-invalid @enderror"
                               name="max_redemption_per_user" value="{{ old('max_redemptions_per_user', $offer->max_redemptions_per_user) }}" min="1" required>
                        @error('max_redemptions_per_user')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">How many times each user can redeem</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Max Redemption Per User Per Day Limit <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('max_redemptions_per_user_per_day') is-invalid @enderror"
                               name="max_redemptions_per_user_per_day" value="{{ old('max_redemptions_per_user_per_day', $offer->max_redemptions_per_user_per_day) }}" min="1" required>
                        @error('max_redemptions_per_user_per_day')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">How many times each user can redeem in a day</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Daily Redemption Limit <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('daily_redemption_limit') is-invalid @enderror"
                               name="daily_redemption_limit" value="{{ old('daily_redemption_limit', $offer->daily_redemption_limit) }}" min="1" required>
                        @error('daily_redemption_limit')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">How many redemption daily</small>
                    </div>
                </div>
            </div>

            <!-- Images -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Images</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Featured Image <span class="text-danger">*</span></label>
                        <input type="file" class="form-control @error('featured_image') is-invalid @enderror"
                               name="featured_image" accept="image/*" required>
                        @error('featured_image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Main offer image (1200x630px recommended)</small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Gallery Images</label>
                        <input type="file" class="form-control @error('images') is-invalid @enderror"
                               name="images[]" accept="image/*" multiple>
                        @error('images')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Additional images (optional)</small>
                    </div>
                </div>
            </div>

            <!-- Status & Settings -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Status & Settings</h5>
                </div>
                <div class="card-body">

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="is_featured" id="isFeatured" value="1"
                            {{ old('is_featured', $offer->is_featured) ? 'checked' : '' }}>
                        <label class="form-check-label" for="isFeatured">
                            Featured Offer
                        </label>
                        <small class="d-block text-muted">Show in featured section</small>
                    </div>

                    <div class="alert alert-info small">
                        <i class="bi bi-info-circle me-2"></i>
                        Your offer will be reviewed by our team before going live.
                    </div>
                </div>
            </div>

            <!-- Submit Buttons -->
            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="bi bi-check-lg me-2"></i>Update Offer
                </button>
                <a href="{{ route('business.offers.index') }}" class="btn btn-outline-secondary">
                    Cancel
                </a>
            </div>
        </div>
    </div>
</form>
@endsection

@push('scripts')
<script>
    // Update discount unit based on type
    document.getElementById('discountType').addEventListener('change', function() {
        const unit = document.getElementById('discountUnit');
        const field = document.getElementById('discountValueField');

        if (this.value === 'percentage') {
            unit.textContent = '%';
            field.style.display = 'block';
        } else if (this.value === 'fixed') {
            unit.textContent = 'AED';
            field.style.display = 'block';
        } else {
            field.style.display = 'none';
        }
    });

    // Set minimum end date to start date
    document.querySelector('[name="start_date"]').addEventListener('change', function() {
        document.querySelector('[name="end_date"]').min = this.value;
    });
</script>
@endpush
