@extends('layouts.business')

@section('title', 'Settings')

@section('content')
<div class="mb-4">
    <h2 class="fw-bold mb-1">Settings</h2>
    <p class="text-muted mb-0">Manage your business profile and preferences</p>
</div>

<div class="row g-4">
    <!-- Sidebar -->
    <div class="col-lg-3">
        <div class="list-group">
            <a href="#profile" class="list-group-item list-group-item-action active" data-bs-toggle="list">
                <i class="bi bi-building me-2"></i>Business Profile
            </a>
            <a href="#account" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-person me-2"></i>Account Settings
            </a>
            <a href="#preferences" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-gear me-2"></i>Preferences
            </a>
            <a href="#notifications" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-bell me-2"></i>Notifications
            </a>
            <a href="#security" class="list-group-item list-group-item-action" data-bs-toggle="list">
                <i class="bi bi-shield-check me-2"></i>Security
            </a>
        </div>
    </div>

    <!-- Content -->
    <div class="col-lg-9">
        <div class="tab-content">
            <!-- Business Profile -->
            <div class="tab-pane fade show active" id="profile">
                <form action="{{ route('business.settings.update-account') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="table-card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0 fw-bold">Business Information</h5>
                        </div>
{{--                        I want you to display here the notes about rejection or approval of the business account.--}}
                        @if($business && $business->status == 'rejected')
                            <div class="alert alert-danger m-3">
                                <h6 class="alert-heading fw-bold">Business Account Rejected</h6>
                                <p>Your business account has been rejected for the following reason:</p>
                                <p class="mb-0"><em>{{ $business->verification_notes }}</em></p>
                            </div>
                        @endif
                        @if($business && $business->status == 'pending')
                            <div class="alert alert-warning m-3">
                                <h6 class="alert-heading fw-bold">Business Account Pending</h6>
                                <p>Your business account is currently under review. You will be notified once the verification process is complete.</p>
                            </div>
                        @endif
                        @if($business && $business->status == 'verified')

                        @endif
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-12">
                                    <div class="text-center mb-4">
                                        <img src="{{ $business->logo ?? 'https://via.placeholder.com/150' }}"
                                             class="rounded-circle mb-3" width="120" height="120" alt="Logo">
                                        <div>
                                            <label class="btn btn-sm btn-outline-primary">
                                                <i class="bi bi-upload me-1"></i>Change Logo
                                                <input type="file" name="logo" accept="image/*" class="d-none">
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Business Name (English)</label>
                                    <input type="text" class="form-control" name="business_name"
                                           value="{{ old('business_name', $business->business_name) }}">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Business Name (Arabic)</label>
                                    <input type="text" class="form-control" name="business_name_ar"
                                           value="{{ old('business_name_ar', $business->business_name_ar) }}" dir="rtl">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email"
                                           value="{{ old('email', $business->email) }}">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Phone</label>
                                    <input type="tel" class="form-control" name="phone"
                                           value="{{ old('phone', $business->phone) }}">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Website</label>
                                    <input type="url" class="form-control" name="website"
                                           value="{{ old('website', $business->website) }}">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Trade License Number</label>
                                    <input type="text" class="form-control" name="trade_license_number"
                                           value="{{ old('trade_license_number', $business->trade_license_number) }}" readonly>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Description (English)</label>
                                    <textarea class="form-control" name="description" rows="3">{{ old('description', $business->description) }}</textarea>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Description (Arabic)</label>
                                    <textarea class="form-control" name="description_ar" rows="3" dir="rtl">{{ old('description_ar', $business->description_ar) }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="table-card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0 fw-bold">Social Media Links</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label"><i class="bi bi-facebook text-primary me-2"></i>Facebook</label>
                                    <input type="url" class="form-control" name="facebook_url" placeholder="https://facebook.com/yourpage">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label"><i class="bi bi-instagram text-danger me-2"></i>Instagram</label>
                                    <input type="url" class="form-control" name="instagram_url" placeholder="https://instagram.com/yourpage">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label"><i class="bi bi-twitter text-info me-2"></i>Twitter</label>
                                    <input type="url" class="form-control" name="twitter_url" placeholder="https://twitter.com/yourpage">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label"><i class="bi bi-linkedin text-primary me-2"></i>LinkedIn</label>
                                    <input type="url" class="form-control" name="linkedin_url" placeholder="https://linkedin.com/company/yourpage">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="text-end">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-lg me-2"></i>Save Changes
                        </button>
                    </div>
                </form>
            </div>

            <!-- Account Settings -->
            <div class="tab-pane fade" id="account">
                <div class="table-card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0 fw-bold">Account Owner Information</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('business.settings.update-profile') }}" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">First Name</label>
                                    <input type="text" class="form-control" name="first_name"
                                           value="{{ auth()->user()->first_name }}">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Last Name</label>
                                    <input type="text" class="form-control" name="last_name"
                                           value="{{ auth()->user()->last_name }}">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email"
                                           value="{{ auth()->user()->email }}">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Phone</label>
                                    <input type="tel" class="form-control" name="phone"
                                           value="{{ auth()->user()->phone }}">
                                </div>
                            </div>
                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-primary">Save Changes</button>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="table-card">
                    <div class="card-header">
                        <h5 class="mb-0 fw-bold">Change Password</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('business.settings.change-password') }}" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="row g-3">
                                <div class="col-12">
                                    <label class="form-label">Current Password</label>
                                    <input type="password" class="form-control" name="current_password" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">New Password</label>
                                    <input type="password" class="form-control" name="password" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Confirm New Password</label>
                                    <input type="password" class="form-control" name="password_confirmation" required>
                                </div>
                            </div>
                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-primary">Update Password</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Preferences -->
            <div class="tab-pane fade" id="preferences">
                <form action="{{ route('business.settings.update-preferences') }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="table-card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0 fw-bold">Language & Regional</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Default Language</label>
                                    <select class="form-select" name="language">
                                        <option value="en">English</option>
                                        <option value="ar">العربية (Arabic)</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Timezone</label>
                                    <select class="form-select" name="timezone">
                                        <option value="Asia/Dubai">Asia/Dubai (GST)</option>
                                        <option value="Asia/Riyadh">Asia/Riyadh (AST)</option>
                                        <option value="UTC">UTC</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Date Format</label>
                                    <select class="form-select" name="date_format">
                                        <option value="d/m/Y">DD/MM/YYYY</option>
                                        <option value="m/d/Y">MM/DD/YYYY</option>
                                        <option value="Y-m-d">YYYY-MM-DD</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Currency</label>
                                    <select class="form-select" name="currency">
                                        <option value="AED">AED (د.إ)</option>
                                        <option value="SAR">SAR (ر.س)</option>
                                        <option value="USD">USD ($)</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="text-end">
                        <button type="submit" class="btn btn-primary">Save Preferences</button>
                    </div>
                </form>
            </div>

            <!-- Notifications -->
            <div class="tab-pane fade" id="notifications">
                <form action="{{ route('business.settings.update-notifications') }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="table-card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0 fw-bold">Email Notifications</h5>
                        </div>
                        <div class="card-body">
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="email_new_redemption" id="emailRedemption" checked>
                                <label class="form-check-label" for="emailRedemption">
                                    <strong>New Redemptions</strong>
                                    <div class="small text-muted">Get notified when customers redeem your offers</div>
                                </label>
                            </div>
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="email_new_review" id="emailReview" checked>
                                <label class="form-check-label" for="emailReview">
                                    <strong>New Reviews</strong>
                                    <div class="small text-muted">Get notified when customers leave reviews</div>
                                </label>
                            </div>
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="email_subscription" id="emailSub" checked>
                                <label class="form-check-label" for="emailSub">
                                    <strong>Subscription Updates</strong>
                                    <div class="small text-muted">Renewal reminders and subscription changes</div>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="table-card mb-4">
                        <div class="card-header">
                            <h5 class="mb-0 fw-bold">Push Notifications</h5>
                        </div>
                        <div class="card-body">
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="push_realtime" id="pushRealtime" checked>
                                <label class="form-check-label" for="pushRealtime">
                                    <strong>Real-time Updates</strong>
                                    <div class="small text-muted">Instant notifications for important events</div>
                                </label>
                            </div>
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="push_messages" id="pushMessages">
                                <label class="form-check-label" for="pushMessages">
                                    <strong>Customer Messages</strong>
                                    <div class="small text-muted">When customers send you messages</div>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="text-end">
                        <button type="submit" class="btn btn-primary">Save Notification Settings</button>
                    </div>
                </form>
            </div>

            <!-- Security -->
            <div class="tab-pane fade" id="security">
                <div class="table-card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0 fw-bold">Two-Factor Authentication</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted">Add an extra layer of security to your account</p>
                        <button class="btn btn-outline-primary">Enable 2FA</button>
                    </div>
                </div>

                <div class="table-card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0 fw-bold">Active Sessions</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3 pb-3 border-bottom">
                            <div>
                                <div class="fw-semibold"><i class="bi bi-laptop me-2"></i>Chrome on Windows</div>
                                <small class="text-muted">Dubai, UAE • Last active: Just now</small>
                            </div>
                            <span class="badge bg-success">Current</span>
                        </div>
                        <button class="btn btn-sm btn-outline-danger">Sign Out All Other Sessions</button>
                    </div>
                </div>

                <div class="table-card">
                    <div class="card-header bg-danger text-white">
                        <h5 class="mb-0 fw-bold">Danger Zone</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted mb-3">Once you delete your account, there is no going back. Please be certain.</p>
                        <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#deleteAccountModal">
                            Delete Account
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Account Modal -->
<div class="modal fade" id="deleteAccountModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header border-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body text-center py-4">
                <i class="bi bi-exclamation-triangle text-danger" style="font-size: 4rem;"></i>
                <h5 class="mt-3">Delete Account?</h5>
                <p class="text-muted">This action cannot be undone. All your data will be permanently deleted.</p>
                <input type="text" class="form-control my-3" placeholder="Type 'DELETE' to confirm">
            </div>
            <div class="modal-footer border-0 justify-content-center">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger">Delete My Account</button>
            </div>
        </div>
    </div>
</div>
@endsection
