@extends('layouts.guest')

@section('content')
    {{--    validation error--}}
    @if(($errors->all()))
        <div class="container mt-4">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    @endif
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0">Create Your Account</h4>
                    </div>
                    <div class="card-body">
                        <p class="mb-4">
                            You've been invited to join as a <strong>{{ ucfirst($staff->role) }}</strong>.
                            <br>
                            Create your account below to get started.
                        </p>

                        <form action="{{ route('staff.accept-invitation.complete', $staff->invitation_token) }}"
                              method="POST">
                            @csrf

                        <!-- Email (Read-only) -->
                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" value="{{ $email }}"
                                   disabled>
                            <small class="text-muted">This email was used for the invitation</small>
                        </div>

                            <!-- First Name -->
                            <div class="mb-3">
                                <label for="first_name" class="form-label">First Name</label>
                                <input type="text" class="form-control @error('first_name') is-invalid @enderror"
                                       id="first_name" name="first_name" value="{{ old('first_name') }}" required>
                                @error('first_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Last Name -->
                            <div class="mb-3">
                                <label for="last_name" class="form-label">Last Name</label>
                                <input type="text" class="form-control @error('last_name') is-invalid @enderror"
                                       id="last_name" name="last_name" value="{{ old('last_name') }}" required>
                                @error('last_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Password -->
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control @error('password') is-invalid @enderror"
                                       id="password" name="password" required min="8">
                                <small class="text-muted">At least 8 characters</small>
                                @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Confirm Password -->
                            <div class="mb-4">
                                <label for="password_confirmation" class="form-label">Confirm Password</label>
                                <input type="password"
                                       class="form-control @error('password_confirmation') is-invalid @enderror"
                                       id="password_confirmation" name="password_confirmation" required>
                                @error('password_confirmation')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Permissions Info -->
                            @if($staff->permissions)
                                <div class="alert alert-info mb-4">
                                    <strong>Your Permissions:</strong>
                                    <ul class="mb-0 mt-2">
                                        @php
                                            $permissionIds = json_decode($staff->permissions, true);
                                            $permissions = \App\Models\Permission::whereIn('id', $permissionIds)->get();
                                        @endphp
                                        @foreach($permissions as $permission)
                                            <li>{{ $permission->display_name ?? $permission->name }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <!-- Submit Button -->
                            <button type="submit" class="btn btn-primary w-100">
                                Create Account & Accept Invitation
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

