@extends('layouts.app')

@section('title', 'Edit Staff')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-12">
            <h1 class="h3 mb-0">Edit Staff Member</h1>
            <p class="text-muted">Update staff member role and team assignment</p>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('business.staff.update', [$business, $staff]) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="mb-3">
                            <label for="role" class="form-label">Role *</label>
                            <select class="form-select @error('role') is-invalid @enderror"
                                id="role" name="role" required>
                                <option value="">Select Role</option>
                                <option value="owner" {{ old('role', $staff->role) === 'owner' ? 'selected' : '' }}>Owner</option>
                                <option value="manager" {{ old('role', $staff->role) === 'manager' ? 'selected' : '' }}>Manager</option>
                                <option value="staff" {{ old('role', $staff->role) === 'staff' ? 'selected' : '' }}>Staff</option>
                            </select>
                            @error('role')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="team_id" class="form-label">Team Assignment (Optional)</label>
                            <select class="form-select @error('team_id') is-invalid @enderror"
                                id="team_id" name="team_id">
                                <option value="">No Team</option>
                                @foreach($teams as $team)
                                    <option value="{{ $team->id }}" {{ old('team_id', $staff->team_id) == $team->id ? 'selected' : '' }}>
                                        {{ $team->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('team_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Staff Member
                            </button>
                            <a href="{{ route('business.staff.index', $business) }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Staff Information</h6>
                </div>
                <div class="card-body">
                    @if($staff->user)
                        <p class="mb-2"><strong>Name:</strong> {{ $staff->user->first_name }} {{ $staff->user->last_name }}</p>
                        <p class="mb-2"><strong>Email:</strong> {{ $staff->user->email }}</p>
                    @else
                        <p class="mb-2"><strong>Email:</strong> {{ $staff->email ?? 'Pending' }}</p>
                        <p class="mb-2"><strong>Status:</strong> <span class="badge bg-warning">Pending Invitation</span></p>
                    @endif
                    <p class="mb-2"><strong>Current Role:</strong> <span class="badge bg-primary">{{ ucfirst($staff->role) }}</span></p>
                    @if($staff->user)
                    <p class="mb-2"><strong>Status:</strong> <span class="badge bg-{{ $staff->status === 'active' ? 'success' : 'warning' }}">{{ ucfirst(str_replace('_', ' ', $staff->status)) }}</span></p>
                    <p class="mb-0"><strong>Created:</strong> {{ $staff->created_at->format('M d, Y') }}</p>
                    @else
                    <p class="mb-2"><strong>Invited:</strong> {{ $staff->invited_at ? $staff->invited_at->format('M d, Y') : 'N/A' }}</p>
                    <p class="mb-0"><strong>Attempts:</strong> {{ $staff->verification_attempts ?? 0 }}/3</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

