@extends('layouts.business')

@section('title', 'Business Staff')

@section('content')
<div class="container-fluid py-4">
    @php
        $subscription = $business->activeSubscription()->with('plan')->first();
        $maxStaff = $subscription ? $subscription->plan->max_staff : 0;
        $currentStaff = $staff->where('status', 'active')->count();
        $canAddMore = $currentStaff < $maxStaff;
    @endphp

    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <a href="{{ route('business.show', $business) }}" class="text-decoration-none">
                    {{ $business->business_name }}
                </a>
            </h1>
            <p class="text-muted">Staff Members</p>
        </div>
        <div class="col-md-4 text-end">
            @if($canAddMore)
                <a href="{{ route('business.staff.create', $business) }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add Staff
                </a>
            @else
                <button class="btn btn-secondary" disabled title="Staff limit reached - upgrade plan">
                    <i class="fas fa-lock"></i> Limit Reached
                </button>
            @endif
        </div>
    </div>

    <!-- Plan Limit Warning -->
    @if($currentStaff >= $maxStaff * 0.8 && $canAddMore)
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle"></i>
            <strong>Approaching Staff Limit</strong>
            You have {{ $maxStaff - $currentStaff }} staff slot{{ $maxStaff - $currentStaff !== 1 ? 's' : '' }} remaining.
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @elseif(!$canAddMore)
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-circle"></i>
            <strong>Staff Limit Reached</strong>
            You've reached the maximum of {{ $maxStaff }} staff members. <a href="{{ route('business.subscription.index') }}" class="alert-link">Upgrade your plan</a> to add more.
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Staff</h6>
                    <h3 class="mb-0">{{ $staff->total() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active</h6>
                    <h3 class="mb-0">{{ $currentStaff }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Pending</h6>
                    <h3 class="mb-0">{{ $staff->where('status', 'pending_invitation')->count() }}</h3>
                </div>
            </div>
        </div>
        @if($subscription)
            <div class="col-md-3">
                <div class="card @if(!$canAddMore) border-danger @elseif($currentStaff >= $maxStaff * 0.8) border-warning @endif">
                    <div class="card-body">
                        <h6 class="text-muted mb-2">Plan Limit</h6>
                        <h3 class="mb-0 @if(!$canAddMore) text-danger @elseif($currentStaff >= $maxStaff * 0.8) text-warning @endif">{{ $currentStaff }}/{{ $maxStaff }}</h3>
                        <small class="text-muted">{{ $subscription->plan->name }}</small>
                    </div>
                </div>
            </div>
        @endif
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control form-control-sm"
                        placeholder="Search by name or email" value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <select name="role" class="form-select form-select-sm">
                        <option value="">All Roles</option>
                        <option value="owner" {{ request('role') === 'owner' ? 'selected' : '' }}>Owner</option>
                        <option value="manager" {{ request('role') === 'manager' ? 'selected' : '' }}>Manager</option>
                        <option value="staff" {{ request('role') === 'staff' ? 'selected' : '' }}>Staff</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select form-select-sm">
                        <option value="">All Status</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="pending_invitation" {{ request('status') === 'pending_invitation' ? 'selected' : '' }}>Pending</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary btn-sm w-100">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Staff Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Role</th>
                        <th>Team</th>
                        <th>Permissions</th>
                        <th>Status</th>
                        <th>Joined</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($staff as $member)
                    <tr>
                        <td>
                            @if($member->user)
                                <strong>{{ $member->user->first_name }} {{ $member->user->last_name }}</strong>
                            @else
                                <span class="text-muted">{{ $member->email ?? 'Pending' }}</span>
                            @endif
                        </td>
                        <td>
                            @if($member->user)
                                {{ $member->user->email }}
                            @else
                                <span class="text-muted">Pending acceptance</span>
                            @endif
                        </td>
                        <td>
                            @if($member->user)
                                {{ $member->user->phone ?? '-' }}
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-primary">{{ ucfirst($member->role) }}</span>
                        </td>
                        <td>
                            @if($member->team)
                                <span class="badge bg-secondary">{{ $member->team->name }}</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @if($member->permissions && is_array($member->permissions))
                                @php
                                    $permissionIds = $member->permissions;
                                    $permissions = \App\Models\Permission::whereIn('id', $permissionIds)->get();
                                @endphp
                                @if($permissions->count() > 0)
                                    <div class="d-flex flex-wrap gap-1">
                                        @foreach($permissions as $perm)
                                        <span class="badge bg-info" title="{{ $perm->description }}">
                                            {{ $perm->name }}
                                        </span>
                                        @endforeach
                                    </div>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $member->status === 'active' ? 'success' : 'warning' }}">
                                {{ ucfirst(str_replace('_', ' ', $member->status)) }}
                            </span>
                        </td>
                        <td>
                            @if($member->joined_at)
                                <small>{{ $member->joined_at->format('M d, Y') }}</small>
                            @else
                                <small class="text-muted">Pending</small>
                            @endif
                        </td>
                        <td>
                             <a href="{{ route('business.staff.edit', $member->id) }}" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('business.staff.destroy', $member->id) }}" method="POST" style="display:inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Remove this staff member?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            No staff members yet. <a href="{{ route('business.staff.create', $business) }}">Add one</a>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            Showing {{ $staff->firstItem() ?? 0 }} to {{ $staff->lastItem() ?? 0 }} of {{ $staff->total() }} staff members
        </div>
        <div>
            {{ $staff->links() }}
        </div>
    </div>
</div>
@endsection

