@extends('layouts.business')

@section('title', 'Invoice #' . $invoice->id)

@section('content')
    <div class="container py-5">
        <div class="card">
            <div class="card-body p-5">
                <div class="d-flex justify-content-between mb-5">
                    <div>
                        <h2 class="fw-bold">INVOICE</h2>
                        <p class="text-muted mb-0">Invoice #{{ str_pad($invoice->id, 6, '0', STR_PAD_LEFT) }}</p>
                    </div>
                    <div class="text-end">
                        <h4 class="mb-2">Privasee</h4>
                        <p class="text-muted mb-0">
                            Premium Offers Platform<br>
                            Dubai, UAE
                        </p>
                    </div>
                </div>

                <div class="row mb-5">
                    <div class="col-md-6">
                        <h6 class="text-muted mb-2">Bill To:</h6>
                        <p class="mb-0">
                            <strong>{{ $invoice->business->business_name ?? 'N/A' }}</strong><br>
                            {{ $invoice->business->address ?? '' }}<br>
                            {{ $invoice->business->city ?? '' }}
                        </p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <h6 class="text-muted mb-2">Invoice Details:</h6>
                        <p class="mb-0">
                            <strong>Date:</strong> {{ $invoice->payment_date ? $invoice->payment_date->format('M d, Y') : now()->format('M d, Y') }}<br>
                            <strong>Status:</strong>
                            <span class="badge bg-{{ $invoice->status === 'completed' ? 'success' : ($invoice->status === 'pending' ? 'warning' : 'danger') }}">
                            {{ ucfirst($invoice->status) }}
                        </span>
                        </p>
                    </div>
                </div>

                <table class="table">
                    <thead class="table-light">
                    <tr>
                        <th>Description</th>
                        <th class="text-end">Amount</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>
                            <strong>{{ $invoice->subscription->plan->name ?? 'Subscription Plan' }}</strong><br>
                            <small class="text-muted">{{ $invoice->description ?? 'Monthly Subscription' }}</small>
                        </td>
                        <td class="text-end">{{ $invoice->currency }} {{ number_format($invoice->amount, 2) }}</td>
                    </tr>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th class="text-end">Total Amount:</th>
                        <th class="text-end">{{ $invoice->currency }} {{ number_format($invoice->amount, 2) }}</th>
                    </tr>
                    </tfoot>
                </table>

                <div class="mt-5 pt-4 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <p class="text-muted small mb-0">
                                Transaction ID: {{ $invoice->transaction_id ?? 'N/A' }}<br>
                                Payment Method: {{ ucfirst($invoice->payment_method) }}
                            </p>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <a href="{{ route('business.subscription.invoice.download', $invoice->id) }}" class="btn btn-primary">
                                <i class="bi bi-download me-2"></i>Download Invoice
                            </a>
                            <a href="{{ route('business.subscription.index') }}" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left me-2"></i>Back
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
