@extends('layouts.business')

@section('title', 'Choose Your Plan')

@section('content')
<div class="container-fluid py-5">
    <!-- Header Section -->
    <div class="row mb-5">
        <div class="col-md-8">
            <h1 class="h2 fw-bold mb-0">
                @if(($planType ?? 'business') === 'marketing')
                <i class="fas fa-bullhorn me-2"></i>{{ $pageTitle ?? 'Marketing Plans' }}
                @elseif(($planType ?? 'business') === 'user')
                <i class="fas fa-user me-2"></i>{{ $pageTitle ?? 'User Plans' }}
                @else
                <i class="fas fa-building me-2"></i>{{ $pageTitle ?? 'Business Plans' }}
                @endif
            </h1>
            <p class="text-muted">{{ $pageDescription ?? 'Choose a plan that fits your needs' }}</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('business.subscription.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back
            </a>
        </div>
    </div>

    <!-- Plan Comparison Cards (Dynamic & Enhanced) -->
    <div class="row mb-5">
        @forelse($plans as $plan)
        <div class="col-lg-4 mb-4">
            <div class="card h-100 border-0 plan-card-enhanced {{ $plan->is_popular ? 'shadow-lg' : 'shadow-sm' }}"
                 style="transition: all 0.3s ease; {{ $plan->is_popular ? 'transform: translateY(-10px); border: 3px solid #28a745;' : '' }}">

                <!-- Ribbon -->
                @if($plan->is_popular)
                <div class="position-absolute top-0 end-0" style="z-index: 10;">
                    <span class="badge bg-success rounded-pill px-4 py-2" style="border-radius: 0 0 0 8px; font-size: 0.85rem;">
                        <i class="fas fa-star me-1"></i>MOST POPULAR
                    </span>
                </div>
                @endif

                <!-- Header with Gradient -->
                <div class="card-header border-0 py-5"
                     style="background: linear-gradient(135deg, {{ $plan->is_popular ? '#28a745' : '#007bff' }} 0%, {{ $plan->is_popular ? '#20c997' : '#0056b3' }} 100%);">
                    <h3 class="mb-1 fw-bold text-white">{{ $plan->name }}</h3>
                    <small class="text-white opacity-90">{{ $plan->description }}</small>
                </div>

                <!-- Body -->
                <div class="card-body p-4 d-flex flex-column">
                    <!-- Price Section -->
                    <div class="mb-4 pb-3 border-bottom">
                        <h2 class="mb-1">
                            <span class="fw-bold">AED {{ number_format($plan->price, 2) }}</span>
                        </h2>
                        <p class="text-muted small mb-0">per month, billed monthly</p>
                    </div>

                    <!-- Features List (Enhanced) -->
                    <ul class="list-unstyled mb-4 flex-grow-1">
                        @if($plan->max_venues)
                        <li class="mb-3 d-flex align-items-start">
                            <i class="fas fa-check text-success me-3 mt-1"></i>
                            <div>
                                <strong>{{ $plan->max_venues == -1 ? 'Unlimited' : $plan->max_venues }}</strong>
                                <span class="text-muted small">{{ $plan->max_venues == 1 ? 'Venue' : 'Venues' }}</span>
                            </div>
                        </li>
                        @endif

                        @if($plan->monthly_campaigns)
                        <li class="mb-3 d-flex align-items-start">
                            <i class="fas fa-check text-success me-3 mt-1"></i>
                            <div>
                                <strong>{{ $plan->monthly_campaigns }}</strong>
                                <span class="text-muted small">{{ $plan->monthly_campaigns == 1 ? 'Campaign' : 'Campaigns' }} per month</span>
                            </div>
                        </li>
                        @elseif($plan->type === 'business')
                        <li class="mb-3 d-flex align-items-start">
                            <i class="fas fa-times text-danger me-3 mt-1"></i>
                            <div>
                                <strong>No Campaigns</strong>
                                <span class="text-muted small">Upgrade for promotional campaigns</span>
                            </div>
                        </li>
                        @endif

                        @if($plan->max_offers)
                        <li class="mb-3 d-flex align-items-start">
                            <i class="fas fa-check-circle text-success me-3 mt-1" style="flex-shrink: 0;"></i>
                            <div>
                                <strong>{{ $plan->max_offers == -1 ? 'Unlimited' : $plan->max_offers }}</strong>
                                <span class="text-muted small">{{ $plan->max_offers == 1 ? 'Offer' : 'Offers' }}</span>
                            </div>
                        </li>
                        @endif

                        @if($plan->max_staff)
                        <li class="mb-3 d-flex align-items-start">
                            <i class="fas fa-check-circle text-success me-3 mt-1" style="flex-shrink: 0;"></i>
                            <div>
                                <strong>{{ $plan->max_staff == -1 ? 'Unlimited' : $plan->max_staff }}</strong>
                                <span class="text-muted small">{{ $plan->max_staff == 1 ? 'Staff Member' : 'Staff Members' }}</span>
                            </div>
                        </li>
                        @endif

                        @if($plan->storage_gb)
                        <li class="mb-3 d-flex align-items-start">
                            <i class="fas fa-check-circle text-success me-3 mt-1" style="flex-shrink: 0;"></i>
                            <div>
                                <strong>{{ $plan->storage_gb }}GB</strong>
                                <span class="text-muted small">Storage</span>
                            </div>
                        </li>
                        @endif

                        @if($plan->monthly_campaigns)
                        <li class="mb-3 d-flex align-items-start">
                            <i class="fas fa-check-circle text-success me-3 mt-1" style="flex-shrink: 0;"></i>
                            <div>
                                <strong>{{ $plan->monthly_campaigns == -1 ? 'Unlimited' : $plan->monthly_campaigns }}</strong>
                                <span class="text-muted small">Campaign(s) per Month</span>
                            </div>
                        </li>
                        @endif

                        @if($plan->analytics_access)
                        <li class="mb-3 d-flex align-items-start">
                            <i class="fas fa-check-circle text-success me-3 mt-1" style="flex-shrink: 0;"></i>
                            <span>Advanced Analytics</span>
                        </li>
                        @endif

                        @if($plan->priority_support)
                        <li class="mb-0 d-flex align-items-start">
                            <i class="fas fa-check-circle text-success me-3 mt-1" style="flex-shrink: 0;"></i>
                            <span>Priority Support (24/7)</span>
                        </li>
                        @endif
                    </ul>

                    <!-- Call-to-Action Button -->
                    <button class="btn {{ $plan->is_popular ? 'btn-success' : 'btn-primary' }} btn-lg w-100"
                            onclick="selectPlan({{ $plan->id }})"
                            style="font-weight: 600;">
                        <i class="fas fa-arrow-right me-2"></i>Choose {{ $plan->name }}
                    </button>
                </div>
            </div>
        </div>
        @empty
        <div class="col-12 text-center py-5">
            <i class="fas fa-inbox" style="font-size: 3rem; color: #ddd;"></i>
            <p class="text-muted mt-3">No subscription plans available</p>
        </div>
        @endforelse
    </div>

    <!-- Feature Comparison Table -->
    <div class="row mb-5">
        <div class="col-lg-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light py-4">
                    <h5 class="mb-0 fw-bold">
                        <i class="fas fa-table me-2"></i>Plan Comparison
                    </h5>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="fw-bold">Feature</th>
                                @foreach($plans as $plan)
                                <th class="text-center fw-bold">{{ $plan->name }}</th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="fw-bold">Venues</td>
                                @foreach($plans as $plan)
                                <td class="text-center">
                                    {{ $plan->max_venues == -1 ? '∞' : $plan->max_venues }}
                                </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="fw-bold">Offers</td>
                                @foreach($plans as $plan)
                                <td class="text-center">
                                    {{ $plan->max_offers == -1 ? '∞' : $plan->max_offers }}
                                </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="fw-bold">Staff Members</td>
                                @foreach($plans as $plan)
                                <td class="text-center">
                                    {{ $plan->max_staff == -1 ? '∞' : $plan->max_staff }}
                                </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="fw-bold">Storage</td>
                                @foreach($plans as $plan)
                                <td class="text-center">{{ $plan->storage_gb }}GB</td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="fw-bold">Campaigns/Month</td>
                                @foreach($plans as $plan)
                                <td class="text-center">
                                    {{ $plan->monthly_campaigns == -1 ? '∞' : $plan->monthly_campaigns }}
                                </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="fw-bold">Analytics</td>
                                @foreach($plans as $plan)
                                <td class="text-center">
                                    @if($plan->analytics_access)
                                    <i class="fas fa-check text-success"></i>
                                    @else
                                    <i class="fas fa-times text-danger"></i>
                                    @endif
                                </td>
                                @endforeach
                            </tr>
                            <tr>
                                <td class="fw-bold">Priority Support</td>
                                @foreach($plans as $plan)
                                <td class="text-center">
                                    @if($plan->priority_support)
                                    <i class="fas fa-check text-success"></i>
                                    @else
                                    <i class="fas fa-times text-danger"></i>
                                    @endif
                                </td>
                                @endforeach
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- FAQ Section -->
    <div class="row mb-5">
        <div class="col-lg-8 mx-auto">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light py-4">
                    <h5 class="mb-0 fw-bold">
                        <i class="fas fa-question-circle me-2"></i>Frequently Asked Questions
                    </h5>
                </div>
                <div class="card-body p-4">
                    <div class="accordion" id="faqAccordion">
                        <div class="accordion-item border-0 mb-3">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                                    Can I change my plan anytime?
                                </button>
                            </h2>
                            <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Yes! You can upgrade or downgrade your plan at any time. Changes take effect immediately.
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item border-0 mb-3">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                                    What happens when I upgrade?
                                </button>
                            </h2>
                            <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    When you upgrade, we'll pro-rate the cost difference based on your current subscription period.
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item border-0 mb-3">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                                    Can I cancel anytime?
                                </button>
                            </h2>
                            <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Yes, you can cancel your subscription anytime. Your access continues until the end of your billing period.
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item border-0">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq4">
                                    Is there a free trial?
                                </button>
                            </h2>
                            <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                <div class="accordion-body">
                                    Contact our sales team for information about trial periods and special offers.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.plan-card-enhanced {
    border-radius: 12px;
    overflow: hidden;
    position: relative;
}

.plan-card-enhanced:hover {
    box-shadow: 0 1.5rem 3rem rgba(0, 0, 0, 0.2) !important;
    transform: translateY(-8px);
}

.plan-card-enhanced.shadow-lg {
    box-shadow: 0 1rem 3rem rgba(40, 167, 69, 0.3) !important;
}

.plan-card-enhanced.shadow-lg:hover {
    box-shadow: 0 1.5rem 4rem rgba(40, 167, 69, 0.4) !important;
    transform: translateY(-15px);
}

.accordion-button:not(.collapsed) {
    background-color: #f8f9fa;
    color: #333;
    box-shadow: none;
}

.accordion-button:focus {
    border-color: #80bdff;
    box-shadow: 0 0 0 0.25rem rgba(0, 123, 255, 0.25);
}
</style>

<script>
function selectPlan(planId) {
    // Get the type from URL query parameter if available
    const urlParams = new URLSearchParams(window.location.search);
    const type = urlParams.get('type') || 'business';

    // Redirect to upgrade endpoint with plan ID and type
    window.location.href = `/business/subscription/upgrade/${planId}?type=${type}`;
}
</script>
@endsection

