@extends('layouts.business')
@section('title', 'Ticket #' . $ticket->id . ' Details')
@section('content')
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-md-8">
                <h1 class="h3 mb-0 text-gray-800">Ticket #{{ $ticket->id }}</h1>
                <p class="text-muted">{{ $ticket->subject }}</p>
            </div>
            <div class="col-md-4 text-right">
            <span
                class="badge @if($ticket->status === 'open') badge-primary @elseif($ticket->status === 'in_progress') badge-warning @elseif($ticket->status === 'resolved') badge-success @else badge-secondary @endif">
                {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}
            </span>
            </div>
        </div>
        <div class="row">
            <!-- Main Content -->
            <div class="col-lg-8">
                <!-- Ticket Details Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0">Ticket Details</h5>
                    </div>
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <p class="text-muted small">Priority</p>
                                <p class="font-weight-bold">
                                <span
                                    class="badge @if($ticket->priority == 'high') bg-danger @elseif($ticket->priority == 'medium') bg-warning @else bg-info @endif">
                                    {{ ucfirst($ticket->priority) }}
                                </span>
                                </p>
                            </div>
                            <div class="col-md-6">
                                <p class="text-muted small">Category</p>
                                <p class="font-weight-bold">{{ $ticket->category ?? 'N/A' }}</p>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <p class="text-muted small">User</p>
                                <p class="font-weight-bold">
                                    <a>{{ $ticket->user->first_name }}</a>
                                </p>
                            </div>
                            <div class="col-md-6">
                                <p class="text-muted small">Created At</p>
                                <p class="font-weight-bold">{{ $ticket->created_at->format('M d, Y H:i A') }}</p>
                            </div>
                        </div>
                        <hr>
                        <p class="text-muted small">Description</p>
                        <p class="text-gray-800">{{ $ticket->description }}</p>
                    </div>
                </div>
                <!-- Messages Section -->
                <div class="card shadow-sm">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0">Messages</h5>
                    </div>
                    <div class="card-body">
                        @foreach($ticket->replies as $message)
                            <div class="mb-4">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <strong>{{ $message->user->full_name ?? 'Support Team' }}</strong>
                                        <span
                                            class="text-muted small"> - {{ $message->created_at->format('M d, Y H:i A') }}</span>
                                    </div>
                                </div>
                                <p>{{ $message->message }}</p>
                                @if($message->attachments)
                                    <div class="mt-2">
                                        <strong>Attachments:</strong>
                                        <ul class="list-unstyled">
{{--                                            attachment json decode--}}
                                            @php $attachments = json_decode($message->attachments); @endphp
                                            @foreach($attachments as $attachment)
                                                <li>
                                                    <a href="{{ Storage::url($attachment) }}"
                                                       target="_blank">
                                                        {{ $attachment }}
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                            </div>
                            <hr>
                        @endforeach
                        @if($ticket->status == 'closed' || $ticket->status == 'resolved')

                            <div class="alert alert-info">
                                This ticket is closed/Resolved. You cannot reply to a closed ticket.
                            </div>
                        @else
                            <!-- Reply Form -->
                            <form action="{{ route('business.support.tickets.reply', $ticket->id) }}" method="POST"
                                  enctype="multipart/form-data">
                                @csrf
                                <div class="mb-3">
                                    <label for="message" class="form-label">Your Message</label>
                                    <textarea class="form-control" id="message" name="message" rows="4"
                                              required></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="attachments" class="form-label">Attachments (optional)</label>
                                    <input type="file" class="form-control" id="attachments" name="attachments[]"
                                           multiple>
                                </div>
                                <button type="submit" class="btn btn-primary">Send Reply</button>
                            </form>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
