@extends('layouts.business')

@section('title', 'Create Team')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-12">
            <h1 class="h3 mb-0">Create Team</h1>
            <p class="text-muted">Add a new team to {{ $business->business_name }}</p>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('business.teams.store') }}" method="POST">
                        @csrf

                        <div class="mb-3">
                            <label for="name" class="form-label">Team Name *</label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror"
                                id="name" name="name" value="{{ old('name') }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control @error('description') is-invalid @enderror"
                                id="description" name="description" rows="3">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="status" class="form-label">Status *</label>
                            <select class="form-select @error('status') is-invalid @enderror"
                                id="status" name="status" required>
                                <option value="">Select Status</option>
                                <option value="active" {{ old('status') === 'active' ? 'selected' : '' }}>Active</option>
                                <option value="inactive" {{ old('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                            </select>
                            @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Add Members (Optional)</label>
                            @if($staff && count($staff) > 0)
                                <div id="members-container">
                                    <div class="member-item mb-2">
                                        <select class="form-select form-select-sm member-select" name="members[]">
                                            <option value="">Select Staff Member</option>
                                            @foreach($staff as $staffMember)
                                                @if($staffMember->user)
                                                <option value="{{ $staffMember->user_id }}">
                                                    {{ $staffMember->user->first_name }} {{ $staffMember->user->last_name }}
                                                </option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <button type="button" class="btn btn-sm btn-outline-secondary mt-2" id="add-member-btn">
                                    <i class="fas fa-plus"></i> Add Another Member
                                </button>
                            @else
                                <div class="alert alert-info">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <strong>No staff members available yet.</strong> You can add staff members first, then add them to teams.
                                    <br>
                                    <a href="{{ route('business.staff.create', $business) }}" class="btn btn-sm btn-outline-primary mt-2">
                                        <i class="bi bi-plus-lg me-1"></i> Add Staff Member
                                    </a>
                                </div>
                            @endif
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Create Team
                            </button>
                            <a href="{{ route('business.teams.index', $business) }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Tips</h6>
                </div>
                <div class="card-body">
                    <ul class="small">
                        <li>Team names should be descriptive (e.g., "Management Team")</li>
                        <li>You can add members after creating the team</li>
                        <li>Team status determines visibility and access</li>
                        <li>Active teams show in staff interfaces</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.getElementById('add-member-btn').addEventListener('click', function() {
    const container = document.getElementById('members-container');
    const newItem = document.querySelector('.member-item').cloneNode(true);
    const select = newItem.querySelector('select');
    select.value = '';

    // Add remove button
    const removeBtn = document.createElement('button');
    removeBtn.type = 'button';
    removeBtn.className = 'btn btn-sm btn-danger ms-2';
    removeBtn.innerHTML = '<i class="fas fa-trash"></i>';
    removeBtn.style.display = 'inline-block';
    removeBtn.onclick = function() { newItem.remove(); };

    const wrapper = document.createElement('div');
    wrapper.className = 'member-item mb-2 d-flex gap-2';
    wrapper.appendChild(select);
    wrapper.appendChild(removeBtn);

    container.appendChild(wrapper);
});
</script>
@endpush
@endsection

