@extends('layouts.app')

@section('title', 'Edit Team')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-12">
            <h1 class="h3 mb-0">Edit Team</h1>
            <p class="text-muted">Update team details and members</p>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('business.teams.update', [$business, $team]) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="mb-3">
                            <label for="name" class="form-label">Team Name *</label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror"
                                id="name" name="name" value="{{ old('name', $team->name) }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control @error('description') is-invalid @enderror"
                                id="description" name="description" rows="3">{{ old('description', $team->description) }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="status" class="form-label">Status *</label>
                            <select class="form-select @error('status') is-invalid @enderror"
                                id="status" name="status" required>
                                <option value="active" {{ old('status', $team->status) === 'active' ? 'selected' : '' }}>Active</option>
                                <option value="inactive" {{ old('status', $team->status) === 'inactive' ? 'selected' : '' }}>Inactive</option>
                                <option value="archived" {{ old('status', $team->status) === 'archived' ? 'selected' : '' }}>Archived</option>
                            </select>
                            @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Team
                            </button>
                            <a href="{{ route('business.teams.show', [$business, $team]) }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card mb-3">
                <div class="card-header">
                    <h6 class="mb-0">Team Information</h6>
                </div>
                <div class="card-body">
                    <p class="mb-2"><strong>Members:</strong> {{ $team->member_count }}</p>
                    <p class="mb-2"><strong>Status:</strong> <span class="badge bg-{{ $team->status === 'active' ? 'success' : 'secondary' }}">{{ ucfirst($team->status) }}</span></p>
                    <p class="mb-0"><strong>Created:</strong> {{ $team->created_at->format('M d, Y') }}</p>
                </div>
            </div>

            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Danger Zone</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('business.teams.destroy', [$business, $team]) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm w-100"
                            onclick="return confirm('Are you sure? This action cannot be undone.')">
                            <i class="fas fa-trash"></i> Delete Team
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

