@extends('layouts.business')

@section('title', 'Business Teams')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <a href="{{ route('business.show', $business) }}" class="text-decoration-none">
                    {{ $business->business_name }}
                </a>
            </h1>
            <p class="text-muted">Teams</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('business.teams.create', $business) }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create Team
            </a>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Teams</h6>
                    <h3 class="mb-0">{{ $teams->total() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active Teams</h6>
                    <h3 class="mb-0">{{ $teams->where('status', 'active')->count() }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Members</h6>
                    <h3 class="mb-0">{{ $teams->sum('member_count') }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Teams Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Team Name</th>
                        <th>Description</th>
                        <th>Members</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($teams as $team)
                    <tr>
                        <td>
                            <strong>{{ $team->name }}</strong>
                        </td>
                        <td>
                            <small class="text-muted">{{ Str::limit($team->description, 50) }}</small>
                        </td>
                        <td>
                            <span class="badge bg-info">{{ $team->member_count }}</span>
                        </td>
                        <td>
                            <span class="badge bg-{{ $team->status === 'active' ? 'success' : 'secondary' }}">
                                {{ ucfirst($team->status) }}
                            </span>
                        </td>
                        <td><small>{{ $team->created_at->format('M d, Y') }}</small></td>
                        <td>
                            <a href="{{ route('business.teams.show', [$business, $team]) }}" class="btn btn-sm btn-info" title="View">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="{{ route('business.teams.edit', [$business, $team]) }}" class="btn btn-sm btn-warning" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            @if($team->status !== 'archived')
                                <form action="{{ route('business.teams.destroy', [$business, $team]) }}" method="POST" style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center text-muted py-4">
                            No teams yet. <a href="{{ route('business.teams.create', $business) }}">Create one</a>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            Showing {{ $teams->firstItem() ?? 0 }} to {{ $teams->lastItem() ?? 0 }} of {{ $teams->total() }} teams
        </div>
        <div>
            {{ $teams->links() }}
        </div>
    </div>
</div>
@endsection

