@extends('layouts.app')

@section('title', $team->name)

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">{{ $team->name }}</h1>
            <p class="text-muted">{{ $team->description }}</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('business.teams.edit', [$business, $team]) }}" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="{{ route('business.teams.index', $business) }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Team Info -->
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Team Information</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="text-muted small">Status</label>
                        <div>
                            <span class="badge bg-{{ $team->status === 'active' ? 'success' : 'secondary' }}">
                                {{ ucfirst($team->status) }}
                            </span>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Members</label>
                        <h5 class="mb-0">{{ $team->member_count }}</h5>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Created</label>
                        <h6 class="mb-0">{{ $team->created_at->format('M d, Y H:i') }}</h6>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Quick Actions</h6>
                </div>
                <div class="card-body">
                    <a href="{{ route('business.teams.chats', [$business, $team]) }}" class="btn btn-sm btn-outline-primary w-100 mb-2">
                        <i class="fas fa-comments"></i> View Chat
                    </a>
                </div>
            </div>
        </div>

        <!-- Team Members -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Team Members</h5>
                    <a href="{{ route('business.teams.add-member', [$business, $team]) }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Add Member
                    </a>
                </div>

                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Role</th>
                                <th>Status</th>
                                <th>Joined</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($team->members as $member)
                            <tr>
                                <td>
                                    <strong>{{ $member->first_name }} {{ $member->last_name }}</strong>
                                </td>
                                <td>{{ $member->email }}</td>
                                <td>
                                    @if($member->pivot->role_id)
                                        <span class="badge bg-primary">
                                            {{ \App\Models\Role::find($member->pivot->role_id)?->display_name ?? 'N/A' }}
                                        </span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-{{ $member->pivot->status === 'active' ? 'success' : 'warning' }}">
                                        {{ ucfirst(str_replace('_', ' ', $member->pivot->status)) }}
                                    </span>
                                </td>
                                <td>
                                    @if($member->pivot->joined_at)
                                        <small>{{ $member->pivot->joined_at->format('M d, Y') }}</small>
                                    @else
                                        <small class="text-muted">Pending</small>
                                    @endif
                                </td>
                                <td>
                                    <form action="{{ route('business.teams.remove-member', [$business, $team, $member]) }}" method="POST" style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Remove this member?')">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted py-4">
                                    No members yet. <a href="{{ route('business.teams.add-member', [$business, $team]) }}">Add one</a>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Team Chats -->
            <div class="card mt-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Team Chats</h5>
                    <a href="{{ route('business.teams.create-chat', [$business, $team]) }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> New Chat
                    </a>
                </div>

                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Chat Name</th>
                                <th>Participants</th>
                                <th>Messages</th>
                                <th>Last Message</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($team->chats as $chat)
                            <tr>
                                <td><strong>{{ $chat->name }}</strong></td>
                                <td>{{ $chat->participants->count() }}</td>
                                <td>{{ $chat->message_count }}</td>
                                <td>
                                    @if($chat->last_message_at)
                                        <small>{{ $chat->last_message_at->diffForHumans() }}</small>
                                    @else
                                        <small class="text-muted">-</small>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('business.teams.chat', [$business, $team, $chat]) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-comments"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted py-4">
                                    No chats yet.
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

