@extends('layouts.business')

@section('title', 'Edit Venue')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Edit Venue</h2>
            <p class="text-muted mb-0">Update venue information</p>
        </div>
        <a href="{{ route('business.venues.index') }}" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i>Back to Venues
        </a>
    </div>

    <form action="{{ route('business.venues.update', $venue->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="row g-4">
            <!-- Basic Information -->
            <div class="col-lg-8">
                <div class="table-card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0 fw-bold">Basic Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Venue Name (English) <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                       name="name" value="{{ old('name', $venue->name) }}" required>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Venue Name (Arabic)</label>
                                <input type="text" class="form-control @error('name_ar') is-invalid @enderror"
                                       name="name_ar" value="{{ old('name_ar', $venue->name_ar) }}" dir="rtl">
                                @error('name_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Category <span class="text-danger">*</span></label>
                                <select class="form-select @error('category_id') is-invalid @enderror"
                                        name="category_id" required>
                                    <option value="">Select Category</option>
                                    @foreach($categories ?? [] as $category)
                                        <option value="{{ $category->id }}" {{ old('category_id', $venue->category_id) == $category->id ? 'selected' : '' }}>
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('category_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Phone <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control @error('phone') is-invalid @enderror"
                                       name="phone" value="{{ old('phone', $venue->phone) }}" required>
                                @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Email</label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror"
                                       name="email" value="{{ old('email', $venue->email) }}">
                                @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Website</label>
                                <input type="url" class="form-control @error('website') is-invalid @enderror"
                                       name="website" value="{{ old('website', $venue->website) }}" placeholder="https://example.com">
                                @error('website')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (English)</label>
                                <textarea class="form-control @error('description') is-invalid @enderror"
                                          name="description" rows="4">{{ old('description', $venue->description) }}</textarea>
                                @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (Arabic)</label>
                                <textarea class="form-control @error('description_ar') is-invalid @enderror"
                                          name="description_ar" rows="4" dir="rtl">{{ old('description_ar', $venue->description_ar) }}</textarea>
                                @error('description_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Location Information -->
                <div class="table-card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0 fw-bold">Location Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12">
                                <label class="form-label">Address (English) <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('address') is-invalid @enderror"
                                          name="address" rows="2" required>{{ old('address', $venue->address) }}</textarea>
                                @error('address')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <label class="form-label">Address (Arabic)</label>
                                <textarea class="form-control @error('address_ar') is-invalid @enderror"
                                          name="address_ar" rows="2" dir="rtl">{{ old('address_ar', $venue->address_ar) }}</textarea>
                                @error('address_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">City <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('city') is-invalid @enderror"
                                       name="city" value="{{ old('city', $venue->city) }}" required>
                                @error('city')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Area <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('area') is-invalid @enderror"
                                       name="area" value="{{ old('area', $venue->area) }}" required>
                                @error('area')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Latitude <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('latitude') is-invalid @enderror"
                                       name="latitude" value="{{ old('latitude', $venue->latitude) }}" placeholder="25.2048" required>
                                @error('latitude')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Longitude <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('longitude') is-invalid @enderror"
                                       name="longitude" value="{{ old('longitude', $venue->longitude) }}" placeholder="55.2708" required>
                                @error('longitude')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <div class="alert alert-info d-flex align-items-center">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <small>You can get coordinates from Google Maps by right-clicking on the location</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Working Hours -->
                <div class="table-card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0 fw-bold">Working Hours</h5>
                    </div>
                    <div class="card-body">
                        @php
                            // Ensure working_hours is always an array
                            $hours = $venue->working_hours ?? [];
                            if (is_string($hours)) {
                                $hours = json_decode($hours, true) ?? [];
                            }
                        @endphp

                        @foreach(['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'] as $day)
                            @php
                                $key = strtolower($day);
                                $dayData = $hours[$key] ?? [];
                                $open   = old("working_hours.$key.open", $dayData['open'] ?? '09:00');
                                $close  = old("working_hours.$key.close", $dayData['close'] ?? '21:00');
                                $closed = old("working_hours.$key.is_closed", $dayData['is_closed'] ?? false);
                            @endphp

                            <div class="row g-2 mb-3 align-items-center">
                                <div class="col-md-2">
                                    <label class="form-label mb-0">{{ $day }}</label>
                                </div>

                                <div class="col-md-3">
                                    <input type="time" class="form-control" name="working_hours[{{ $key }}][open]" value="{{ $open }}" {{ $closed ? 'disabled' : '' }}>
                                </div>

                                <div class="col-md-3">
                                    <input type="time" class="form-control" name="working_hours[{{ $key }}][close]" value="{{ $close }}" {{ $closed ? 'disabled' : '' }}>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="working_hours[{{ $key }}][is_closed]" id="closed{{ $day }}" value="1" {{ $closed ? 'checked' : '' }}>
                                        <label class="form-check-label" for="closed{{ $day }}">Closed</label>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Images -->
                <div class="table-card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0 fw-bold">Images</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Featured Image</label>
                            <input type="file" class="form-control @error('featured_image') is-invalid @enderror" name="featured_image" accept="image/*">
                            @error('featured_image')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Main image for the venue</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Gallery Images</label>
                            <input type="file" class="form-control @error('images') is-invalid @enderror" name="images[]" accept="image/*" multiple>
                            @error('images')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">You can select multiple images</small>
                        </div>
                    </div>
                </div>

                <!-- Status & Settings -->
                <div class="table-card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0 fw-bold">Status & Settings</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status">
                                <option value="active" {{ old('status', $venue->status) == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="inactive" {{ old('status', $venue->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                <option value="under_maintenance" {{ old('status', $venue->status) == 'under_maintenance' ? 'selected' : '' }}>Under Maintenance</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Redeem Code</label>
                            <input type="text" class="form-control @error('redeem_code') is-invalid @enderror" name="redeem_code" value="{{ old('redeem_code', $venue->redeem_code) }}">
                            @error('redeem_code')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" name="is_featured" id="isFeatured" value="1" {{ old('is_featured', $venue->is_featured ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label" for="isFeatured">Featured Venue</label>
                        </div>
                    </div>
                </div>

                <!-- Amenities -->
                <div class="table-card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0 fw-bold">Amenities</h5>
                    </div>
                    @php
                        $selectedAmenities = old('amenities', $venue->amenities ?? []);
                        if (is_string($selectedAmenities)) {
                            $selectedAmenities = json_decode($selectedAmenities, true) ?? [];
                        }
                    @endphp
                    <div class="card-body">
                        @foreach(['parking','wifi','wheelchair','kids','outdoor','ac'] as $key)
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="amenities[]" value="{{ $key }}" id="{{ $key }}" {{ in_array($key, $selectedAmenities) ? 'checked' : '' }}>
                                <label class="form-check-label" for="{{ $key }}">{{ ucwords(str_replace('_',' ',$key)) }}</label>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Submit Buttons -->
                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="bi bi-check-lg me-2"></i>Update Venue
                    </button>
                    <a href="{{ route('business.venues.index') }}" class="btn btn-outline-secondary">Cancel</a>
                </div>
            </div>
        </div>
    </form>
@endsection

@push('scripts')
    <script>
        // Handle closed checkbox to disable time inputs
        document.querySelectorAll('[id^="closed"]').forEach(checkbox => {
            checkbox.addEventListener('change', function () {
                const row = this.closest('.row');
                const timeInputs = row.querySelectorAll('input[type="time"]');
                timeInputs.forEach(input => input.disabled = this.checked);
            });
        });
    </script>
@endpush
