@extends('layouts.business')

@section('title', 'Resubmit for Verification')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="bi bi-arrow-repeat"></i> Resubmit for Verification
            </h1>
            <p class="text-muted">Update your business information and resubmit</p>
        </div>
    </div>

    <!-- Rejection Info -->
    @if($business->rejection_checklist)
    <div class="alert alert-warning alert-dismissible fade show mb-4" role="alert">
        <strong><i class="bi bi-exclamation-triangle"></i> Please Address These Issues:</strong>
        <ul class="mb-0 mt-2">
            @foreach($business->rejection_checklist as $key => $item)
                @if($item['checked'])
                <li>{{ $item['label'] }}</li>
                @endif
            @endforeach
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <!-- Form -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-light">
            <h5 class="mb-0">Business Information</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('business.verification.resubmit') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="row g-3">
                    <!-- Business Name -->
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Business Name *</label>
                        <input type="text" name="business_name" class="form-control @error('business_name') is-invalid @enderror"
                               value="{{ old('business_name', $business->business_name) }}" required>
                        @error('business_name')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Trade License Number -->
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Trade License Number *</label>
                        <input type="text" name="trade_license_number" class="form-control @error('trade_license_number') is-invalid @enderror"
                               value="{{ old('trade_license_number', $business->trade_license_number) }}" required>
                        @error('trade_license_number')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Trade License Document -->
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Trade License Document</label>
                        <input type="file" name="trade_license_document" class="form-control @error('trade_license_document') is-invalid @enderror"
                               accept=".pdf,.jpg,.jpeg,.png">
                        @if($business->trade_license_document)
                        <small class="text-muted d-block mt-2">
                            <i class="bi bi-check-circle text-success"></i> Current: {{ basename($business->trade_license_document) }}
                        </small>
                        @endif
                        @error('trade_license_document')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Logo -->
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Business Logo</label>
                        <input type="file" name="logo" class="form-control @error('logo') is-invalid @enderror"
                               accept=".jpg,.jpeg,.png,.gif">
                        @if($business->logo)
                        <small class="text-muted d-block mt-2">
                            <i class="bi bi-check-circle text-success"></i> Logo uploaded
                        </small>
                        @endif
                        @error('logo')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Email -->
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Email Address *</label>
                        <input type="email" name="email" class="form-control @error('email') is-invalid @enderror"
                               value="{{ old('email', $business->email) }}" required>
                        @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Phone -->
                    <div class="col-md-6">
                        <label class="form-label fw-semibold">Phone Number *</label>
                        <input type="tel" name="phone" class="form-control @error('phone') is-invalid @enderror"
                               value="{{ old('phone', $business->phone) }}" required>
                        @error('phone')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Website -->
                    <div class="col-md-12">
                        <label class="form-label fw-semibold">Website (Optional)</label>
                        <input type="url" name="website" class="form-control @error('website') is-invalid @enderror"
                               value="{{ old('website', $business->website) }}" placeholder="https://example.com">
                        @error('website')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Description -->
                    <div class="col-md-12">
                        <label class="form-label fw-semibold">Business Description *</label>
                        <textarea name="description" rows="5" class="form-control @error('description') is-invalid @enderror"
                                  placeholder="Describe your business in detail (minimum 50 characters)" required>{{ old('description', $business->description) }}</textarea>
                        <small class="text-muted">Minimum 50 characters required</small>
                        @error('description')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-arrow-repeat"></i> Resubmit for Verification
                    </button>
                    <a href="{{ route('business.dashboard') }}" class="btn btn-secondary">
                        Cancel
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Important Notes -->
    <div class="card border-info mt-4">
        <div class="card-header bg-info text-white">
            <h6 class="mb-0"><i class="bi bi-info-circle"></i> Important</h6>
        </div>
        <div class="card-body">
            <ul class="mb-0">
                <li>Make sure all the rejected items are properly addressed</li>
                <li>You have <strong>{{ 3 - ($business->verification_attempts ?? 0) }}</strong> resubmission attempt(s) remaining</li>
                <li>Please provide accurate and complete information</li>
                <li>Upload clear, valid documents</li>
                <li>Your business will be reviewed again after resubmission</li>
            </ul>
        </div>
    </div>
</div>
@endsection

