@extends('layouts.business')

@section('title', 'Verification Status')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <i class="bi bi-shield-check"></i> Verification Status
            </h1>
            <p class="text-muted">Check your business verification status</p>
        </div>
    </div>

    <!-- Status Card -->
    @if($business->status === 'verified')
        <!-- Verified Status -->
        <div class="card border-success shadow-sm mb-4">
            <div class="card-body text-center py-5">
                <i class="bi bi-check-circle text-success" style="font-size: 3rem;"></i>
                <h4 class="mt-3 text-success">Business Verified</h4>
                <p class="text-muted">Your business has been verified and is active.</p>
                <small class="text-muted">
                    <i class="bi bi-calendar"></i> Verified on {{ $business->verified_at->format('F d, Y') }}
                </small>
            </div>
        </div>

    @elseif($business->status === 'rejected')
        <!-- Rejection Checklist Component -->
        @include('components.business-rejection-checklist')

    @elseif($business->status === 'pending')
        <!-- Pending Status -->
        <div class="card border-warning shadow-sm mb-4">
            <div class="card-body text-center py-5">
                <i class="bi bi-hourglass-split text-warning" style="font-size: 3rem;"></i>
                <h4 class="mt-3 text-warning">Pending Verification</h4>
                <p class="text-muted">Your business is being reviewed by our admin team.</p>
                <small class="text-muted">
                    <i class="bi bi-info-circle"></i> We'll notify you once the review is complete
                </small>
            </div>
        </div>

    @else
        <!-- Not Started -->
        <div class="card border-info shadow-sm mb-4">
            <div class="card-body text-center py-5">
                <i class="bi bi-exclamation-circle text-info" style="font-size: 3rem;"></i>
                <h4 class="mt-3 text-info">Verification Not Started</h4>
                <p class="text-muted">Complete your business profile to start the verification process.</p>
                <a href="{{ route('business.edit') }}" class="btn btn-info mt-3">
                    <i class="bi bi-pencil"></i> Complete Profile
                </a>
            </div>
        </div>
    @endif

    <!-- Additional Info -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-light">
            <h5 class="mb-0">Verification Information</h5>
        </div>
        <div class="card-body">
            <dl class="row">
                <dt class="col-sm-3">Current Status:</dt>
                <dd class="col-sm-9">
                    <span class="badge bg-{{ $business->status === 'verified' ? 'success' : ($business->status === 'rejected' ? 'danger' : 'warning') }}">
                        {{ ucfirst($business->status) }}
                    </span>
                </dd>

                @if($business->verified_at)
                <dt class="col-sm-3">Verified Date:</dt>
                <dd class="col-sm-9">{{ $business->verified_at->format('F d, Y H:i') }}</dd>

                <dt class="col-sm-3">Verified By:</dt>
                <dd class="col-sm-9">{{ $business->verifier->full_name ?? 'System Admin' }}</dd>
                @endif

                @if($business->verification_attempts > 0)
                <dt class="col-sm-3">Resubmission Attempts:</dt>
                <dd class="col-sm-9">
                    {{ $business->verification_attempts }} / 3
                    @if($business->verification_attempts >= 3)
                    <div class="alert alert-danger mt-2 mb-0">
                        <small><i class="bi bi-exclamation-triangle"></i> Maximum attempts reached. Please contact support.</small>
                    </div>
                    @endif
                </dd>
                @endif

                @if($business->verification_notes)
                <dt class="col-sm-3">Notes:</dt>
                <dd class="col-sm-9">{{ $business->verification_notes }}</dd>
                @endif
            </dl>
        </div>
    </div>
</div>
@endsection

