<!-- Venue Rejection Checklist Component -->
<!-- Display this when venue.status === 'rejected' -->

@if($venue->status === 'rejected' && $venue->rejection_checklist)
<div class="card border-danger shadow-sm mb-4">
    <div class="card-header bg-danger text-white">
        <h5 class="mb-0">
            <i class="bi bi-exclamation-circle"></i> Venue Rejected
        </h5>
    </div>
    <div class="card-body">
        <p class="text-muted">
            Your venue was rejected by the admin. Please review the rejection reasons below and update your venue information.
        </p>

        <!-- Admin's Rejection Reason -->
        @if($venue->rejection_reason)
        <div class="alert alert-warning mb-3">
            <strong>Admin's Note:</strong>
            <p class="mb-0 mt-2">{{ $venue->rejection_reason }}</p>
        </div>
        @endif

        <!-- Rejection Checklist -->
        <div class="mb-3">
            <h6 class="fw-bold mb-3">Please address the following issues:</h6>
            <div class="list-group">
                @foreach($venue->rejection_checklist as $key => $item)
                <div class="list-group-item">
                    <div class="d-flex align-items-center">
                        @if($item['checked'])
                        <i class="bi bi-x-circle text-danger fs-5 me-3"></i>
                        <div>
                            <p class="mb-0 fw-semibold">{{ $item['label'] }}</p>
                        </div>
                        @else
                        <i class="bi bi-check-circle text-success fs-5 me-3"></i>
                        <div>
                            <p class="mb-0 text-muted" style="text-decoration: line-through;">{{ $item['label'] }}</p>
                        </div>
                        @endif
                    </div>
                </div>
                @endforeach
            </div>
        </div>

        <!-- Resubmit Button -->
        <div class="mt-4">
            <a href="{{ route('business.venues.edit', $venue) }}" class="btn btn-primary">
                <i class="bi bi-pencil"></i> Update Venue & Resubmit
            </a>
            <small class="text-muted d-block mt-2">
                <i class="bi bi-info-circle"></i>
                Rejection Attempt: {{ $venue->verification_attempts ?? 1 }} / 3
            </small>
        </div>
    </div>
</div>
@endif

