@extends('layouts.business')

@section('title', 'Checkout - ' . $plan->name)

@section('content')
<div class="container-fluid py-4">
    <!-- Alert Container -->
    <div id="alertContainer"></div>

    <!-- Header -->
    <div class="row mb-5">
        <div class="col-md-8">
            <h1 class="h2 fw-bold mb-0">
                <i class="fas fa-shopping-cart me-2"></i>Checkout
            </h1>
            <p class="text-muted">Complete your subscription purchase</p>
        </div>
    </div>

    <div class="row">
        <!-- Order Summary -->
        <div class="col-lg-8 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light py-3 border-bottom">
                    <h5 class="mb-0 fw-bold">
                        <i class="fas fa-receipt me-2 text-primary"></i>Order Summary
                    </h5>
                </div>
                <div class="card-body p-4">
                    <!-- Plan Details -->
                    <div class="row mb-4 pb-4 border-bottom">
                        <div class="col-md-6">
                            <h6 class="fw-bold mb-2">{{ $plan->name }}</h6>
                            <p class="text-muted small mb-0">{{ $plan->description ?? 'Premium subscription plan' }}</p>
                        </div>
                        <div class="col-md-6 text-md-end">
                            @if($plan->price > 0)
                            <h6 class="fw-bold mb-2">AED {{ number_format($plan->price, 2) }}/month</h6>
                            <p class="text-muted small mb-0">Billed monthly</p>
                            @else
                            <h6 class="fw-bold mb-2 text-success">FREE</h6>
                            <p class="text-muted small mb-0">No charge</p>
                            @endif
                        </div>
                    </div>

                    <!-- Features -->
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3">
                            <i class="fas fa-star me-2 text-warning"></i>What's Included:
                        </h6>
                        <div class="row">
                            @if($plan->max_venues)
                            <div class="col-sm-6 mb-2">
                                <i class="fas fa-check-circle text-success me-2"></i>
                                <strong>{{ $plan->max_venues == -1 ? 'Unlimited' : $plan->max_venues }}</strong>
                                {{ $plan->max_venues == 1 ? 'Venue' : 'Venues' }}
                            </div>
                            @endif
                            @if($plan->max_offers)
                            <div class="col-sm-6 mb-2">
                                <i class="fas fa-check-circle text-success me-2"></i>
                                <strong>{{ $plan->max_offers == -1 ? 'Unlimited' : $plan->max_offers }}</strong>
                                {{ $plan->max_offers == 1 ? 'Offer' : 'Offers' }}
                            </div>
                            @endif
                            @if($plan->max_staff)
                            <div class="col-sm-6 mb-2">
                                <i class="fas fa-check-circle text-success me-2"></i>
                                <strong>{{ $plan->max_staff == -1 ? 'Unlimited' : $plan->max_staff }}</strong>
                                {{ $plan->max_staff == 1 ? 'Staff Member' : 'Staff Members' }}
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- Business Info -->
                    <div class="mb-4 pb-4 border-bottom">
                        <h6 class="fw-bold mb-3">
                            <i class="fas fa-building me-2 text-info"></i>Business Information
                        </h6>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <p class="text-muted small mb-1">Business Name</p>
                                <p class="fw-bold mb-0">{{ $business->business_name ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <p class="text-muted small mb-1">Email</p>
                                <p class="fw-bold mb-0">{{ $business->email ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Payment Method Selection -->
                    @if($plan->price > 0)
                    <form id="paymentMethodForm" method="POST">
                        @csrf
                        <div class="mb-4">
                            <h6 class="fw-bold mb-3">
                                <i class="fas fa-credit-card me-2 text-success"></i>Select Payment Method
                            </h6>
                            <div class="row">
                                @if($stripeEnabled)
                                <div class="col-md-6 mb-3">
                                    <div class="payment-method-card" onclick="selectPaymentMethod('stripe')">
                                        <input class="form-check-input payment-radio" type="radio" name="payment_method" id="stripe" value="stripe" checked>
                                        <label class="form-check-label w-100" for="stripe">
                                            <div class="p-3 border rounded cursor-pointer h-100">
                                                <div class="d-flex align-items-center">
                                                    <i class="fab fa-cc-stripe fa-2x text-primary me-3"></i>
                                                    <div>
                                                        <strong>Stripe</strong>
                                                        <br>
                                                        <small class="text-muted">Credit/Debit Card</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                                @endif

                                @if($paypalEnabled)
                                <div class="col-md-6 mb-3">
                                    <div class="payment-method-card" onclick="selectPaymentMethod('paypal')">
                                        <input class="form-check-input payment-radio" type="radio" name="payment_method" id="paypal" value="paypal">
                                        <label class="form-check-label w-100" for="paypal">
                                            <div class="p-3 border rounded cursor-pointer h-100">
                                                <div class="d-flex align-items-center">
                                                    <i class="fab fa-cc-paypal fa-2x text-primary me-3"></i>
                                                    <div>
                                                        <strong>PayPal</strong>
                                                        <br>
                                                        <small class="text-muted">Secure Payment</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                                @endif

                                @if(!$stripeEnabled && !$paypalEnabled)
                                <div class="col-12">
                                    <div class="alert alert-warning">
                                        <i class="fas fa-exclamation-triangle me-2"></i>
                                        No payment methods are currently available. Please contact support.
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>

                        <!-- Terms -->
                        <div class="form-check mb-4">
                            <input class="form-check-input" type="checkbox" id="agreeTerms" required>
                            <label class="form-check-label" for="agreeTerms">
                                I agree to the <a href="#" target="_blank" class="text-decoration-none">Terms of Service</a> and <a href="#" target="_blank" class="text-decoration-none">Privacy Policy</a>
                            </label>
                        </div>
                    </form>
                    @endif
                </div>
            </div>
        </div>

        <!-- Payment Summary Sidebar -->
        <div class="col-lg-4">
            <div class="card border-0 shadow-sm sticky-top" style="top: 20px;">
                <div class="card-header bg-primary text-white py-3 border-0">
                    <h5 class="mb-0 fw-bold">
                        <i class="fas fa-calculator me-2"></i>Payment Summary
                    </h5>
                </div>
                <div class="card-body p-4">
                    <!-- Price Breakdown -->
                    <div class="row mb-3">
                        <div class="col-6">
                            <p class="text-muted small mb-0">Plan Price</p>
                        </div>
                        <div class="col-6 text-end">
                            @if($plan->price > 0)
                            <p class="fw-bold mb-0">AED {{ number_format($plan->price, 2) }}</p>
                            @else
                            <p class="fw-bold mb-0 text-success">FREE</p>
                            @endif
                        </div>
                    </div>

                    @if($plan->price > 0)
                    <div class="row mb-3">
                        <div class="col-6">
                            <p class="text-muted small mb-0">Billing Cycle</p>
                        </div>
                        <div class="col-6 text-end">
                            <p class="fw-bold mb-0">Monthly</p>
                        </div>
                    </div>

                    <div class="row mb-3 pb-3 border-bottom">
                        <div class="col-6">
                            <p class="text-muted small mb-0">Tax (if applicable)</p>
                        </div>
                        <div class="col-6 text-end">
                            <p class="fw-bold mb-0">Calculated at checkout</p>
                        </div>
                    </div>
                    @endif

                    <!-- Total -->
                    <div class="row mb-4">
                        <div class="col-6">
                            <p class="fw-bold mb-0">Total Amount</p>
                        </div>
                        <div class="col-6 text-end">
                            @if($plan->price > 0)
                            <h4 class="fw-bold mb-0 text-primary">AED {{ number_format($plan->price, 2) }}</h4>
                            @else
                            <h4 class="fw-bold mb-0 text-success">FREE</h4>
                            @endif
                        </div>
                    </div>

                    <!-- Proceed Button -->
                    @if($plan->price > 0)
                    <button class="btn btn-primary btn-lg w-100 mb-3" id="proceedBtn" onclick="proceedToPayment()">
                        <i class="fas fa-lock me-2"></i>Proceed to Payment
                    </button>
                    @else
                    <button class="btn btn-success btn-lg w-100 mb-3" onclick="activateFreePlan({{ $plan->id }})">
                        <i class="fas fa-check me-2"></i>Activate Plan
                    </button>
                    @endif

                    <!-- Cancel Link -->
                    <a href="{{ route('business.subscription.index') }}" class="btn btn-outline-secondary w-100 mb-3">
                        <i class="fas fa-arrow-left me-2"></i>Back to Plans
                    </a>

                    <!-- Security Info -->
                    <div class="alert alert-light border mb-0">
                        <small class="d-block mb-2">
                            <i class="fas fa-shield-alt text-success me-2"></i>
                            <strong>Secure & Encrypted</strong>
                        </small>
                        <small class="text-muted">Your payment information is secure and encrypted.</small>
                    </div>
                </div>

                <!-- Info Footer -->
                <div class="card-footer bg-light border-top p-3">
                    <small class="text-muted d-block mb-1">
                        <i class="fas fa-info-circle me-1"></i>
                        @if($plan->price > 0)
                        <strong>Auto-Renewal:</strong> Your subscription will auto-renew on {{ now()->addDays($plan->duration_days ?? 30)->format('M d, Y') }}. You can cancel anytime.
                        @else
                        <strong>Valid Until:</strong> {{ now()->addDays($plan->duration_days ?? 30)->format('M d, Y') }}
                        @endif
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.payment-method-card {
    cursor: pointer;
}

.payment-method-card input[type="radio"]:checked + label {
    border-color: #0d6efd !important;
}

.payment-method-card .p-3 {
    transition: all 0.3s ease;
}

.payment-method-card input[type="radio"]:checked + label .p-3 {
    background-color: #f0f7ff;
    border: 2px solid #0d6efd !important;
}

.payment-method-card .p-3:hover {
    background-color: #f8f9fa;
}

.alert {
    border-radius: 0.5rem;
    border: none;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    animation: slideInDown 0.3s ease-out;
}

@keyframes slideInDown {
    from {
        opacity: 0;
        transform: translateY(-20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>

<script>
function selectPaymentMethod(method) {
    document.getElementById(method).checked = true;
}

function proceedToPayment() {
    // Validate terms agreement
    if (!document.getElementById('agreeTerms').checked) {
        showAlert('warning', 'Please Agree', 'You must agree to the terms and conditions');
        return;
    }

    const selectedMethod = document.querySelector('input[name="payment_method"]:checked');
    if (!selectedMethod) {
        showAlert('warning', 'Select Method', 'Please select a payment method');
        return;
    }

    const method = selectedMethod.value;
    const planId = {{ $plan->id }};

    // Show loading state
    const btn = document.getElementById('proceedBtn');
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Processing...';

    // Redirect based on payment method
    if (method === 'stripe') {
        // Stripe integration - redirect to Stripe checkout
        window.location.href = `/payment/stripe/checkout?plan_id=${planId}`;
    } else if (method === 'paypal') {
        // PayPal integration - redirect to PayPal checkout
        window.location.href = `/payment/paypal/checkout?plan_id=${planId}`;
    }
}

function activateFreePlan(planId) {
    const btn = event.target;
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Activating...';

    // Redirect to activate free plan
    window.location.href = `/business/subscription/activate/${planId}`;
}

function showAlert(type, title, message) {
    const alertHtml = `
        <div class="alert alert-${type} alert-dismissible fade show" role="alert">
            <strong>${title}:</strong> ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    `;

    const container = document.getElementById('alertContainer');
    container.innerHTML = alertHtml;

    // Auto-dismiss after 5 seconds
    setTimeout(() => {
        const alert = document.querySelector('.alert');
        if (alert) {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        }
    }, 5000);
}
</script>
@endsection

