@extends('layouts.business')

@section('title', 'PayPal Checkout - ' . $plan->name)

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-5">
        <div class="col-md-8">
            <h1 class="h2 fw-bold mb-0">
                <i class="fas fa-lock me-2"></i>Secure Payment
            </h1>
            <p class="text-muted">Complete your PayPal payment</p>
        </div>
    </div>

    <div class="row">
        <!-- Payment Form -->
        <div class="col-lg-8 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-primary text-white py-3 border-0">
                    <h5 class="mb-0 fw-bold">
                        <i class="fab fa-cc-paypal me-2"></i>PayPal Checkout
                    </h5>
                </div>
                <div class="card-body p-4">
                    <!-- PayPal Button Container -->
                    <div id="paypal-button-container" style="margin: 20px 0;"></div>

                    <!-- Loading indicator -->
                    <div id="loading" style="display: none;" class="text-center mt-4">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Processing...</span>
                        </div>
                        <p class="mt-2 text-muted">Processing your payment with PayPal...</p>
                    </div>

                    <!-- Error messages -->
                    <div id="error-message" class="alert alert-danger" style="display: none;"></div>

                    <p class="text-muted small mt-3">
                        You will be redirected to PayPal to securely complete your payment.
                    </p>
                </div>
            </div>

            <!-- Security Info -->
            <div class="alert alert-info mt-4">
                <i class="fas fa-shield-alt me-2"></i>
                <strong>Secure Payment:</strong> You will be redirected to PayPal's secure payment page. Your payment information is encrypted and secure.
            </div>
        </div>

        <!-- Order Summary Sidebar -->
        <div class="col-lg-4">
            <div class="card border-0 shadow-sm sticky-top" style="top: 20px;">
                <div class="card-header bg-light py-3 border-bottom">
                    <h5 class="mb-0 fw-bold">
                        <i class="fas fa-receipt me-2 text-primary"></i>Order Summary
                    </h5>
                </div>
                <div class="card-body p-4">
                    <!-- Plan Details -->
                    <div class="mb-3">
                        <p class="text-muted small mb-1">Plan</p>
                        <p class="fw-bold mb-0">{{ $plan->name }}</p>
                    </div>

                    <div class="mb-3">
                        <p class="text-muted small mb-1">Description</p>
                        <p class="small mb-0">{{ $plan->description ?? 'Premium subscription plan' }}</p>
                    </div>

                    <div class="mb-3 pb-3 border-bottom">
                        <p class="text-muted small mb-1">Business</p>
                        <p class="fw-bold mb-0">{{ $business->business_name }}</p>
                    </div>

                    <!-- Price -->
                    <div class="row mb-3">
                        <div class="col-6">
                            <p class="text-muted small mb-0">Price</p>
                        </div>
                        <div class="col-6 text-end">
                            <p class="fw-bold mb-0">AED {{ number_format($plan->price, 2) }}</p>
                        </div>
                    </div>

                    <div class="row mb-3 pb-3 border-bottom">
                        <div class="col-6">
                            <p class="text-muted small mb-0">Billing Cycle</p>
                        </div>
                        <div class="col-6 text-end">
                            <p class="fw-bold mb-0">Monthly</p>
                        </div>
                    </div>

                    <!-- Total -->
                    <div class="row">
                        <div class="col-6">
                            <p class="fw-bold mb-0">Total Amount</p>
                        </div>
                        <div class="col-6 text-end">
                            <h4 class="fw-bold mb-0 text-primary">AED {{ number_format($plan->price, 2) }}</h4>
                        </div>
                    </div>

                    <!-- Features -->
                    <div class="mt-4 pt-4 border-top">
                        <p class="fw-bold small mb-2">What's Included:</p>
                        <ul class="list-unstyled small">
                            @if($plan->max_venues)
                            <li class="mb-1"><i class="fas fa-check text-success me-2"></i>{{ $plan->max_venues == -1 ? 'Unlimited' : $plan->max_venues }} Venue(s)</li>
                            @endif
                            @if($plan->max_offers)
                            <li class="mb-1"><i class="fas fa-check text-success me-2"></i>{{ $plan->max_offers == -1 ? 'Unlimited' : $plan->max_offers }} Offer(s)</li>
                            @endif
                            @if($plan->max_staff)
                            <li class="mb-1"><i class="fas fa-check text-success me-2"></i>{{ $plan->max_staff == -1 ? 'Unlimited' : $plan->max_staff }} Staff Member(s)</li>
                            @endif
                        </ul>
                    </div>
                </div>

                <div class="card-footer bg-light border-top p-3">
                    <small class="text-muted">
                        <i class="fas fa-info-circle me-1"></i>
                        Your subscription will auto-renew on {{ now()->addDays($plan->duration_days ?? 30)->format('M d, Y') }}. You can cancel anytime.
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- PayPal SDK Script -->
<script src="https://www.paypal.com/sdk/js?client-id={{ config('services.paypal.client_id') }}&currency=AED"></script>
<script>
paypal.Buttons({
    style: {
        layout: 'vertical',
        color: 'blue',
        shape: 'rect',
        label: 'pay'
    },

    createOrder: function(data, actions) {
        return actions.order.create({
            purchase_units: [{
                amount: {
                    value: '{{ $plan->price }}',
                    currency_code: 'AED'
                },
                description: '{{ $plan->name }} - {{ $business->business_name }}',
                invoice_id: '{{ $payment->id }}'
            }],
            intent: 'CAPTURE',
            payer: {
                email_address: '{{ auth()->user()->email }}',
                name: {
                    given_name: '{{ explode(" ", auth()->user()->name)[0] }}',
                    surname: '{{ implode(" ", array_slice(explode(" ", auth()->user()->name), 1)) }}'
                }
            }
        });
    },

    onApprove: function(data, actions) {
        document.getElementById('loading').style.display = 'block';

        return actions.order.capture().then(function(orderData) {
            // Send payment completion to backend
            return fetch('/payment/paypal/complete', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify({
                    payment_id: {{ $payment->id }},
                    subscription_id: {{ $subscription->id }},
                    order_id: orderData.id,
                    payer_id: data.payerID
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    window.location.href = '/business/subscription/success?payment_id={{ $payment->id }}';
                } else {
                    document.getElementById('error-message').innerHTML = '<strong>Error:</strong> ' + (data.message || 'Payment processing failed');
                    document.getElementById('error-message').style.display = 'block';
                    document.getElementById('loading').style.display = 'none';
                }
            })
            .catch(error => {
                document.getElementById('error-message').innerHTML = '<strong>Error:</strong> Payment processing failed. Please try again.';
                document.getElementById('error-message').style.display = 'block';
                document.getElementById('loading').style.display = 'none';
                console.error('Error:', error);
            });
        });
    },

    onError: function(err) {
        document.getElementById('error-message').innerHTML = '<strong>Error:</strong> An error occurred during checkout. ' + err.message;
        document.getElementById('error-message').style.display = 'block';
        console.error('PayPal Error:', err);
    },

    onCancel: function(data) {
        document.getElementById('error-message').innerHTML = '<strong>Cancelled:</strong> Payment was cancelled. Please try again.';
        document.getElementById('error-message').style.display = 'block';
    }
}).render('#paypal-button-container');
</script>
@endsection

