@extends('layouts.business')

@section('title', 'Payment Successful')

@section('content')
<div class="container-fluid py-4">
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <!-- Success Card -->
            <div class="card border-0 shadow-lg">
                <div class="card-body p-5 text-center">
                    <!-- Success Icon -->
                    <div class="mb-4">
                        <div style="font-size: 4rem; color: #28a745;">
                            <i class="fas fa-check-circle"></i>
                        </div>
                    </div>

                    <!-- Success Message -->
                    <h1 class="h2 fw-bold mb-2">Payment Successful!</h1>
                    <p class="text-muted lead mb-4">Your subscription has been activated successfully.</p>

                    <!-- Payment Details -->
                    <div class="bg-light p-4 rounded mb-4 text-start">
                        <div class="row mb-3">
                            <div class="col-6">
                                <p class="text-muted small mb-1">Payment ID</p>
                                <p class="fw-bold mb-0">{{ $payment->id }}</p>
                            </div>
                            <div class="col-6 text-end">
                                <p class="text-muted small mb-1">Amount Paid</p>
                                <p class="fw-bold mb-0">AED {{ number_format($payment->amount, 2) }}</p>
                            </div>
                        </div>

                        <hr>

                        <div class="row mb-3">
                            <div class="col-6">
                                <p class="text-muted small mb-1">Payment Method</p>
                                <p class="fw-bold mb-0">
                                    @if($payment->payment_method === 'stripe')
                                    <i class="fab fa-cc-stripe me-1"></i> Stripe
                                    @elseif($payment->payment_method === 'paypal')
                                    <i class="fab fa-cc-paypal me-1"></i> PayPal
                                    @else
                                    {{ ucfirst($payment->payment_method) }}
                                    @endif
                                </p>
                            </div>
                            <div class="col-6 text-end">
                                <p class="text-muted small mb-1">Transaction ID</p>
                                <p class="fw-bold mb-0 small">{{ substr($payment->transaction_id, 0, 20) }}...</p>
                            </div>
                        </div>

                        <hr>

                        <div class="row">
                            <div class="col-6">
                                <p class="text-muted small mb-1">Status</p>
                                <p class="mb-0">
                                    <span class="badge bg-success">
                                        <i class="fas fa-check-circle me-1"></i>{{ ucfirst($payment->status) }}
                                    </span>
                                </p>
                            </div>
                            <div class="col-6 text-end">
                                <p class="text-muted small mb-1">Date</p>
                                <p class="fw-bold mb-0">{{ $payment->created_at->format('M d, Y H:i') }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Subscription Info -->
                    @if($payment->subscription)
                    <div class="bg-light p-4 rounded mb-4 text-start">
                        <h6 class="fw-bold mb-3">
                            <i class="fas fa-check-circle text-success me-2"></i>Subscription Activated
                        </h6>

                        <div class="row mb-2">
                            <div class="col-6">
                                <p class="text-muted small mb-1">Plan</p>
                                <p class="fw-bold mb-0">{{ $payment->subscription->plan->name ?? 'N/A' }}</p>
                            </div>
                            <div class="col-6 text-end">
                                <p class="text-muted small mb-1">Status</p>
                                <p class="mb-0">
                                    <span class="badge bg-success">Active</span>
                                </p>
                            </div>
                        </div>

                        <hr>

                        <div class="row mb-2">
                            <div class="col-6">
                                <p class="text-muted small mb-1">Start Date</p>
                                <p class="fw-bold mb-0">{{ $payment->subscription->start_date->format('M d, Y') }}</p>
                            </div>
                            <div class="col-6 text-end">
                                <p class="text-muted small mb-1">End Date</p>
                                <p class="fw-bold mb-0">{{ $payment->subscription->end_date->format('M d, Y') }}</p>
                            </div>
                        </div>

                        <hr>

                        <div>
                            <p class="text-muted small mb-1">Billing Cycle</p>
                            <p class="fw-bold mb-0">
                                <i class="fas fa-sync-alt me-1 text-info"></i>
                                {{ $payment->subscription->auto_renew ? 'Auto-Renewing Monthly' : 'One-Time Payment' }}
                            </p>
                        </div>
                    </div>
                    @endif

                    <!-- Action Buttons -->
                    <div class="d-grid gap-2">
                        <a href="{{ route('business.dashboard') }}" class="btn btn-primary btn-lg">
                            <i class="fas fa-arrow-right me-2"></i>Go to Dashboard
                        </a>
                        <a href="{{ route('business.subscription.index') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-list me-2"></i>View Subscriptions
                        </a>
                    </div>

                    <!-- Info Message -->
                    <div class="alert alert-info mt-4 mb-0">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Next Steps:</strong> Your subscription is now active. You can start using all features immediately.
                        @if($payment->subscription?->auto_renew && $payment->subscription?->next_billing_date)
                        Your subscription will automatically renew on {{ $payment->subscription->next_billing_date->format('M d, Y') }}.
                        @endif
                    </div>
                </div>
            </div>

            <!-- Support Card -->
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-body p-4 text-center">
                    <h6 class="fw-bold mb-2">Need Help?</h6>
                    <p class="text-muted small mb-0">
                        If you have any questions about your subscription, please contact our support team.
                    </p>
                    <a href="{{ route('business.support.index') }}" class="btn btn-sm btn-outline-primary mt-2">
                        <i class="fas fa-headset me-1"></i>Contact Support
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.badge {
    font-size: 0.85rem;
    padding: 0.5rem 0.75rem;
}

.card {
    border-radius: 0.5rem;
    animation: slideInUp 0.3s ease-out;
}

@keyframes slideInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>
@endsection

