<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\{
    AdminConfigurationController,
    AdminActivityController,
    AdminSessionController,
    AdminSubscriptionController,
    UserController,
    RoleController,
    PermissionController,
    DashboardController,
    AnalyticsController,
    SpotlightController,
    SettingsController,
    AuthController
};

/*
|--------------------------------------------------------------------------
| Admin Routes - Enhanced Administration Panel
|--------------------------------------------------------------------------
*/

Route::middleware(['auth:sanctum', 'admin.security'])->prefix('admin')->group(function () {

    // ========== DASHBOARD ==========
    Route::get('dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('dashboard/statistics', [DashboardController::class, 'statistics']);
    Route::get('dashboard/activity-summary', [DashboardController::class, 'activitySummary']);

    // ========== ADVANCED ANALYTICS ==========
    Route::prefix('analytics')->name('admin.analytics.')->group(function () {
        Route::get('/', [AnalyticsController::class, 'index'])->name('index');
        Route::get('data', [AnalyticsController::class, 'getData'])->name('data');
        Route::get('activity-trends', [AnalyticsController::class, 'activityTrends'])->name('activity-trends');
        Route::get('user-analytics', [AnalyticsController::class, 'userAnalytics'])->name('user-analytics');
        Route::get('admin-performance', [AnalyticsController::class, 'adminPerformance'])->name('admin-performance');
        Route::get('security-metrics', [AnalyticsController::class, 'securityMetrics'])->name('security-metrics');
        Route::get('system-health', [AnalyticsController::class, 'systemHealth'])->name('system-health');
        Route::get('activity-breakdown', [AnalyticsController::class, 'activityBreakdown'])->name('activity-breakdown');
        Route::get('hourly-pattern', [AnalyticsController::class, 'hourlyPattern'])->name('hourly-pattern');
        Route::get('user-retention', [AnalyticsController::class, 'userRetention'])->name('user-retention');
        Route::get('export', [AnalyticsController::class, 'export'])->name('export');

        // Reports
        Route::get('reports/redemptions', [AnalyticsController::class, 'redemptionsReport'])->name('reports.redemptions');
        Route::get('reports/businesses', [AnalyticsController::class, 'businessReport'])->name('reports.businesses');
        Route::get('reports/users', [AnalyticsController::class, 'userReport'])->name('reports.users');
    });

    // ========== ADVANCED CONFIGURATION MANAGEMENT ==========
    Route::prefix('configurations')->group(function () {
        Route::get('/', [AdminConfigurationController::class, 'index'])->name('admin.configurations.index');
        Route::post('/', [AdminConfigurationController::class, 'update'])->name('admin.configurations.update');
        Route::post('bulk-update', [AdminConfigurationController::class, 'bulkUpdate'])->name('admin.configurations.bulk-update');

        // Configuration Versioning
        Route::post('snapshot', [AdminConfigurationController::class, 'createSnapshot']);
        Route::get('versions', [AdminConfigurationController::class, 'getVersions']);
        Route::get('versions/{versionId}', [AdminConfigurationController::class, 'showVersion']);
        Route::post('versions/{versionId}/restore', [AdminConfigurationController::class, 'restoreVersion']);
        Route::post('versions/compare', [AdminConfigurationController::class, 'compareVersions']);
        Route::delete('versions/{versionId}', [AdminConfigurationController::class, 'deleteVersion']);
    });

    // ========== ADMIN ACTIVITY & AUDIT LOGS ==========
    Route::prefix('activities')->group(function () {
        Route::get('/', [AdminActivityController::class, 'index'])->name('admin.activities.index');
        Route::get('{id}', [AdminActivityController::class, 'show'])->name('admin.activities.show');
        Route::post('export', [AdminActivityController::class, 'export']);
        Route::get('statistics', [AdminActivityController::class, 'statistics']);
        Route::get('entity/{entityType}/{entityId}', [AdminActivityController::class, 'entityAuditTrail']);
        Route::get('user/{userId}', [AdminActivityController::class, 'userActivityTimeline']);
        Route::post('purge', [AdminActivityController::class, 'purgeOldLogs'])->middleware('admin.super_admin');
    });

    // ========== ADMIN SESSION MANAGEMENT ==========
    Route::prefix('sessions')->group(function () {
        Route::get('/', [AdminSessionController::class, 'index'])->name('admin.sessions.index');
        Route::get('{id}', [AdminSessionController::class, 'show'])->name('admin.sessions.show');
        Route::post('{id}/terminate', [AdminSessionController::class, 'terminate']);
        Route::post('user/{userId}', [AdminSessionController::class, 'userSessions']);
        Route::post('user/{userId}/terminate', [AdminSessionController::class, 'terminateUserSessions']);
        Route::get('statistics', [AdminSessionController::class, 'statistics']);
        Route::get('user/{userId}/activity', [AdminSessionController::class, 'userActivity']);
        Route::post('cleanup', [AdminSessionController::class, 'cleanup'])->middleware('admin.super_admin');
    });

    // ========== ENHANCED USER MANAGEMENT ==========
    Route::prefix('users')->group(function () {
        Route::get('/', [UserController::class, 'index'])->name('admin.users.index');
        Route::get('create', [UserController::class, 'create'])->name('admin.users.create');
        Route::post('/', [UserController::class, 'store'])->name('admin.users.store');
        Route::get('{id}', [UserController::class, 'show'])->name('admin.users.show');
        Route::get('{id}/edit', [UserController::class, 'edit'])->name('admin.users.edit');
        Route::put('{id}', [UserController::class, 'update'])->name('admin.users.update');
        Route::delete('{id}', [UserController::class, 'destroy'])->name('admin.users.destroy');

        // Bulk operations
        Route::post('bulk/status', [UserController::class, 'bulkUpdateStatus']);
        Route::post('bulk/roles', [UserController::class, 'bulkAssignRoles']);
        Route::post('bulk/delete', [UserController::class, 'bulkDelete']);

        // Restore
        Route::post('{id}/restore', [UserController::class, 'restore']);

        // Activity
        Route::get('{id}/activity-summary', [UserController::class, 'getActivitySummary']);
        Route::get('{id}/permissions', [UserController::class, 'getPermissions']);
        Route::post('{id}/export', [UserController::class, 'exportData']);
    });

    // ========== ROLE MANAGEMENT ==========
    Route::prefix('roles')->group(function () {
        Route::get('/', [RoleController::class, 'index'])->name('admin.roles.index');
        Route::get('create', [RoleController::class, 'create'])->name('admin.roles.create');
        Route::post('/', [RoleController::class, 'store'])->name('admin.roles.store');
        Route::get('{id}', [RoleController::class, 'show'])->name('admin.roles.show');
        Route::get('{id}/edit', [RoleController::class, 'edit'])->name('admin.roles.edit');
        Route::put('{id}', [RoleController::class, 'update'])->name('admin.roles.update');
        Route::delete('{id}', [RoleController::class, 'destroy'])->name('admin.roles.destroy');

        // Permissions Management
        Route::get('{id}/permissions', [RoleController::class, 'permissions'])->name('admin.roles.permissions');
        Route::post('{id}/permissions', [RoleController::class, 'syncPermissions'])->name('admin.roles.sync-permissions');

        // Hierarchy
        Route::get('{id}/hierarchy', [RoleController::class, 'getHierarchy'])->name('admin.roles.hierarchy');
        Route::post('{id}/parent', [RoleController::class, 'setParent'])->name('admin.roles.set-parent');
    });

    // ========== PERMISSION MANAGEMENT ==========
    Route::prefix('permissions')->group(function () {
        Route::get('/', [PermissionController::class, 'index'])->name('admin.permissions.index');
        Route::get('create', [PermissionController::class, 'create'])->name('admin.permissions.create');
        Route::post('/', [PermissionController::class, 'store'])->name('admin.permissions.store');
        Route::get('{id}', [PermissionController::class, 'show'])->name('admin.permissions.show');
        Route::get('{id}/edit', [PermissionController::class, 'edit'])->name('admin.permissions.edit');
        Route::put('{id}', [PermissionController::class, 'update'])->name('admin.permissions.update');
        Route::delete('{id}', [PermissionController::class, 'destroy'])->name('admin.permissions.destroy');

        // Grouped permissions
        Route::get('group/{group}', [PermissionController::class, 'getByGroup']);
        Route::get('groups/list', [PermissionController::class, 'listGroups']);
    });

    // ========== SPOTLIGHT MANAGEMENT ==========
    Route::prefix('spotlight')->name('admin.spotlight.')->group(function () {
        Route::get('/', [SpotlightController::class, 'index'])->name('index');
        Route::get('create', [SpotlightController::class, 'create'])->name('create');
        Route::post('/', [SpotlightController::class, 'store'])->name('store');
        Route::get('{id}', [SpotlightController::class, 'show'])->name('show');
        Route::get('{id}/edit', [SpotlightController::class, 'edit'])->name('edit');
        Route::put('{id}', [SpotlightController::class, 'update'])->name('update');
        Route::delete('{id}', [SpotlightController::class, 'destroy'])->name('destroy');
        Route::post('{id}/approve', [SpotlightController::class, 'approve'])->name('approve');
        Route::post('{id}/reject', [SpotlightController::class, 'reject'])->name('reject');
        Route::get('offer/{offerId}', [SpotlightController::class, 'forOffer'])->name('forOffer');
    });

    // ========== SUBSCRIPTION MANAGEMENT ==========
    Route::prefix('subscriptions')->name('admin.subscriptions.')->group(function () {
        Route::get('/', [AdminSubscriptionController::class, 'index'])->name('index');
        Route::get('{subscriptionId}/usage', [AdminSubscriptionController::class, 'getUsage'])->name('usage');
        Route::get('{subscriptionId}/edit', [AdminSubscriptionController::class, 'edit'])->name('edit');
        Route::put('{subscriptionId}', [AdminSubscriptionController::class, 'update'])->name('update');
        Route::post('{subscriptionId}/cancel', [AdminSubscriptionController::class, 'cancel'])->name('cancel');
        Route::post('{subscriptionId}/renew', [AdminSubscriptionController::class, 'renew'])->name('renew');
    });

    // ========== SETTINGS ==========
    // Consolidated into Configuration - redirect for backward compatibility
    Route::prefix('settings')->group(function () {
        Route::get('/', function () {
            return redirect()->route('admin.configurations.index');
        })->name('admin.settings.index');

        Route::post('{section}', function ($section) {
            return redirect()->route('admin.configurations.index');
        })->name('admin.settings.update');
    });

    // ========== ADMIN PROFILE & SECURITY ==========
    Route::prefix('me')->group(function () {
        Route::get('/', [AuthController::class, 'getProfile']);
        Route::put('/', [AuthController::class, 'updateProfile']);
        Route::post('password', [AuthController::class, 'changePassword']);
        Route::post('sessions', [AuthController::class, 'getMySessions']);
        Route::post('sessions/{sessionId}/terminate', [AuthController::class, 'terminateSession']);
    });
});

/*
|--------------------------------------------------------------------------
| Super Admin Only Routes
|--------------------------------------------------------------------------
*/

Route::middleware(['auth:sanctum', 'admin.role:super_admin'])->prefix('admin')->group(function () {
    Route::post('system-health', [\App\Http\Controllers\Admin\DashboardController::class, 'systemHealth']);
    Route::post('backup-config', [\App\Http\Controllers\Admin\AdminConfigurationController::class, 'createBackup']);
    Route::post('restore-config', [\App\Http\Controllers\Admin\AdminConfigurationController::class, 'restoreBackup']);
});

