<?php

// Admin Routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Dashboard
    Route::get('/', function () {
        return view('admin.dashboard');
    })->name('dashboard');

    // Teams Management
    Route::resource('teams', \App\Http\Controllers\Admin\TeamController::class);
    Route::post('teams/{team}/members', [\App\Http\Controllers\Admin\TeamController::class, 'addMember'])
        ->name('teams.add-member');
    Route::delete('teams/{team}/members/{user}', [\App\Http\Controllers\Admin\TeamController::class, 'removeMember'])
        ->name('teams.remove-member');
    Route::get('teams/{team}/members', [\App\Http\Controllers\Admin\TeamController::class, 'getMembers'])
        ->name('teams.get-members');

    // Staff Management
    Route::resource('staff', \App\Http\Controllers\Admin\StaffController::class);

    // Chats Management (existing)
    Route::resource('chats', \App\Http\Controllers\Admin\ChatController::class);
    Route::post('chats/{chat}/messages', [\App\Http\Controllers\Admin\ChatController::class, 'postMessage'])
        ->name('chats.post-message');
    Route::get('chats/{chat}/messages', [\App\Http\Controllers\Admin\ChatController::class, 'getMessages'])
        ->name('chats.get-messages');
    Route::post('chats/{chat}/read', [\App\Http\Controllers\Admin\ChatController::class, 'markAsRead'])
        ->name('chats.mark-read');

    // Notification Templates (existing)
    Route::prefix('notifications')->name('notifications.')->group(function () {
        // Email Templates
        Route::get('email-templates', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailIndex'])
            ->name('email-templates.index');
        Route::get('email-templates/create', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailCreate'])
            ->name('email-templates.create');
        Route::post('email-templates', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailStore'])
            ->name('email-templates.store');
        Route::get('email-templates/{emailTemplate}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailShow'])
            ->name('email-templates.show');
        Route::get('email-templates/{emailTemplate}/edit', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailEdit'])
            ->name('email-templates.edit');
        Route::put('email-templates/{emailTemplate}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailUpdate'])
            ->name('email-templates.update');
        Route::delete('email-templates/{emailTemplate}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailDestroy'])
            ->name('email-templates.destroy');
        Route::post('email-templates/{emailTemplate}/preview', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailPreview'])
            ->name('email-templates.preview');

        // SMS Templates
        Route::get('sms-templates', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsIndex'])
            ->name('sms-templates.index');
        Route::get('sms-templates/create', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsCreate'])
            ->name('sms-templates.create');
        Route::post('sms-templates', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsStore'])
            ->name('sms-templates.store');
        Route::get('sms-templates/{smsTemplate}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsShow'])
            ->name('sms-templates.show');
        Route::get('sms-templates/{smsTemplate}/edit', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsEdit'])
            ->name('sms-templates.edit');
        Route::put('sms-templates/{smsTemplate}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsUpdate'])
            ->name('sms-templates.update');
        Route::delete('sms-templates/{smsTemplate}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsDestroy'])
            ->name('sms-templates.destroy');
        Route::post('sms-templates/{smsTemplate}/preview', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsPreview'])
            ->name('sms-templates.preview');
    });
});

// Business Routes
Route::middleware(['auth', 'business'])->group(function () {
    // Business Dashboard
    Route::get('/business/{business}', [\App\Http\Controllers\Business\DashboardController::class, 'show'])
        ->name('business.show');

    // Teams (Business Scope)
    Route::resource('business.teams', \App\Http\Controllers\Business\TeamController::class)
        ->scoped(['business' => 'id']);
    Route::post('business/{business}/teams/{team}/members', [\App\Http\Controllers\Business\TeamController::class, 'addMember'])
        ->name('business.teams.add-member');
    Route::delete('business/{business}/teams/{team}/members/{user}', [\App\Http\Controllers\Business\TeamController::class, 'removeMember'])
        ->name('business.teams.remove-member');

    // Staff (Business Scope)
    Route::resource('business.staff', \App\Http\Controllers\Business\StaffController::class)
        ->scoped(['business' => 'id']);

    // Chats (Business Scope)
    Route::get('business/{business}/teams/{team}/chats', [\App\Http\Controllers\Business\TeamController::class, 'chats'])
        ->name('business.teams.chats');
});

// API Routes (for mobile and real-time)
Route::middleware('auth:sanctum')->prefix('api')->group(function () {
    // Chat API
    Route::prefix('chats')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\ChatController::class, 'index']);
        Route::post('/', [\App\Http\Controllers\Admin\ChatController::class, 'store']);
        Route::get('{chat}', [\App\Http\Controllers\Admin\ChatController::class, 'show']);
        Route::post('{chat}/messages', [\App\Http\Controllers\Admin\ChatController::class, 'postMessage']);
        Route::get('{chat}/messages', [\App\Http\Controllers\Admin\ChatController::class, 'getMessages']);
        Route::post('{chat}/read', [\App\Http\Controllers\Admin\ChatController::class, 'markAsRead']);
    });

    // Team API
    Route::prefix('teams')->group(function () {
        Route::get('/', function () {
            return response()->json([
                'data' => \App\Models\Team::paginate(15),
            ]);
        });
        Route::get('{team}/members', [\App\Http\Controllers\Admin\TeamController::class, 'getMembers']);
    });
});

