<?php

use App\Http\Controllers\Admin\{AuditController as AdminAuditController,
    AuthController as AdminAuthController,
    BusinessController as AdminBusinessController,
    CategoryController as AdminCategoryController,
    AdminConfigurationController,
    DashboardController as AdminDashboardController,
    FaqController as AdminFaqController,
    GdprController as AdminGdprController,
    MarketingController as AdminMarketingController,
    OfferController as AdminOfferController,
    SettingsController as AdminSettingsController,
    SpotlightController as AdminSpotlightController,
    SubscriptionPlanController as AdminSubscriptionPlanController,
    TeamController as AdminTeamController,
    UserController as AdminUserController,
    VenueController as AdminVenueController};
use App\Http\Controllers\Business\{AnalyticsController as BusinessAnalyticsController,
    AuthController as BusinessAuthController,
    DashboardController as BusinessDashboardController,
    MarketingController as BusinessMarketingController,
    NotificationController as BusinessNotificationController,
    OfferController as BusinessOfferController,
    RedemptionController as BusinessRedemptionController,
    ReferralController as BusinessReferralController,
    RegistrationController as BusinessRegistrationController,
    SettingsController as BusinessSettingsController,
    SubscriptionController as BusinessSubscriptionController,
    StaffController as BusinessStaffController,
    TeamController,
    VenueController as BusinessVenueController};
use App\Http\Controllers\Payment\WebhookController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes - Privasee Platform
|--------------------------------------------------------------------------
*/

// Landing Page
Route::get('/', function () {
    $userPlans = \App\Models\SubscriptionPlan::where('type', 'user')
        ->where('is_active', true)
        ->orderBy('price', 'asc')
        ->get();

    $businessPlans = \App\Models\SubscriptionPlan::where('type', 'business')
        ->where('is_active', true)
        ->orderBy('price', 'asc')
        ->get();

    return view('welcome', compact('userPlans', 'businessPlans'));
})->name('home');

// Payment Webhooks (must be before any middleware that blocks them)
Route::post('/webhooks/stripe', [WebhookController::class, 'stripe'])->name('webhooks.stripe');
Route::post('/webhooks/paypal', [WebhookController::class, 'paypal'])->name('webhooks.paypal');

// Payment Routes (Public - AJAX endpoints)
Route::prefix('payment')->name('payment.')->group(function () {
    Route::post('/stripe/create-intent', [\App\Http\Controllers\Payment\StripeController::class, 'createIntent'])->name('create-intent');
    Route::post('/stripe/process', [\App\Http\Controllers\Payment\StripeController::class, 'process'])->name('process');
    Route::get('/checkout', [\App\Http\Controllers\Payment\StripeController::class, 'checkout'])->name('checkout');
    Route::post('/checkout', [\App\Http\Controllers\Payment\StripeController::class, 'processCheckout'])->name('checkout.process');
    Route::get('/stripe/checkout', [\App\Http\Controllers\Payment\StripeController::class, 'stripeCheckout'])->name('stripe.checkout');
    Route::get('/paypal/checkout', [\App\Http\Controllers\Payment\StripeController::class, 'paypalCheckout'])->name('paypal.checkout');
    Route::get('/success', [\App\Http\Controllers\Payment\StripeController::class, 'success'])->name('success');
    Route::post('/paypal/complete', [\App\Http\Controllers\Payment\StripeController::class, 'paypalComplete'])->name('paypal.complete');
    Route::post('/stripe/webhook', [\App\Http\Controllers\Payment\StripeController::class, 'webhook'])->name('webhook');
    Route::get('/renew', [\App\Http\Controllers\Payment\StripeController::class, 'renew'])->name('renew');
    Route::post('/renew', [\App\Http\Controllers\Payment\StripeController::class, 'processRenew'])->name('renew.process');
});

// User Authentication Routes (API-based, but we need named routes for redirects)
Route::get('/login', function () {
    return redirect('/business/login');
})->name('login');

Route::get('/register', function () {
    return redirect('/business/register');
})->name('register');
// Team Invitation Acceptance Routes
Route::get('business/team/accept/{id}', [TeamController::class, 'accept'])->name('business.team.accept-invitation');
Route::post('business/team/accept/{id}', [TeamController::class, 'complete'])->name('business.team.accept.complete');

// Staff Invitation Acceptance Routes
Route::get('staff/accept-invitation/{token}', [BusinessStaffController::class, 'acceptInvitation'])->name('staff.accept-invitation');
Route::post('staff/accept-invitation/{token}', [BusinessStaffController::class, 'completeInvitation'])->name('staff.accept-invitation.complete');

// Business Authentication Routes (Public)
Route::prefix('business')->name('business.')->group(function () {
    // Registration
    Route::get('/register', [BusinessRegistrationController::class, 'showRegistrationForm'])->name('register');
    Route::post('/register', [BusinessRegistrationController::class, 'register'])->name('register.submit');
    Route::post('/check-availability', [BusinessRegistrationController::class, 'checkAvailability'])->name('check-availability');

    // Login
    Route::get('/login', [BusinessAuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [BusinessAuthController::class, 'login'])->name('login.submit');

    // Password Reset
    Route::get('/forgot-password', [BusinessAuthController::class, 'showPasswordResetForm'])->name('password.request');
    Route::post('/forgot-password', [BusinessAuthController::class, 'sendPasswordResetLink'])->name('password.email');


});
// Logout
Route::post('/logout', [BusinessAuthController::class, 'logout'])->name('logout');
// Business Portal Routes (Protected)
Route::prefix('business')->name('business.')->middleware(['auth', 'track.user.activity'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [BusinessDashboardController::class, 'index'])->name('dashboard');
    Route::get('/business/{business}', [\App\Http\Controllers\Business\DashboardController::class, 'show'])
        ->name('show');
    // Analytics
    Route::get('/analytics', [BusinessAnalyticsController::class, 'index'])->name('analytics');
    Route::get('/analytics/data', [BusinessAnalyticsController::class, 'getData'])->name('analytics.data');

    // Team Management
    Route::prefix('teams')->name('teams.')->group(function () {
        Route::get('/', [TeamController::class, 'index'])->name('index');
        Route::get('/create', [TeamController::class, 'create'])->name('create');
        Route::post('/', [TeamController::class, 'store'])->name('store');
        Route::get('/{id}', [TeamController::class, 'show'])->name('show');
        Route::put('/{id}', [TeamController::class, 'update'])->name('update');
        Route::delete('/{id}', [TeamController::class, 'destroy'])->name('destroy');
        Route::post('/{id}/resend-invitation', [TeamController::class, 'resendInvitation'])->name('resend-invitation');


    });

    // Venues Management
    Route::get('/venues', [BusinessVenueController::class, 'index'])->name('venues.index');
    Route::get('/venues/create', [BusinessVenueController::class, 'create'])->name('venues.create');
    Route::post('/venues', [BusinessVenueController::class, 'store'])->name('venues.store');
    Route::get('/venues/{id}', [BusinessVenueController::class, 'show'])->name('venues.show');
    Route::get('/venues/{id}/edit', [BusinessVenueController::class, 'edit'])->name('venues.edit');
    Route::put('/venues/{id}', [BusinessVenueController::class, 'update'])->name('venues.update');
    Route::delete('/venues/{id}', [BusinessVenueController::class, 'destroy'])->name('venues.destroy');

    // Offers Management
    Route::get('/offers', [BusinessOfferController::class, 'index'])->name('offers.index');
    Route::get('/offers/create', [BusinessOfferController::class, 'create'])->name('offers.create');
    Route::post('/offers', [BusinessOfferController::class, 'store'])->name('offers.store');
    Route::get('/offers/{id}', [BusinessOfferController::class, 'show'])->name('offers.show');
    Route::get('/offers/{id}/edit', [BusinessOfferController::class, 'edit'])->name('offers.edit');
    Route::put('/offers/{id}', [BusinessOfferController::class, 'update'])->name('offers.update');
    Route::delete('/offers/{id}', [BusinessOfferController::class, 'destroy'])->name('offers.destroy');
    Route::post('/offers/{id}/toggle-status', [BusinessOfferController::class, 'toggleStatus'])->name('offers.toggle-status');
    Route::post('/offers/{id}/duplicate', [BusinessOfferController::class, 'duplicate'])->name('offers.duplicate');

    // Redemptions
    Route::get('/redemptions', [BusinessRedemptionController::class, 'index'])->name('redemptions');
    Route::get('/redemptions/export', [BusinessRedemptionController::class, 'export'])->name('redemptions.export');
    Route::get('/redemptions/{id}', [BusinessRedemptionController::class, 'show'])->name('redemptions.show');
    Route::post('/redemptions/{id}/verify', [BusinessRedemptionController::class, 'verify'])->name('redemptions.verify');
    Route::post('/redemptions/{id}/reject', [BusinessRedemptionController::class, 'reject'])->name('redemptions.reject');

    // Subscription
    Route::get('/subscription', [BusinessSubscriptionController::class, 'index'])
        ->name('subscription.index');
    Route::get('/subscription/plans', [BusinessSubscriptionController::class, 'plans'])
        ->name('subscription.plans');
    Route::get('/subscription/plan/{tier}', [BusinessSubscriptionController::class, 'selectPlan'])
        ->name('subscription.plan.select');
    Route::post('/subscription/upgrade', [BusinessSubscriptionController::class, 'upgrade'])
        ->name('subscription.upgrade');
    Route::get('/subscription/upgrade/{plan}', [BusinessSubscriptionController::class, 'upgrade'])
        ->name('subscription.upgrade.plan');
    Route::post('/subscription/cancel', [BusinessSubscriptionController::class, 'cancel'])
        ->name('subscription.cancel');
    Route::post('/subscription/reactivate', [BusinessSubscriptionController::class, 'reactivate'])
        ->name('subscription.reactivate');
    Route::get('/subscription/invoice/{id}', [BusinessSubscriptionController::class, 'showInvoice'])
        ->name('subscription.invoice');
    Route::get('/subscription/invoice/{id}/download', [BusinessSubscriptionController::class, 'downloadInvoice'])
        ->name('subscription.invoice.download');

    // Marketing - Campaign Management
    Route::get('/marketing', [BusinessMarketingController::class, 'index'])->name('marketing.index');
    Route::get('/marketing/campaigns', [BusinessMarketingController::class, 'campaigns'])->name('marketing.campaigns');
    Route::get('/marketing/campaigns/create', [BusinessMarketingController::class, 'create'])->name('marketing.campaigns.create');
    Route::post('/marketing/campaigns', [BusinessMarketingController::class, 'store'])->name('marketing.campaigns.store');
    Route::get('/marketing/campaigns/{id}/edit', [BusinessMarketingController::class, 'edit'])->name('marketing.campaigns.edit');
    Route::put('/marketing/campaigns/{id}', [BusinessMarketingController::class, 'update'])->name('marketing.campaigns.update');
    Route::delete('/marketing/campaigns/{id}', [BusinessMarketingController::class, 'destroy'])->name('marketing.campaigns.destroy');
    Route::get('/marketing/create/{packageId}', [BusinessMarketingController::class, 'createCampaign'])->name('marketing.campaign.create');
    Route::post('/marketing/campaign', [BusinessMarketingController::class, 'storeCampaign'])->name('marketing.campaign.store');
    Route::get('/marketing/campaign/{id}/view', [BusinessMarketingController::class, 'viewCampaign'])->name('marketing.campaign.view');
    Route::get('/marketing/campaign/{id}/analytics', [BusinessMarketingController::class, 'campaignAnalytics'])->name('marketing.campaign.analytics');
    Route::post('/marketing/campaign/{id}/pause', [BusinessMarketingController::class, 'pauseCampaign'])->name('marketing.campaign.pause');
    Route::post('/marketing/campaign/{id}/resume', [BusinessMarketingController::class, 'resumeCampaign'])->name('marketing.campaign.resume');
    Route::delete('/marketing/campaign/{id}', [BusinessMarketingController::class, 'deleteCampaign'])->name('marketing.campaign.delete');
    Route::get('/marketing/campaign/{id}/export', [BusinessMarketingController::class, 'exportReport'])->name('marketing.campaign.export');

    // Notifications
    Route::get('/notifications', [BusinessNotificationController::class, 'index'])->name('notifications.index');
    Route::get('/notifications/preferences', [BusinessSettingsController::class, 'notificationPreferences'])->name('notifications.preferences');
    Route::post('/notifications/send', [BusinessNotificationController::class, 'send'])->name('notifications.send');
    Route::post('/notifications/{id}/mark-read', [BusinessNotificationController::class, 'markAsRead'])->name('notifications.mark-read');
    Route::post('/notifications/mark-all-read', [BusinessNotificationController::class, 'markAllAsRead'])->name('notifications.mark-all-read');
    Route::delete('/notifications/{id}', [BusinessNotificationController::class, 'destroy'])->name('notifications.destroy');

    // Verification & Resubmission
    Route::get('/verification/edit', [\App\Http\Controllers\Business\VerificationController::class, 'edit'])->name('verification.edit');
    Route::post('/verification/resubmit', [\App\Http\Controllers\Business\VerificationController::class, 'resubmit'])->name('verification.resubmit');
    Route::get('/verification/status', [\App\Http\Controllers\Business\VerificationController::class, 'status'])->name('verification.status');

    // Referral Program
    Route::get('/referral', [BusinessReferralController::class, 'index'])->name('referral.index');
    Route::get('/referral/stats', [BusinessReferralController::class, 'stats'])->name('referral.stats');

    // Support & Tickets
    Route::get('/support', [\App\Http\Controllers\Business\TicketController::class, 'index'])->name('support.index');
    Route::get('/support/tickets', [\App\Http\Controllers\Business\TicketController::class, 'index'])->name('support.tickets');
    Route::get('/support/tickets/create', [\App\Http\Controllers\Business\TicketController::class, 'create'])->name('support.create');
    Route::post('/support/tickets', [\App\Http\Controllers\Business\TicketController::class, 'store'])->name('support.tickets.store');
    Route::get('/support/tickets/{id}', [\App\Http\Controllers\Business\TicketController::class, 'show'])->name('support.tickets.show');
    Route::post('/support/tickets/{id}/reply', [\App\Http\Controllers\Business\TicketController::class, 'reply'])->name('support.tickets.reply');
    Route::post('/support/tickets/{id}/close', [\App\Http\Controllers\Business\TicketController::class, 'close'])->name('support.tickets.close');
    Route::post('/support/tickets/{id}/reopen', [\App\Http\Controllers\Business\TicketController::class, 'reopen'])->name('support.tickets.reopen');

    // Settings
    Route::get('/settings', [BusinessSettingsController::class, 'index'])->name('settings');
    Route::get('/settings/index', [BusinessSettingsController::class, 'index'])->name('settings.index');
    Route::post('/settings/update', [BusinessSettingsController::class, 'update'])->name('settings.update');
    Route::post('/settings/password', [BusinessSettingsController::class, 'updatePassword'])->name('settings.password');
    Route::post('/settings/change-password', [BusinessSettingsController::class, 'updatePassword'])->name('settings.change-password');
    Route::put('/settings/update-profile', [BusinessSettingsController::class, 'updateProfile'])->name('settings.update-profile');
    Route::put('/settings/update-account', [BusinessSettingsController::class, 'updateAccount'])->name('settings.update-account');
    Route::put('/settings/update-preferences', [BusinessSettingsController::class, 'updatePreferences'])->name('settings.update-preferences');
    Route::put('/settings/update-notifications', [BusinessSettingsController::class, 'updateNotifications'])->name('settings.update-notifications');

    // Additional Notification Routes
    Route::post('/notifications/preferences', [BusinessNotificationController::class, 'updatePreferences'])->name('notifications.preferences');


    // Additional Redemption Routes
    Route::get('/redemptions/manual', [BusinessRedemptionController::class, 'manual'])->name('redemptions.manual');

    // Additional Subscription Routes
    Route::post('/subscription/update-payment', [BusinessSubscriptionController::class, 'updatePayment'])->name('subscription.update-payment');

    // Profile Route
    Route::get('/profile', function () {
        return redirect()->route('business.settings');
    })->name('profile');

    // Team Role Management
    Route::post('/team/roles', [TeamController::class, 'storeRole'])->name('roles.store');

    // Alias routes for staff (business.staff.*)
    Route::resource('staff', BusinessStaffController::class)->only(['index', 'create', 'store', 'edit', 'update', 'destroy']);

    // Notification routes
    Route::prefix('notifications')->name('notifications.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Business\NotificationController::class, 'index'])->name('index');
        Route::post('{id}/read', [\App\Http\Controllers\Business\NotificationController::class, 'markAsRead'])->name('mark-read');
        Route::post('mark-all-read', [\App\Http\Controllers\Business\NotificationController::class, 'markAllAsRead'])->name('mark-all-read');
        Route::delete('{id}', [\App\Http\Controllers\Business\NotificationController::class, 'destroy'])->name('destroy');
    });

    // Chat routes
    Route::prefix('chats')->name('chats.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Business\ChatController::class, 'index'])->name('index');
        Route::get('/create', [\App\Http\Controllers\Business\ChatController::class, 'create'])->name('create');
        Route::post('/', [\App\Http\Controllers\Business\ChatController::class, 'store'])->name('store');
        Route::get('/{chat}', [\App\Http\Controllers\Business\ChatController::class, 'show'])->name('show');
        Route::post('/{chat}/message', [\App\Http\Controllers\Business\ChatController::class, 'sendMessage'])->name('send-message');
        Route::post('/{chat}/read', [\App\Http\Controllers\Business\ChatController::class, 'markAsRead'])->name('mark-read');
        Route::delete('/{chat}', [\App\Http\Controllers\Business\ChatController::class, 'destroy'])->name('destroy');
    });

    // Alias routes for staff (business.staff.*)
    Route::get('/staff', [BusinessStaffController::class, 'index'])->name('staff.index');
    Route::get('/staff/create', [BusinessStaffController::class, 'create'])->name('staff.create');
    Route::post('/staff', [BusinessStaffController::class, 'store'])->name('staff.store');
    Route::get('/staff/{id}', [BusinessStaffController::class, 'show'])->name('staff.show');
    Route::get('/staff/{id}/edit', [BusinessStaffController::class, 'edit'])->name('staff.edit');
    Route::put('/staff/{id}', [BusinessStaffController::class, 'update'])->name('staff.update');
    Route::delete('/staff/{id}', [BusinessStaffController::class, 'destroy'])->name('staff.destroy');
});

// Admin Authentication Routes (Public)
Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('/login', [AdminAuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [AdminAuthController::class, 'login'])->name('login.submit');
    Route::post('/logout', [AdminAuthController::class, 'logout'])->name('logout');
});

// Admin Panel Routes (Protected)
Route::prefix('admin')->name('admin.')->middleware(['auth', 'track.admin.activity'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');
    Route::get('/analytics', [AdminDashboardController::class, 'analytics'])->name('analytics');

    // Admin Notifications
    Route::prefix('notifications')->name('notifications.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'index'])->name('index');
        Route::post('{id}/read', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'markAsRead'])->name('mark-read');
        Route::post('mark-all-read', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'markAllAsRead'])->name('mark-all-read');
        Route::delete('{id}', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'destroy'])->name('destroy');
        Route::get('count', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'getCount'])->name('count');
    });

    // User Management
    Route::get('/users', [AdminUserController::class, 'index'])->name('users.index');
    Route::get('/users/activity', [AdminUserController::class, 'activity'])->name('users.activity');
    Route::post('/users', [AdminUserController::class, 'store'])->name('users.store');
    Route::get('/users/{id}', [AdminUserController::class, 'show'])->name('users.show');
    Route::get('/users/{id}/edit', [AdminUserController::class, 'edit'])->name('users.edit');
    Route::put('/users/{id}', [AdminUserController::class, 'update'])->name('users.update');
    Route::delete('/users/{id}', [AdminUserController::class, 'destroy'])->name('users.destroy');
    Route::post('/users/export', [AdminUserController::class, 'export'])->name('users.export');

    // Business Management
    Route::get('/businesses', [AdminBusinessController::class, 'index'])->name('businesses.index');
    Route::get('/businesses/{id}', [AdminBusinessController::class, 'show'])->name('businesses.show');
    Route::get('/businesses/{id}/verify', [AdminBusinessController::class, 'showVerify'])->name('businesses.verify');
    Route::post('/businesses/{id}/verify', [AdminBusinessController::class, 'verify'])->name('businesses.verify.submit');
    Route::post('/businesses/{id}/approve', [AdminBusinessController::class, 'approve'])->name('businesses.approve');
    Route::post('/businesses/{id}/auto-approve', [AdminBusinessController::class, 'autoApproveResubmitted'])->name('businesses.auto-approve');
    Route::post('/businesses/{id}/reject', [AdminBusinessController::class, 'reject'])->name('businesses.reject');
    Route::post('/businesses/{id}/suspend', [AdminBusinessController::class, 'suspend'])->name('businesses.suspend');
    Route::post('/businesses/{id}/activate', [AdminBusinessController::class, 'activate'])->name('businesses.activate');
    Route::post('/businesses/{id}/assign-subscription', [AdminBusinessController::class, 'assignSubscription'])->name('businesses.assign-subscription');
    Route::delete('/businesses/{id}', [AdminBusinessController::class, 'destroy'])->name('businesses.destroy');
    Route::post('/businesses/export', [AdminBusinessController::class, 'export'])->name('businesses.export');
//    create_for_user
    Route::get('/businesses/create-for-user/{id}', [AdminBusinessController::class, 'createForUser'])->name('businesses.create-for-user');
    Route::post('/businesses/create-for-user/{id}', [AdminBusinessController::class, 'storeForUser'])->name('businesses.store-for-user');

    // Category Management
    Route::get('/categories', [AdminCategoryController::class, 'index'])->name('categories.index');
    Route::get('/categories/create', [AdminCategoryController::class, 'create'])->name('categories.create');
    Route::post('/categories', [AdminCategoryController::class, 'store'])->name('categories.store');
    Route::get('/categories/{id}', [AdminCategoryController::class, 'show'])->name('categories.show');
    Route::get('/categories/{id}/edit', [AdminCategoryController::class, 'edit'])->name('categories.edit');
    Route::put('/categories/{id}', [AdminCategoryController::class, 'update'])->name('categories.update');
    Route::delete('/categories/{id}', [AdminCategoryController::class, 'destroy'])->name('categories.destroy');
    Route::post('/categories/{id}/toggle', [AdminCategoryController::class, 'toggle'])->name('categories.toggle');

    // Spotlight Management
    Route::get('/spotlight', [AdminSpotlightController::class, 'index'])->name('spotlight.index');
    Route::get('/spotlight/create', [AdminSpotlightController::class, 'create'])->name('spotlight.create');
    Route::post('/spotlight', [AdminSpotlightController::class, 'store'])->name('spotlight.store');
    Route::get('/spotlight/{id}', [AdminSpotlightController::class, 'show'])->name('spotlight.show');
    Route::get('/spotlight/{id}/edit', [AdminSpotlightController::class, 'edit'])->name('spotlight.edit');
    Route::put('/spotlight/{id}', [AdminSpotlightController::class, 'update'])->name('spotlight.update');
    Route::post('/spotlight/{id}/approve', [AdminSpotlightController::class, 'approve'])->name('spotlight.approve');
    Route::post('/spotlight/{id}/reject', [AdminSpotlightController::class, 'reject'])->name('spotlight.reject');
    Route::delete('/spotlight/{id}', [AdminSpotlightController::class, 'destroy'])->name('spotlight.destroy');
    Route::get('/spotlight/offer/{offerId}', [AdminSpotlightController::class, 'forOffer'])->name('spotlight.forOffer');

    // Subscription Plans (Business & User Plans)
    Route::get('/subscription-plans', [AdminSubscriptionPlanController::class, 'index'])->name('subscription-plans.index');
    Route::get('/subscription-plans/create', [AdminSubscriptionPlanController::class, 'create'])->name('subscription-plans.create');
    Route::post('/subscription-plans', [AdminSubscriptionPlanController::class, 'store'])->name('subscription-plans.store');
    Route::get('/subscription-plans/{id}', [AdminSubscriptionPlanController::class, 'show'])->name('subscription-plans.show');
    Route::get('/subscription-plans/{id}/edit', [AdminSubscriptionPlanController::class, 'edit'])->name('subscription-plans.edit');
    Route::put('/subscription-plans/{id}', [AdminSubscriptionPlanController::class, 'update'])->name('subscription-plans.update');
    Route::delete('/subscription-plans/{id}', [AdminSubscriptionPlanController::class, 'destroy'])->name('subscription-plans.destroy');
    Route::post('/subscription-plans/{id}/toggle', [AdminSubscriptionPlanController::class, 'toggle'])->name('subscription-plans.toggle');
    Route::post('/subscription-plans/{id}/toggle-popular', [AdminSubscriptionPlanController::class, 'togglePopular'])->name('subscription-plans.toggle-popular');

    // User Subscriptions Management
    Route::get('/user-subscriptions', [\App\Http\Controllers\Admin\UserSubscriptionController::class, 'index'])->name('user-subscriptions.index');
    Route::get('/user-subscriptions/{id}', [\App\Http\Controllers\Admin\UserSubscriptionController::class, 'show'])->name('user-subscriptions.show');
    Route::post('/user-subscriptions/{id}/cancel', [\App\Http\Controllers\Admin\UserSubscriptionController::class, 'cancel'])->name('user-subscriptions.cancel');
    Route::post('/user-subscriptions/{id}/activate', [\App\Http\Controllers\Admin\UserSubscriptionController::class, 'activate'])->name('user-subscriptions.activate');
    Route::get('/user-subscriptions/analytics', [\App\Http\Controllers\Admin\UserSubscriptionController::class, 'analytics'])->name('user-subscriptions.analytics');
    Route::get('/subscription-plans/{id}/subscribers', [AdminSubscriptionPlanController::class, 'subscribers'])->name('subscription-plans.subscribers');

    // Venue Management
    Route::get('/venues', [AdminVenueController::class, 'index'])->name('venues.index');
    Route::get('/venues/export', [AdminVenueController::class, 'export'])->name('venues.export');
    Route::get('/venues/{id}', [AdminVenueController::class, 'show'])->name('venues.show');
    Route::get('/venues/{id}/edit', [AdminVenueController::class, 'edit'])->name('venues.edit');
    Route::get('/venues/{id}/reject-form', [\App\Http\Controllers\Admin\VenueRejectionController::class, 'showRejectForm'])->name('venues.reject-form');
    Route::put('/venues/{id}', [AdminVenueController::class, 'update'])->name('venues.update');
    Route::post('/venues/{id}/approve', [AdminVenueController::class, 'approve'])->name('venues.approve');
    Route::post('/venues/{id}/reject', [\App\Http\Controllers\Admin\VenueRejectionController::class, 'reject'])->name('venues.reject');
    Route::post('/venues/{id}/toggle-status', [AdminVenueController::class, 'toggleStatus'])->name('venues.toggle-status');
    Route::post('/venues/{id}/toggle-featured', [AdminVenueController::class, 'toggleFeatured'])->name('venues.toggle-featured');
    Route::post('/venues/{id}/update-status', [AdminVenueController::class, 'updateStatus'])->name('venues.update-status');
    Route::delete('/venues/{id}', [AdminVenueController::class, 'destroy'])->name('venues.destroy');
    Route::get('/venues/{id}/create', [AdminVenueController::class, 'create'])->name('venues.create-for-business');
    Route::post('/venues/{id}/create', [AdminVenueController::class, 'store'])->name('venues.store-for-business');


    // Offer Management
    Route::get('/offers', [AdminOfferController::class, 'index'])->name('offers.index');
    Route::get('/offers/{id}', [AdminOfferController::class, 'show'])->name('offers.show');
    Route::get('/offers/{id}/edit', [AdminOfferController::class, 'edit'])->name('offers.edit');
    Route::put('/offers/{id}', [AdminOfferController::class, 'update'])->name('offers.update');
    Route::post('/offers/{id}/approve', [AdminOfferController::class, 'approve'])->name('offers.approve');
    Route::post('/offers/{id}/reject', [AdminOfferController::class, 'reject'])->name('offers.reject');
    Route::post('/offers/{id}/pause', [AdminOfferController::class, 'pause'])->name('offers.pause');
    Route::post('/offers/{id}/suspend', [AdminOfferController::class, 'suspend'])->name('offers.suspend');
    Route::post('/offers/{id}/activate', [AdminOfferController::class, 'activate'])->name('offers.activate');
    Route::delete('/offers/{id}', [AdminOfferController::class, 'destroy'])->name('offers.destroy');
    Route::get('/offers/{id}/create', [AdminOfferController::class, 'create'])->name('offers.create-for-business');
    Route::post('/offers/{id}/create', [AdminOfferController::class, 'store'])->name('offers.store-for-business');

    // Audit Logs
    Route::get('/audit-logs', [AdminAuditController::class, 'index'])->name('audit-logs.index');
    Route::get('/audit-logs/{id}', [AdminAuditController::class, 'show'])->name('audit-logs.show');
    Route::post('/audit-logs/export', [AdminAuditController::class, 'export'])->name('audit-logs.export');

    // System Configuration
    Route::get('/configuration', [AdminConfigurationController::class, 'index'])->name('configuration.index');
    Route::post('/configuration/update', [AdminConfigurationController::class, 'update'])->name('configuration.update');
    Route::post('/configuration/bulk-update', [AdminConfigurationController::class, 'bulkUpdate'])->name('configuration.bulk-update');

    // FAQ Management
    Route::get('/faqs', [AdminFaqController::class, 'index'])->name('faqs.index');
    Route::post('/faqs', [AdminFaqController::class, 'store'])->name('faqs.store');
    Route::put('/faqs/{id}', [AdminFaqController::class, 'update'])->name('faqs.update');
    Route::delete('/faqs/{id}', [AdminFaqController::class, 'destroy'])->name('faqs.destroy');
    Route::post('/faqs/{id}/toggle', [AdminFaqController::class, 'toggle'])->name('faqs.toggle');

    // GDPR Management
    Route::get('/gdpr', [AdminGdprController::class, 'index'])->name('gdpr.index');
    Route::get('/gdpr/{id}', [AdminGdprController::class, 'show'])->name('gdpr.show');
    Route::post('/gdpr/{id}/approve', [AdminGdprController::class, 'approve'])->name('gdpr.approve');
    Route::post('/gdpr/{id}/reject', [AdminGdprController::class, 'reject'])->name('gdpr.reject');
    Route::post('/gdpr/{id}/complete', [AdminGdprController::class, 'complete'])->name('gdpr.complete');

    // Marketing Management
    Route::get('/marketing', [AdminMarketingController::class, 'index'])->name('marketing.index');
    Route::get('/marketing/campaigns', [AdminMarketingController::class, 'campaigns'])->name('marketing.campaigns');
    Route::get('/marketing/campaigns/create', [AdminMarketingController::class, 'createCampaign'])->name('marketing.campaigns.create');
    Route::post('/marketing/campaigns', [AdminMarketingController::class, 'storeCampaign'])->name('marketing.campaigns.store');
    Route::get('/marketing/campaigns/{id}', [AdminMarketingController::class, 'viewCampaign'])->name('marketing.campaigns.show');
    Route::get('/marketing/campaigns/{id}/view', [AdminMarketingController::class, 'viewCampaign'])->name('marketing.campaigns.view');
    Route::get('/marketing/campaigns/{id}/edit', [AdminMarketingController::class, 'editCampaign'])->name('marketing.campaigns.edit');
    Route::put('/marketing/campaigns/{id}', [AdminMarketingController::class, 'updateCampaign'])->name('marketing.campaigns.update');
    Route::post('/marketing/campaigns/{id}/approve', [AdminMarketingController::class, 'approveCampaign'])->name('marketing.campaigns.approve');
    Route::post('/marketing/campaigns/{id}/reject', [AdminMarketingController::class, 'rejectCampaign'])->name('marketing.campaigns.reject');
    Route::post('/marketing/campaigns/{id}/deactivate', [AdminMarketingController::class, 'deactivateCampaign'])->name('marketing.campaigns.deactivate');
    Route::delete('/marketing/campaigns/{id}', [AdminMarketingController::class, 'deleteCampaign'])->name('marketing.campaigns.delete');
    Route::get('/marketing/analytics', [AdminMarketingController::class, 'analytics'])->name('marketing.analytics');

    // Activities Management
    Route::get('/activities', [\App\Http\Controllers\Admin\ActivityController::class, 'index'])->name('activities.index');
    Route::get('/activities/{id}', [\App\Http\Controllers\Admin\ActivityController::class, 'show'])->name('activities.show');
    Route::delete('/activities/{id}', [\App\Http\Controllers\Admin\ActivityController::class, 'destroy'])->name('activities.destroy');
    Route::post('/activities/clear', [\App\Http\Controllers\Admin\ActivityController::class, 'clear'])->name('activities.clear');

    // Roles Management
    Route::get('/roles', [\App\Http\Controllers\Admin\RoleController::class, 'index'])->name('roles.index');
    Route::get('/roles/create', [\App\Http\Controllers\Admin\RoleController::class, 'create'])->name('roles.create');
    Route::post('/roles', [\App\Http\Controllers\Admin\RoleController::class, 'store'])->name('roles.store');
    Route::get('/roles/{id}', [\App\Http\Controllers\Admin\RoleController::class, 'show'])->name('roles.show');
    Route::get('/roles/{id}/edit', [\App\Http\Controllers\Admin\RoleController::class, 'edit'])->name('roles.edit');
    Route::put('/roles/{id}', [\App\Http\Controllers\Admin\RoleController::class, 'update'])->name('roles.update');
    Route::delete('/roles/{id}', [\App\Http\Controllers\Admin\RoleController::class, 'destroy'])->name('roles.destroy');
    Route::get('/roles/{id}/permissions', [\App\Http\Controllers\Admin\RoleController::class, 'managePermissions'])->name('roles.permissions');
    Route::get('/roles/{id}/users', [\App\Http\Controllers\Admin\RoleController::class, 'users'])->name('roles.users');

    // Permissions Management
    Route::get('/permissions', [\App\Http\Controllers\Admin\PermissionController::class, 'index'])->name('permissions.index');
    Route::get('/permissions/create', [\App\Http\Controllers\Admin\PermissionController::class, 'create'])->name('permissions.create');
    Route::post('/permissions', [\App\Http\Controllers\Admin\PermissionController::class, 'store'])->name('permissions.store');
    Route::get('/permissions/{id}', [\App\Http\Controllers\Admin\PermissionController::class, 'show'])->name('permissions.show');
    Route::get('/permissions/{id}/edit', [\App\Http\Controllers\Admin\PermissionController::class, 'edit'])->name('permissions.edit');
    Route::put('/permissions/{id}', [\App\Http\Controllers\Admin\PermissionController::class, 'update'])->name('permissions.update');
    Route::delete('/permissions/{id}', [\App\Http\Controllers\Admin\PermissionController::class, 'destroy'])->name('permissions.destroy');

    // Reviews Management
    Route::get('/reviews', function () {
        $reviews = \App\Models\Review::with(['user', 'venue'])->latest()->paginate(20);
        return view('admin.reviews.index', compact('reviews'));
    })->name('reviews.index');

    // Payments Management
    Route::get('/payments', function () {
        $payments = \App\Models\Payment::with(['business'])->latest()->paginate(20);
        return view('admin.payments.index', compact('payments'));
    })->name('payments.index');
    Route::get('/payments/{id}', function ($id) {
        $payment = \App\Models\Payment::with(['business', 'subscription.plan'])->findOrFail($id);
        return response()->json([
            'success' => true,
            'payment' => $payment
        ]);
    })->name('payments.show');

    // Subscriptions Management
    Route::get('/subscriptions', function () {
        $subscriptions = \App\Models\Subscription::with(['business', 'plan'])->latest()->paginate(20);
        return view('admin.subscriptions.index', compact('subscriptions'));
    })->name('subscriptions.index');
    Route::get('/subscriptions/{id}', function ($id) {
        $subscription = \App\Models\Subscription::with(['business', 'plan'])->findOrFail($id);
        return response()->json([
            'success' => true,
            'subscription' => $subscription
        ]);
    })->name('subscriptions.show');

    Route::prefix('tickets')->group(function () {

        Route::get('/', [\App\Http\Controllers\Admin\SupportController::class, 'index'])
            ->name('tickets.index');

        Route::get('/{id}', [\App\Http\Controllers\Admin\SupportController::class, 'show'])
            ->name('tickets.show');

        Route::post('/{id}/close', [\App\Http\Controllers\Admin\SupportController::class, 'close'])
            ->name('tickets.close');

        Route::post('/{id}/reopen', [\App\Http\Controllers\Admin\SupportController::class, 'reopen'])
            ->name('tickets.reopen');

        Route::post('/{id}/reply', [\App\Http\Controllers\Admin\SupportController::class, 'reply'])
            ->name('tickets.reply');

        Route::patch('/{id}/update-status', [\App\Http\Controllers\Admin\SupportController::class, 'updateStatus'])
            ->name('tickets.update-status');

        Route::post('/{id}/assign', [\App\Http\Controllers\Admin\SupportController::class, 'assign'])
            ->name('tickets.assign');

        Route::delete('/{id}', [\App\Http\Controllers\Admin\SupportController::class, 'destroy'])
            ->name('tickets.destroy');
    });
    // Moderation Dashboard
    Route::get('/moderation', function () {
        $pendingSpotlights = \App\Models\Spotlight::where('moderation_status', 'pending')->count();
        $flaggedContent = \App\Models\Spotlight::where('status', 'flagged')->count();
        $pendingReviews = \App\Models\Review::where('status', 'pending')->count();
        return view('admin.moderation.index', compact('pendingSpotlights', 'flaggedContent', 'pendingReviews'));
    })->name('moderation.index');

    // Reports & Analytics
    Route::get('/reports', function () {
        return view('admin.reports.index');
    })->name('reports.index');

    // Notifications Management
    Route::get('/notifications', function () {
        $notifications = auth()->user()->notifications()->paginate(20);
        return view('admin.notifications.index', compact('notifications'));
    })->name('notifications.index');

    // Alias for spotlight (singular)
    Route::get('/spotlight', [AdminSpotlightController::class, 'index'])->name('spotlight.index');

    // Settings
    Route::get('/settings', [AdminSettingsController::class, 'index'])->name('settings.index');
    Route::post('/settings/update/{section}', [AdminSettingsController::class, 'update'])->name('settings.update');
    Route::post('/settings/maintenance', [AdminSettingsController::class, 'maintenance'])->name('settings.maintenance');
    Route::post('/settings/test-email', [AdminSettingsController::class, 'testEmail'])->name('settings.test-email');
    Route::post('/settings/test-sms', [AdminSettingsController::class, 'testSMS'])->name('settings.test-sms');

    // Profile Management
    Route::get('/profile/edit', [\App\Http\Controllers\Admin\ProfileController::class, 'edit'])->name('profile.edit');
    Route::put('/profile', [\App\Http\Controllers\Admin\ProfileController::class, 'update'])->name('profile.update');

    // ...existing code...

    // Sessions Management
    Route::get('/sessions', [\App\Http\Controllers\Admin\SessionController::class, 'index'])->name('sessions.index');
    Route::get('/sessions/{id}', [\App\Http\Controllers\Admin\SessionController::class, 'show'])->name('sessions.show');
    Route::post('/sessions/{id}/terminate', [\App\Http\Controllers\Admin\SessionController::class, 'terminate'])->name('sessions.terminate');
    Route::post('/sessions/terminate-all', [\App\Http\Controllers\Admin\SessionController::class, 'terminateAll'])->name('sessions.terminate-all');

    // System Configuration
    Route::get('/faqs', [AdminFaqController::class, 'index'])->name('faqs.index');
    Route::get('/teams', [AdminTeamController::class, 'index'])->name('teams.index');
    Route::get('/teams/create', [AdminTeamController::class, 'create'])->name('teams.create');
    Route::post('/teams', [AdminTeamController::class, 'store'])->name('teams.store');
    Route::get('/teams/{id}', [AdminTeamController::class, 'show'])->name('teams.show');
    Route::get('/teams/{id}/edit', [AdminTeamController::class, 'edit'])->name('teams.edit');
    Route::put('/teams/{id}', [AdminTeamController::class, 'update'])->name('teams.update');
    Route::delete('/teams/{id}', [AdminTeamController::class, 'destroy'])->name('teams.destroy');
    Route::post('/teams/{id}/add-member', [AdminTeamController::class, 'addMember'])->name('teams.add-member');
    Route::post('/teams/{id}/remove-member', [AdminTeamController::class, 'removeMember'])->name('teams.remove-member');
    Route::post('/teams/{id}/update-role', [AdminTeamController::class, 'updateRole'])->name('teams.update-role');

    // Staff Management (Admin)
    Route::get('/staff', [\App\Http\Controllers\Admin\StaffController::class, 'index'])->name('staff.index');
    Route::get('/staff/{staff}', [\App\Http\Controllers\Admin\StaffController::class, 'show'])->name('staff.show');
    Route::post('/staff', [\App\Http\Controllers\Admin\StaffController::class, 'store'])->name('staff.store');
    Route::get('/staff/{staff}/edit', [\App\Http\Controllers\Admin\StaffController::class, 'edit'])->name('staff.edit');
    Route::put('/staff/{staff}', [\App\Http\Controllers\Admin\StaffController::class, 'update'])->name('staff.update');
    Route::delete('/staff/{staff}', [\App\Http\Controllers\Admin\StaffController::class, 'destroy'])->name('staff.destroy');

    // Chats Management (Admin)
    Route::get('/chats', [\App\Http\Controllers\Admin\ChatController::class, 'index'])->name('chats.index');
    Route::get('/chats/{chat}', [\App\Http\Controllers\Admin\ChatController::class, 'show'])->name('chats.show');
    Route::post('/chats', [\App\Http\Controllers\Admin\ChatController::class, 'store'])->name('chats.store');
    Route::post('/chats/{chat}/messages', [\App\Http\Controllers\Admin\ChatController::class, 'postMessage'])->name('chats.post-message');
    Route::get('/chats/{chat}/messages', [\App\Http\Controllers\Admin\ChatController::class, 'getMessages'])->name('chats.get-messages');
    Route::post('/chats/{chat}/read', [\App\Http\Controllers\Admin\ChatController::class, 'markAsRead'])->name('chats.mark-read');
    Route::post('/chats/{chat}/disable', [\App\Http\Controllers\Admin\ChatController::class, 'disable'])->name('chats.disable');
    Route::post('/chats/{chat}/enable', [\App\Http\Controllers\Admin\ChatController::class, 'enable'])->name('chats.enable');
    Route::delete('/chats/{chat}', [\App\Http\Controllers\Admin\ChatController::class, 'destroy'])->name('chats.destroy');

    Route::prefix('activities')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\AdminActivityController::class, 'index']);
        Route::get('{id}', [\App\Http\Controllers\Admin\AdminActivityController::class, 'show']);
        Route::post('export', [\App\Http\Controllers\Admin\AdminActivityController::class, 'export']);
    });
    // Notification Templates (Admin)
    Route::prefix('notifications')->name('notifications.')->group(function () {
        // Email Templates
        Route::get('email-templates', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailIndex'])->name('email-templates.index');
        Route::get('email-templates/create', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailCreate'])->name('email-templates.create');
        Route::post('email-templates', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailStore'])->name('email-templates.store');
        Route::get('email-templates/{id}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailShow'])->name('email-templates.show');
        Route::get('email-templates/{id}/edit', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailEdit'])->name('email-templates.edit');
        Route::put('email-templates/{id}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailUpdate'])->name('email-templates.update');
        Route::delete('email-templates/{id}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailDestroy'])->name('email-templates.destroy');
        Route::post('email-templates/{id}/preview', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'emailPreview'])->name('email-templates.preview');

        // SMS Templates
        Route::get('sms-templates', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsIndex'])->name('sms-templates.index');
        Route::get('sms-templates/create', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsCreate'])->name('sms-templates.create');
        Route::post('sms-templates', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsStore'])->name('sms-templates.store');
        Route::get('sms-templates/{id}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsShow'])->name('sms-templates.show');
        Route::get('sms-templates/{id}/edit', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsEdit'])->name('sms-templates.edit');
        Route::put('sms-templates/{id}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsUpdate'])->name('sms-templates.update');
        Route::delete('sms-templates/{id}', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsDestroy'])->name('sms-templates.destroy');
        Route::post('sms-templates/{id}/preview', [\App\Http\Controllers\Admin\NotificationTemplateController::class, 'smsPreview'])->name('sms-templates.preview');
    });
});

//include admin.php routes
require __DIR__.'/admin.php';

// include business admin routes (team management, staff management, etc.)
//require __DIR__.'/web-admin-business.php';

