<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Business Portal'); ?> - Privasee</title>
    <link rel="icon" type="image/svg+xml" href="<?php echo e(asset('favicon.svg')); ?>">
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>

    <style>
        :root {
            --sidebar-width: 260px;
            --header-height: 70px;
            --primary-color: #6366f1;
            --secondary-color: #8b5cf6;
            --success-color: #10b981;
            --danger-color: #ef4444;
            --warning-color: #f59e0b;
            --info-color: #3b82f6;
            --dark-color: #1f2937;
            --light-bg: #f9fafb;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background-color: var(--light-bg);
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: linear-gradient(180deg, #1f2937 0%, #111827 100%);
            color: white;
            z-index: 1000;
            overflow-y: auto;
            transition: all 0.3s;
        }

        .sidebar-brand {
            padding: 1.5rem;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .sidebar-brand h4 {
            margin: 0;
            font-weight: 700;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .sidebar-nav {
            padding: 1rem 0;
        }

        .nav-item {
            margin: 0.25rem 0.75rem;
        }

        .nav-link {
            color: rgba(255,255,255,0.7);
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            transition: all 0.2s;
            text-decoration: none;
        }

        .nav-link:hover {
            background: rgba(255,255,255,0.1);
            color: white;
        }

        .nav-link.active {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            box-shadow: 0 4px 6px rgba(99, 102, 241, 0.3);
        }

        .nav-link i {
            font-size: 1.25rem;
            width: 24px;
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
        }

        /* Header */
        .top-header {
            background: white;
            height: var(--header-height);
            border-bottom: 1px solid #e5e7eb;
            display: flex;
            align-items: center;
            padding: 0 2rem;
            position: sticky;
            top: 0;
            z-index: 999;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        }

        .search-box {
            max-width: 400px;
            position: relative;
        }

        .search-box input {
            border-radius: 2rem;
            padding-left: 2.5rem;
            border: 1px solid #e5e7eb;
        }

        .search-box i {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #9ca3af;
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .notification-btn {
            position: relative;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            border: none;
            background: var(--light-bg);
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.2s;
        }

        .notification-btn:hover {
            background: #e5e7eb;
        }

        .notification-badge {
            position: absolute;
            top: -4px;
            right: -4px;
            width: 18px;
            height: 18px;
            background: var(--danger-color);
            border-radius: 50%;
            font-size: 0.65rem;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
        }

        /* Content Area */
        .content-area {
            padding: 2rem;
        }

        /* Cards */
        .stat-card {
            background: white;
            border-radius: 1rem;
            padding: 1.5rem;
            border: 1px solid #e5e7eb;
            transition: all 0.3s;
            height: 100%;
        }

        .stat-card:hover {
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }

        .stat-icon {
            width: 56px;
            height: 56px;
            border-radius: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }

        .stat-value {
            font-size: 2rem;
            font-weight: 700;
            color: var(--dark-color);
            margin: 0.5rem 0;
        }

        .stat-label {
            color: #6b7280;
            font-size: 0.875rem;
            font-weight: 500;
        }

        .stat-change {
            display: inline-flex;
            align-items: center;
            gap: 0.25rem;
            padding: 0.25rem 0.5rem;
            border-radius: 0.375rem;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .stat-change.positive {
            background: #d1fae5;
            color: #065f46;
        }

        .stat-change.negative {
            background: #fee2e2;
            color: #991b1b;
        }

        /* Buttons */
        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            border: none;
            border-radius: 0.5rem;
            padding: 0.625rem 1.5rem;
            font-weight: 600;
            transition: all 0.2s;
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 10px 20px rgba(99, 102, 241, 0.3);
        }

        /* Tables */
        .table-card {
            background: white;
            border-radius: 1rem;
            overflow: hidden;
            border: 1px solid #e5e7eb;
        }

        .table-card .card-header {
            padding: 1.5rem;
            border-bottom: 1px solid #e5e7eb;
            background: white;
        }

        .table thead th {
            background: var(--light-bg);
            border: none;
            color: #6b7280;
            font-weight: 600;
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            padding: 1rem;
        }

        .table tbody td {
            padding: 1rem;
            vertical-align: middle;
            border-color: #f3f4f6;
        }

        /* Badges */
        .badge {
            padding: 0.375rem 0.75rem;
            font-weight: 600;
            border-radius: 0.375rem;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            .sidebar.show {
                transform: translateX(0);
            }
            .main-content {
                margin-left: 0;
            }
        }

        /* Loading Overlay */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }

        .loading-spinner {
            width: 50px;
            height: 50px;
            border: 4px solid rgba(255,255,255,0.3);
            border-top-color: white;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        .card-body{
            padding: 24px;
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
<!-- Sidebar -->
<div class="sidebar">
    <div class="sidebar-brand">
        <a href="<?php echo e(route('business.dashboard')); ?>">
            <img src="<?php echo e(asset('logo/Privasee-logo-white-business.svg')); ?>" alt="Privasee" style="height:60px;">
        </a>
    </div>

    <nav class="sidebar-nav">
        
        <div class="nav-item">
            <a href="<?php echo e(route('business.dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('business.dashboard') ? 'active' : ''); ?>">
                <i class="bi bi-speedometer2"></i>
                <span>Dashboard</span>
            </a>
        </div>

        
        <?php if(auth()->user()->isBusinessOwner() || auth()->user()->hasTeamPermission('manage_venues')): ?>
        <div class="nav-item">
            <a href="<?php echo e(route('business.venues.index')); ?>" class="nav-link <?php echo e(request()->routeIs('business.venues.*') ? 'active' : ''); ?>">
                <i class="bi bi-geo-alt"></i>
                <span>Venues</span>
            </a>
        </div>
        <?php endif; ?>

        
        <?php if(auth()->user()->isBusinessOwner() || auth()->user()->hasTeamPermission('manage_offers')): ?>
        <div class="nav-item">
            <a href="<?php echo e(route('business.offers.index')); ?>" class="nav-link <?php echo e(request()->routeIs('business.offers.*') ? 'active' : ''); ?>">
                <i class="bi bi-tag"></i>
                <span>Offers</span>
            </a>
        </div>
        <?php endif; ?>

        
        <?php if(auth()->user()->isBusinessOwner()): ?>
        <div class="nav-item">
            <a href="<?php echo e(route('business.teams.index')); ?>" class="nav-link <?php echo e(request()->routeIs('business.teams.*') ? 'active' : ''); ?>">
                <i class="bi bi-people"></i>
                <span>Team</span>
            </a>
        </div>
        <?php endif; ?>

        
        <?php if(auth()->user()->isBusinessOwner() || auth()->user()->hasTeamPermission('manage_staff')): ?>
        <div class="nav-item">
            <a href="<?php echo e(route('business.staff.index')); ?>" class="nav-link <?php echo e(request()->routeIs('business.staff.*') ? 'active' : ''); ?>">
                <i class="bi bi-briefcase"></i>
                <span>Staff</span>
            </a>
        </div>
        <?php endif; ?>

        
        <?php if(auth()->user()->isBusinessOwner() || auth()->user()->hasTeamPermission('view_analytics')): ?>
        <div class="nav-item">
            <a href="<?php echo e(route('business.analytics')); ?>" class="nav-link <?php echo e(request()->routeIs('business.analytics') ? 'active' : ''); ?>">
                <i class="bi bi-graph-up"></i>
                <span>Analytics</span>
            </a>
        </div>
        <?php endif; ?>

        
        <?php if(auth()->user()->isBusinessOwner() || auth()->user()->hasTeamPermission('manage_redemptions') || auth()->user()->hasTeamPermission('process_redemptions')): ?>
        <div class="nav-item">
            <a href="<?php echo e(route('business.redemptions')); ?>" class="nav-link <?php echo e(request()->routeIs('business.redemptions') ? 'active' : ''); ?>">
                <i class="bi bi-qr-code-scan"></i>
                <span>Redemptions</span>
            </a>
        </div>
        <?php endif; ?>

        
        <?php if(auth()->user()->isBusinessOwner()): ?>
        <div class="nav-item">
            <a href="<?php echo e(route('business.subscription.index')); ?>" class="nav-link <?php echo e(request()->routeIs('business.subscription*') ? 'active' : ''); ?>">
                <i class="bi bi-credit-card"></i>
                <span>Subscription</span>
            </a>
        </div>
        <?php endif; ?>

        
        <?php if(auth()->user()->isBusinessOwner() || auth()->user()->hasTeamPermission('manage_marketing')): ?>
        <div class="nav-item">
            <a href="<?php echo e(route('business.marketing.index')); ?>" class="nav-link <?php echo e(request()->routeIs('business.marketing.*') ? 'active' : ''); ?>">
                <i class="bi bi-megaphone"></i>
                <span>Marketing</span>
            </a>
        </div>
        <?php endif; ?>

        
        <?php if(auth()->user()->isBusinessOwner() || auth()->user()->hasTeamPermission('manage_referral')): ?>
        <div class="nav-item">
            <a href="<?php echo e(route('business.referral.index')); ?>" class="nav-link <?php echo e(request()->routeIs('business.referral.*') ? 'active' : ''); ?>">
                <i class="bi bi-gift"></i>
                <span>Referral</span>
            </a>
        </div>
        <?php endif; ?>


        
        <div class="nav-item">
            <a href="<?php echo e(route('business.support.index')); ?>" class="nav-link <?php echo e(request()->routeIs('business.support.*') ? 'active' : ''); ?>">
                <i class="bi bi-life-preserver"></i>
                <span>Support</span>
            </a>
        </div>

        
        <div class="nav-item">
            <a href="<?php echo e(route('business.notifications.index')); ?>" class="nav-link <?php echo e(request()->routeIs('business.notifications.*') ? 'active' : ''); ?>">
                <i class="bi bi-bell"></i>
                <span>Notifications</span>
                <?php $unreadCount = \App\Services\NotificationService::getUnreadNotifications(auth()->user())->count(); ?>
                <?php if($unreadCount > 0): ?>
                    <span class="badge bg-danger ms-2"><?php echo e($unreadCount); ?></span>
                <?php endif; ?>
            </a>
        </div>

        
        <div class="nav-item">
            <a href="<?php echo e(route('business.chats.index')); ?>" class="nav-link <?php echo e(request()->routeIs('business.chats.*') ? 'active' : ''); ?>">
                <i class="bi bi-chat-dots"></i>
                <span>Chat</span>
            </a>
        </div>

        <hr class="my-3 mx-3" style="border-color: rgba(255,255,255,0.1);">

        
        <div class="nav-item">
            <a href="<?php echo e(route('business.settings')); ?>" class="nav-link <?php echo e(request()->routeIs('business.settings') ? 'active' : ''); ?>">
                <i class="bi bi-gear"></i>
                <span>Settings</span>
            </a>
        </div>

        
        <div class="nav-item">
            <a href="<?php echo e(route('logout')); ?>" class="nav-link" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <i class="bi bi-box-arrow-right"></i>
                <span>Logout</span>
            </a>
            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                <?php echo csrf_field(); ?>
            </form>
        </div>
    </nav>
</div>

<!-- Main Content -->
<div class="main-content">
    <!-- Header -->

    <header class="top-header">
        <div class="d-flex align-items-center justify-content-between w-100">
            <div class="search-box">
                <i class="bi bi-search"></i>
                <input type="text" class="form-control" placeholder="Search...">
            </div>

            <div class="user-menu">
                <a href="<?php echo e(route('business.notifications.index')); ?>" class="notification-btn">
                    <i class="bi bi-bell"></i>
                    <?php if(auth()->user()->unreadNotifications->count() > 0): ?>
                        <span class="notification-badge"><?php echo e(auth()->user()->unreadNotifications->count()); ?></span>
                    <?php endif; ?>
                </a>

                <div class="dropdown">
                    <button class="btn btn-link text-decoration-none dropdown-toggle d-flex align-items-center gap-2" type="button" data-bs-toggle="dropdown">
                        <img src="https://ui-avatars.com/api/?name=<?php echo e(auth()->user()->full_name); ?>&background=6366f1&color=fff"
                             alt="Profile" class="rounded-circle" width="40" height="40">
                        <div class="text-start d-none d-md-block">
                            <div class="fw-semibold text-dark"><?php echo e(auth()->user()->full_name); ?></div>

                            <small class="text-muted"><?php echo e(auth()->user()->businesses->first()->business_name ?? 'Business Owner'); ?></small>
                        </div>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="<?php echo e(route('business.settings')); ?>"><i class="bi bi-person me-2"></i>Profile</a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('business.settings')); ?>"><i class="bi bi-gear me-2"></i>Settings</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item text-danger" href="<?php echo e(route('logout')); ?>"
                               onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                <i class="bi bi-box-arrow-right me-2"></i>Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </header>

    <!-- Page Content -->
    <div class="content-area">
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="bi bi-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>
    </div>
</div>

<!-- Loading Overlay -->
<div class="loading-overlay" id="loadingOverlay">
    <div class="loading-spinner"></div>
</div>

<!-- Bootstrap 5 JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    // Auto-hide alerts
    document.querySelectorAll('.alert').forEach(alert => {
        setTimeout(() => {
            alert.classList.remove('show');
            setTimeout(() => alert.remove(), 150);
        }, 5000);
    });

    // Loading overlay helper
    window.showLoading = () => document.getElementById('loadingOverlay').style.display = 'flex';
    window.hideLoading = () => document.getElementById('loadingOverlay').style.display = 'none';
</script>

<?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\laragon\www\privasee\resources\views/layouts/business.blade.php ENDPATH**/ ?>