<?php $__env->startSection('title', 'Business Staff'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <?php
        $subscription = $business->activeSubscription()->with('plan')->first();
        $maxStaff = $subscription ? $subscription->plan->max_staff : 0;
        $currentStaff = $staff->where('status', 'active')->count();
        $canAddMore = $currentStaff < $maxStaff;
    ?>

    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">
                <a href="<?php echo e(route('business.show', $business)); ?>" class="text-decoration-none">
                    <?php echo e($business->business_name); ?>

                </a>
            </h1>
            <p class="text-muted">Staff Members</p>
        </div>
        <div class="col-md-4 text-end">
            <?php if($canAddMore): ?>
                <a href="<?php echo e(route('business.staff.create', $business)); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add Staff
                </a>
            <?php else: ?>
                <button class="btn btn-secondary" disabled title="Staff limit reached - upgrade plan">
                    <i class="fas fa-lock"></i> Limit Reached
                </button>
            <?php endif; ?>
        </div>
    </div>

    <!-- Plan Limit Warning -->
    <?php if($currentStaff >= $maxStaff * 0.8 && $canAddMore): ?>
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle"></i>
            <strong>Approaching Staff Limit</strong>
            You have <?php echo e($maxStaff - $currentStaff); ?> staff slot<?php echo e($maxStaff - $currentStaff !== 1 ? 's' : ''); ?> remaining.
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php elseif(!$canAddMore): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-circle"></i>
            <strong>Staff Limit Reached</strong>
            You've reached the maximum of <?php echo e($maxStaff); ?> staff members. <a href="<?php echo e(route('business.subscription.index')); ?>" class="alert-link">Upgrade your plan</a> to add more.
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Total Staff</h6>
                    <h3 class="mb-0"><?php echo e($staff->total()); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Active</h6>
                    <h3 class="mb-0"><?php echo e($currentStaff); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h6 class="text-muted mb-2">Pending</h6>
                    <h3 class="mb-0"><?php echo e($staff->where('status', 'pending_invitation')->count()); ?></h3>
                </div>
            </div>
        </div>
        <?php if($subscription): ?>
            <div class="col-md-3">
                <div class="card <?php if(!$canAddMore): ?> border-danger <?php elseif($currentStaff >= $maxStaff * 0.8): ?> border-warning <?php endif; ?>">
                    <div class="card-body">
                        <h6 class="text-muted mb-2">Plan Limit</h6>
                        <h3 class="mb-0 <?php if(!$canAddMore): ?> text-danger <?php elseif($currentStaff >= $maxStaff * 0.8): ?> text-warning <?php endif; ?>"><?php echo e($currentStaff); ?>/<?php echo e($maxStaff); ?></h3>
                        <small class="text-muted"><?php echo e($subscription->plan->name); ?></small>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control form-control-sm"
                        placeholder="Search by name or email" value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3">
                    <select name="role" class="form-select form-select-sm">
                        <option value="">All Roles</option>
                        <option value="owner" <?php echo e(request('role') === 'owner' ? 'selected' : ''); ?>>Owner</option>
                        <option value="manager" <?php echo e(request('role') === 'manager' ? 'selected' : ''); ?>>Manager</option>
                        <option value="staff" <?php echo e(request('role') === 'staff' ? 'selected' : ''); ?>>Staff</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select form-select-sm">
                        <option value="">All Status</option>
                        <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="pending_invitation" <?php echo e(request('status') === 'pending_invitation' ? 'selected' : ''); ?>>Pending</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary btn-sm w-100">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Staff Table -->
    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Role</th>
                        <th>Team</th>
                        <th>Permissions</th>
                        <th>Status</th>
                        <th>Joined</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <?php if($member->user): ?>
                                <strong><?php echo e($member->user->first_name); ?> <?php echo e($member->user->last_name); ?></strong>
                            <?php else: ?>
                                <span class="text-muted"><?php echo e($member->email ?? 'Pending'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($member->user): ?>
                                <?php echo e($member->user->email); ?>

                            <?php else: ?>
                                <span class="text-muted">Pending acceptance</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($member->user): ?>
                                <?php echo e($member->user->phone ?? '-'); ?>

                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-primary"><?php echo e(ucfirst($member->role)); ?></span>
                        </td>
                        <td>
                            <?php if($member->team): ?>
                                <span class="badge bg-secondary"><?php echo e($member->team->name); ?></span>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($member->permissions && is_array($member->permissions)): ?>
                                <?php
                                    $permissionIds = $member->permissions;
                                    $permissions = \App\Models\Permission::whereIn('id', $permissionIds)->get();
                                ?>
                                <?php if($permissions->count() > 0): ?>
                                    <div class="d-flex flex-wrap gap-1">
                                        <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge bg-info" title="<?php echo e($perm->description); ?>">
                                            <?php echo e($perm->name); ?>

                                        </span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($member->status === 'active' ? 'success' : 'warning'); ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $member->status))); ?>

                            </span>
                        </td>
                        <td>
                            <?php if($member->joined_at): ?>
                                <small><?php echo e($member->joined_at->format('M d, Y')); ?></small>
                            <?php else: ?>
                                <small class="text-muted">Pending</small>
                            <?php endif; ?>
                        </td>
                        <td>
                             <a href="<?php echo e(route('business.staff.edit', $member->id)); ?>" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="<?php echo e(route('business.staff.destroy', $member->id)); ?>" method="POST" style="display:inline;">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Remove this staff member?')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">
                            No staff members yet. <a href="<?php echo e(route('business.staff.create', $business)); ?>">Add one</a>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div>
            Showing <?php echo e($staff->firstItem() ?? 0); ?> to <?php echo e($staff->lastItem() ?? 0); ?> of <?php echo e($staff->total()); ?> staff members
        </div>
        <div>
            <?php echo e($staff->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/staff/index.blade.php ENDPATH**/ ?>