<?php $__env->startSection('title', 'User Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">User Details</h2>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.users.index')); ?>">Users</a></li>
                            <li class="breadcrumb-item active"><?php echo e($user->full_name); ?></li>
                        </ol>
                    </nav>
                </div>
                <div>
                    <a href="<?php echo e(route('admin.users.edit', $user->id)); ?>" class="btn btn-primary">
                        <i class="bi bi-pencil me-2"></i>Edit User
                    </a>
                </div>




                <?php if($user->account_type == 'business_owner' && !$user->business): ?>
                    <div class="ms-2">
                        <a href="<?php echo e(route('admin.businesses.create-for-user', $user->id)); ?>" class="btn btn-success">
                            <i class="bi bi-building me-2"></i>Create Business
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- User Info Card -->
        <div class="col-md-4 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <?php if($user->avatar): ?>
                            <img src="<?php echo e(Storage::url($user->avatar)); ?>" class="rounded-circle" width="120" height="120" alt="Avatar">
                        <?php else: ?>
                            <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 120px; height: 120px; font-size: 48px;">
                                <?php echo e(strtoupper(substr($user->first_name, 0, 1))); ?><?php echo e(strtoupper(substr($user->last_name, 0, 1))); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                    <h4 class="mb-1"><?php echo e($user->full_name); ?></h4>
                    <p class="text-muted mb-2"><?php echo e(ucfirst($user->role)); ?></p>
                    <span class="badge bg-<?php echo e($user->status === 'active' ? 'success' : 'danger'); ?>">
                        <?php echo e(ucfirst($user->status)); ?>

                    </span>
                </div>
                <div class="card-body border-top">
                    <div class="mb-3">
                        <small class="text-muted">Email</small>
                        <p class="mb-0"><?php echo e($user->email); ?></p>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Phone</small>
                        <p class="mb-0"><?php echo e($user->phone); ?></p>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Joined</small>
                        <p class="mb-0"><?php echo e($user->created_at->format('M d, Y')); ?></p>
                    </div>
                    <div class="mb-0">
                        <small class="text-muted">Last Login</small>
                        <p class="mb-0"><?php echo e($user->last_login_at ? $user->last_login_at->diffForHumans() : 'Never'); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Details Tabs -->
        <div class="col-md-8 mb-4">
            <div class="card">
                <div class="card-header">
                    <ul class="nav nav-tabs card-header-tabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#details">Details</a>
                        </li>
                        <?php if($user->business): ?>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#business">Business</a>
                        </li>
                        <?php endif; ?>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#subscriptions">Subscriptions</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#activity">Activity</a>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content">
                        <!-- Details Tab -->
                        <div class="tab-pane fade show active" id="details">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="200">User ID</th>
                                    <td>#<?php echo e($user->id); ?></td>
                                </tr>
                                <tr>
                                    <th>Full Name</th>
                                    <td><?php echo e($user->full_name); ?></td>
                                </tr>
                                <tr>
                                    <th>Email</th>
                                    <td>
                                        <?php echo e($user->email); ?>

                                        <?php if($user->email_verified_at): ?>
                                            <span class="badge bg-success ms-2">Verified</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Phone</th>
                                    <td>
                                        <?php echo e($user->phone); ?>

                                        <?php if($user->phone_verified_at): ?>
                                            <span class="badge bg-success ms-2">Verified</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Account Type</th>
                                    <td><?php echo e(ucfirst(str_replace('_', ' ', $user->account_type))); ?></td>
                                </tr>
                                <tr>
                                    <th>Role</th>
                                    <td><span class="badge bg-primary"><?php echo e(ucfirst($user->role)); ?></span></td>
                                </tr>
                                <tr>
                                    <th>Status</th>
                                    <td><span class="badge bg-<?php echo e($user->status === 'active' ? 'success' : 'danger'); ?>"><?php echo e(ucfirst($user->status)); ?></span></td>
                                </tr>
                                <tr>
                                    <th>Date of Birth</th>
                                    <td><?php echo e($user->date_of_birth ?? 'Not provided'); ?></td>
                                </tr>
                                <tr>
                                    <th>Registered</th>
                                    <td><?php echo e($user->created_at->format('M d, Y h:i A')); ?></td>
                                </tr>
                                <tr>
                                    <th>Last Updated</th>
                                    <td><?php echo e($user->updated_at->format('M d, Y h:i A')); ?></td>
                                </tr>
                                <tr>
                                    <th>Last Login</th>
                                    <td><?php echo e($user->last_login_at ? $user->last_login_at->format('M d, Y h:i A') : 'Never'); ?></td>
                                </tr>
                            </table>
                        </div>

                        <!-- Business Tab -->
                        <?php if($user->business): ?>
                        <div class="tab-pane fade" id="business">
                            <h5 class="mb-3">Business Information</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <th width="200">Business Name</th>
                                    <td><?php echo e($user->business->business_name); ?></td>
                                </tr>
                                <tr>
                                    <th>License Number</th>
                                    <td><?php echo e($user->business->trade_license_number); ?></td>
                                </tr>
                                <tr>
                                    <th>Status</th>
                                    <td><span class="badge bg-<?php echo e($user->business->status === 'verified' ? 'success' : 'warning'); ?>"><?php echo e(ucfirst($user->business->status)); ?></span></td>
                                </tr>
                                <tr>
                                    <th>Subscription</th>
                                    <td><span class="badge bg-info"><?php echo e(ucfirst($user->business->subscription_status)); ?></span></td>
                                </tr>
                                <tr>
                                    <th>Total Venues</th>
                                    <td><?php echo e($user->business->total_venues); ?></td>
                                </tr>
                                <tr>
                                    <th>Total Offers</th>
                                    <td><?php echo e($user->business->total_offers); ?></td>
                                </tr>
                            </table>
                            <a href="<?php echo e(route('admin.businesses.show', $user->business->id)); ?>" class="btn btn-sm btn-primary">
                                View Business Details
                            </a>
                        </div>
                        <?php endif; ?>

                        <!-- Subscriptions Tab -->
                        <div class="tab-pane fade" id="subscriptions">
                            <?php if($user->subscriptions && $user->subscriptions->count() > 0): ?>
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Plan</th>
                                                <th>Status</th>
                                                <th>Start Date</th>
                                                <th>End Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $user->subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($subscription->plan->name ?? 'N/A'); ?></td>
                                                <td><span class="badge bg-<?php echo e($subscription->status === 'active' ? 'success' : 'secondary'); ?>"><?php echo e(ucfirst($subscription->status)); ?></span></td>
                                                <td><?php echo e($subscription->start_date->format('M d, Y')); ?></td>
                                                <td><?php echo e($subscription->end_date->format('M d, Y')); ?></td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="bi bi-inbox text-muted" style="font-size: 48px;"></i>
                                    <p class="text-muted mt-2">No subscriptions</p>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Activity Tab -->
                        <div class="tab-pane fade" id="activity">
                            <div class="timeline">
                                <div class="timeline-item">
                                    <i class="bi bi-person-check bg-success"></i>
                                    <div class="timeline-content">
                                        <h6>Account Created</h6>
                                        <p class="text-muted mb-0"><?php echo e($user->created_at->format('M d, Y h:i A')); ?></p>
                                    </div>
                                </div>
                                <?php if($user->email_verified_at): ?>
                                <div class="timeline-item">
                                    <i class="bi bi-envelope-check bg-info"></i>
                                    <div class="timeline-content">
                                        <h6>Email Verified</h6>
                                        <p class="text-muted mb-0"><?php echo e($user->email_verified_at->format('M d, Y h:i A')); ?></p>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <?php if($user->last_login_at): ?>
                                <div class="timeline-item">
                                    <i class="bi bi-box-arrow-in-right bg-primary"></i>
                                    <div class="timeline-content">
                                        <h6>Last Login</h6>
                                        <p class="text-muted mb-0"><?php echo e($user->last_login_at->format('M d, Y h:i A')); ?></p>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.timeline {
    position: relative;
    padding: 20px 0;
}

.timeline-item {
    position: relative;
    padding-left: 60px;
    margin-bottom: 30px;
}

.timeline-item i {
    position: absolute;
    left: 0;
    top: 0;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 18px;
}

.timeline-item:not(:last-child)::before {
    content: '';
    position: absolute;
    left: 20px;
    top: 40px;
    width: 2px;
    height: calc(100% + 10px);
    background: #e9ecef;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/users/show.blade.php ENDPATH**/ ?>