<!-- Rejection Checklist Component -->
<!-- Use this in business dashboard when business status is 'rejected' -->

<?php if($business->status === 'rejected' && $business->rejection_checklist): ?>
<div class="card border-danger shadow-sm mb-4">
    <div class="card-header bg-danger text-white">
        <h5 class="mb-0">
            <i class="bi bi-exclamation-circle"></i> Verification Rejected
        </h5>
    </div>
    <div class="card-body">
        <p class="text-muted">
            Your business verification was rejected. Please address the issues below and resubmit for approval.
        </p>

        <!-- Rejection Reason -->
        <?php if($business->rejection_reason): ?>
        <div class="alert alert-warning mb-3">
            <strong>Reason:</strong> <?php echo e($business->rejection_reason); ?>

        </div>
        <?php endif; ?>

        <!-- Rejection Checklist -->
        <div class="mb-3">
            <h6 class="fw-bold mb-3">Please address the following items:</h6>
            <div class="list-group">
                <?php $__currentLoopData = $business->rejection_checklist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="list-group-item">
                    <div class="d-flex align-items-center">
                        <?php if($item['checked']): ?>
                        <i class="bi bi-x-circle text-danger fs-5 me-3"></i>
                        <div>
                            <p class="mb-0 fw-semibold"><?php echo e($item['label']); ?></p>
                        </div>
                        <?php else: ?>
                        <i class="bi bi-check-circle text-success fs-5 me-3"></i>
                        <div>
                            <p class="mb-0 text-muted" style="text-decoration: line-through;"><?php echo e($item['label']); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <!-- Resubmit Button -->
        <div class="mt-4">
            <a href="<?php echo e(route('business.verification.edit', $business)); ?>" class="btn btn-primary">
                <i class="bi bi-arrow-repeat"></i> Update Business Info & Resubmit
            </a>
            <small class="text-muted d-block mt-2">
                <i class="bi bi-info-circle"></i>
                Resubmission Attempt: <?php echo e($business->verification_attempts ?? 1); ?> / 3
            </small>
        </div>
    </div>
</div>
<?php endif; ?>

<?php /**PATH C:\laragon\www\privasee\resources\views/components/business-rejection-checklist.blade.php ENDPATH**/ ?>