<?php $__env->startSection('title', 'Venues Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Venues Management</h2>
        <p class="text-muted mb-0">Manage your business locations and venues</p>
    </div>
    <a href="<?php echo e(route('business.venues.create')); ?>" class="btn btn-primary">
        <i class="bi bi-plus-lg me-2"></i>Add New Venue
    </a>
</div>

<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <i class="bi bi-geo-alt text-white"></i>
            </div>
            <div class="stat-label">Total Venues</div>
            <div class="stat-value"><?php echo e($stats['total'] ?? 0); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                <i class="bi bi-check-circle text-white"></i>
            </div>
            <div class="stat-label">Active Venues</div>
            <div class="stat-value"><?php echo e($stats['active'] ?? 0); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
                <i class="bi bi-eye text-white"></i>
            </div>
            <div class="stat-label">Total Views</div>
            <div class="stat-value"><?php echo e(number_format($stats['total_views'] ?? 0)); ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                <i class="bi bi-star text-white"></i>
            </div>
            <div class="stat-label">Avg Rating</div>
            <div class="stat-value"><?php echo e(number_format($stats['avg_rating'] ?? 0, 1)); ?></div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="table-card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <input type="text" class="form-control" name="search" placeholder="Search venues..." value="<?php echo e(request('search')); ?>">
            </div>
            <div class="col-md-2">
                <select class="form-select" name="status">
                    <option value="">All Status</option>
                    <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                    <option value="under_maintenance" <?php echo e(request('status') === 'under_maintenance' ? 'selected' : ''); ?>>Maintenance</option>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select" name="city">
                    <option value="">All Cities</option>
                    <?php $__currentLoopData = $cities ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($city); ?>" <?php echo e(request('city') === $city ? 'selected' : ''); ?>><?php echo e($city); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-4">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="<?php echo e(route('business.venues.index')); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-x-lg me-2"></i>Clear
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Venues Grid/List -->
<div class="row g-4">
    <?php $__empty_1 = true; $__currentLoopData = $venues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="col-md-6 col-lg-4">
        <div class="card h-100 border-0 shadow-sm">
            <div class="position-relative">
                <?php if($venue->featured_image): ?>
                    <img src="<?php echo e(Storage::url($venue->featured_image)); ?>" class="card-img-top" alt="<?php echo e($venue->name); ?>" style="height: 200px; object-fit: cover;">
                <?php else: ?>
                    <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                        <i class="bi bi-image text-muted" style="font-size: 3rem;"></i>
                    </div>
                <?php endif; ?>

                <div class="position-absolute top-0 end-0 m-2">
                    <?php if($venue->is_featured): ?>
                        <span class="badge bg-warning text-dark">
                            <i class="bi bi-star-fill me-1"></i>Featured
                        </span>
                    <?php endif; ?>
                </div>

                <div class="position-absolute bottom-0 start-0 m-2">
                    <?php if($venue->status === 'active'): ?>
                        <span class="badge bg-success">Active</span>
                    <?php elseif($venue->status === 'rejected'): ?>
                        <span class="badge bg-danger">Rejected</span>
                    <?php elseif($venue->status === 'inactive'): ?>
                        <span class="badge bg-secondary">Inactive</span>
                    <?php else: ?>
                        <span class="badge bg-warning">Pending</span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="card-body">
                <h5 class="card-title fw-bold"><?php echo e($venue->name); ?></h5>
                <p class="text-muted small mb-2">
                    <i class="bi bi-geo-alt me-1"></i><?php echo e($venue->city); ?>, <?php echo e($venue->area); ?>

                </p>
                <p class="card-text small text-muted"><?php echo e(Str::limit($venue->description, 100)); ?></p>

                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <i class="bi bi-star-fill text-warning"></i>
                        <span class="fw-semibold"><?php echo e(number_format($venue->rating, 1)); ?></span>
                        <span class="text-muted small">(<?php echo e($venue->total_reviews); ?>)</span>
                    </div>
                    <div class="text-muted small">
                        <i class="bi bi-eye me-1"></i><?php echo e(number_format($venue->view_count)); ?>

                    </div>
                </div>

                <div class="d-flex gap-2">
                    <a href="<?php echo e(route('business.venues.show', $venue->id)); ?>" class="btn btn-sm btn-outline-primary flex-fill">
                        <i class="bi bi-eye me-1"></i>View
                    </a>
                    <a href="<?php echo e(route('business.venues.edit', $venue->id)); ?>" class="btn btn-sm btn-primary flex-fill">
                        <i class="bi bi-pencil me-1"></i>Edit
                    </a>
                    <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($venue->id); ?>">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Delete Modal -->
        <div class="modal fade" id="deleteModal<?php echo e($venue->id); ?>" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header border-0">
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-center py-4">
                        <i class="bi bi-exclamation-triangle text-danger" style="font-size: 4rem;"></i>
                        <h5 class="mt-3">Delete Venue?</h5>
                        <p class="text-muted">Are you sure you want to delete <strong><?php echo e($venue->name); ?></strong>?</p>
                        <p class="text-danger small">This action cannot be undone.</p>
                    </div>
                    <div class="modal-footer border-0 justify-content-center">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <form action="<?php echo e(route('business.venues.destroy', $venue->id)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger">Yes, Delete</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="col-12">
        <div class="text-center py-5">
            <i class="bi bi-geo-alt fs-1 text-muted d-block mb-3"></i>
            <h5>No venues found</h5>
            <p class="text-muted">Start by adding your first venue</p>
            <a href="<?php echo e(route('business.venues.create')); ?>" class="btn btn-primary mt-3">
                <i class="bi bi-plus-lg me-2"></i>Add Your First Venue
            </a>
        </div>
    </div>
    <?php endif; ?>
</div>






<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/venues/index.blade.php ENDPATH**/ ?>