<?php $__env->startSection('title', 'Verify Business'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-4">
    <a href="<?php echo e(route('admin.businesses.index')); ?>" class="btn btn-outline-secondary btn-sm mb-3">
        <i class="bi bi-arrow-left me-2"></i>Back to Businesses
    </a>
    <h2 class="fw-bold mb-1">Business Verification</h2>
    <p class="text-muted mb-0">Review and verify business application</p>
</div>

<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul class="mb-0">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
<div class="row g-4">
    <!-- Business Information -->
    <div class="col-lg-8">
        <div class="admin-card mb-4">
            <div class="admin-card-header">
                <h5 class="mb-0 fw-bold">Business Information</h5>
            </div>
            <div class="admin-card-body">
                <div class="row g-3">
                    <div class="col-md-12">
                        <div class="d-flex align-items-center mb-3">
                            <img src="<?php echo e($business->logo ?? 'https://ui-avatars.com/api/?name='.$business->business_name); ?>"
                                 class="rounded me-3" width="80" height="80" style="object-fit: cover;">
                            <div>
                                <h4 class="mb-1"><?php echo e($business->business_name); ?></h4>
                                <?php if($business->business_name_ar): ?>
                                    <p class="text-muted mb-0"><?php echo e($business->business_name_ar); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Trade License Number</label>
                        <div class="fw-semibold font-monospace"><?php echo e($business->trade_license_number); ?></div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Business Email</label>
                        <div class="fw-semibold"><?php echo e($business->email); ?></div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Phone Number</label>
                        <div class="fw-semibold"><?php echo e($business->phone); ?></div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Website</label>
                        <div class="fw-semibold"><?php echo e($business->website ?? 'N/A'); ?></div>
                    </div>

                    <div class="col-12">
                        <label class="text-muted small">Description</label>
                        <div class="bg-light p-3 rounded"><?php echo e($business->description ?? 'No description provided'); ?></div>
                    </div>

                    <?php if($business->description_ar): ?>
                    <div class="col-12">
                        <label class="text-muted small">Description (Arabic)</label>
                        <div class="bg-light p-3 rounded" dir="rtl"><?php echo e($business->description_ar); ?></div>
                    </div>
                    <?php endif; ?>

                    <div class="col-md-6">
                        <label class="text-muted small">Submitted On</label>
                        <div class="fw-semibold"><?php echo e($business->created_at->format('M d, Y h:i A')); ?></div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Time Since Submission</label>
                        <div class="fw-semibold"><?php echo e($business->created_at->diffForHumans()); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Owner Information -->
        <div class="admin-card mb-4">
            <div class="admin-card-header">
                <h5 class="mb-0 fw-bold">Owner Information</h5>
            </div>
            <div class="admin-card-body">
                <div class="row g-3">
                    <div class="col-md-12">
                        <div class="d-flex align-items-center">
                            <img src="<?php echo e($business->owner->avatar ?? 'https://ui-avatars.com/api/?name='.$business->owner->full_name); ?>"
                                 class="rounded-circle me-3" width="60" height="60">
                            <div>
                                <h5 class="mb-0"><?php echo e($business->owner->full_name); ?></h5>
                                <p class="text-muted mb-0">Owner</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Email</label>
                        <div class="fw-semibold"><?php echo e($business->owner->email); ?></div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Phone</label>
                        <div class="fw-semibold"><?php echo e($business->owner->phone ?? 'N/A'); ?></div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Account Created</label>
                        <div class="fw-semibold"><?php echo e($business->owner->created_at->format('M d, Y')); ?></div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-muted small">Total Businesses</label>
                        <div class="fw-semibold"><?php echo e($business->owner->businesses_count ?? 1); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Trade License Document -->
        <div class="admin-card">
            <div class="admin-card-header">
                <h5 class="mb-0 fw-bold">Trade License Document</h5>
            </div>
            <div class="admin-card-body text-center">
                <?php if($business->trade_license_document): ?>
                    <img src="<?php echo e(Storage::url($business->trade_license_document)); ?>"
                         class="img-fluid rounded border" style="max-height: 500px;">
                    <div class="mt-3">
                        <a href="<?php echo e(Storage::url($business->trade_license_document)); ?>" target="_blank" class="btn btn-outline-primary">
                            <i class="bi bi-download me-2"></i>Download Document
                        </a>
                    </div>
                <?php else: ?>
                    <i class="bi bi-file-earmark-x fs-1 text-muted d-block mb-2"></i>
                    <p class="text-muted">No document uploaded</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Verification Actions -->
    <div class="col-lg-4">
        <div class="admin-card mb-4">
            <div class="admin-card-header">
                <h5 class="mb-0 fw-bold">Verification Status</h5>
            </div>
            <div class="admin-card-body">
                <div class="text-center mb-4">
                    <?php if($business->status === 'pending'): ?>
                        <div class="mb-3">
                            <i class="bi bi-clock-history" style="font-size: 48px; color: var(--admin-warning);"></i>
                        </div>
                        <h5>Pending Verification</h5>
                        <p class="text-muted small">This business is awaiting your review</p>
                    <?php endif; ?>
                </div>

                <form action="<?php echo e(route('admin.businesses.verify.submit', $business->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label class="form-label">Decision <span class="text-danger">*</span></label>
                        <select class="form-select" name="action" id="verificationAction" required>
                            <option value="">Select Decision</option>
                            <option value="approve">✓ Approve & Verify</option>
                            <option value="reject">✗ Reject Application</option>
                        </select>
                    </div>

                    <div class="mb-3" id="notesSection">
                        <label class="form-label">Notes</label>
                        <textarea class="form-control" name="notes" rows="4"
                                  placeholder="Add any notes or reasons for your decision..."></textarea>
                    </div>

                    <!-- Rejection Checklist (shown only when reject is selected) -->
                    <div id="rejectionChecklistSection" style="display: none;" class="mb-3">
                        <label class="form-label fw-semibold">Reason(s) for Rejection <span class="text-danger">*</span></label>
                        <div class="alert alert-info small">
                            <i class="bi bi-info-circle"></i> Select all reasons that apply for this rejection
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="trade_license" id="check1">
                            <label class="form-check-label" for="check1">
                                Trade License Missing or Invalid
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="business_info" id="check2">
                            <label class="form-check-label" for="check2">
                                Business Information Incomplete
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="contact_details" id="check3">
                            <label class="form-check-label" for="check3">
                                Contact Details Invalid
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="business_description" id="check4">
                            <label class="form-check-label" for="check4">
                                Business Description Insufficient
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="documentation" id="check5">
                            <label class="form-check-label" for="check5">
                                Required Documentation Missing
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="checklist[]" value="compliance" id="check6">
                            <label class="form-check-label" for="check6">
                                Business Does Not Meet Compliance Requirements
                            </label>
                        </div>
                    </div>

                    <div class="mb-3 form-check">
                        <input class="form-check-input" type="checkbox" name="send_email" id="sendEmail" checked>
                        <label class="form-check-label" for="sendEmail">
                            Send notification email to business owner
                        </label>
                    </div>

                    <button type="submit" class="btn btn-primary w-100" id="submitBtn">
                        <i class="bi bi-check-lg me-2"></i>Submit Decision
                    </button>
                </form>
            </div>
        </div>







































    </div>
</div>

<script>
    // Show/hide rejection checklist based on decision
    document.getElementById('verificationAction').addEventListener('change', function() {
        const checklistSection = document.getElementById('rejectionChecklistSection');
        if (this.value === 'reject') {
            checklistSection.style.display = 'block';
        } else {
            checklistSection.style.display = 'none';
            // Uncheck all checkboxes when switching away from reject
            document.querySelectorAll('#rejectionChecklistSection input[type="checkbox"]').forEach(cb => cb.checked = false);
        }
    });

    // Prevent submission if reject is selected but no checklist items are checked
    document.querySelector('form').addEventListener('submit', function(e) {
        const action = document.getElementById('verificationAction').value;
        if (action === 'reject') {
            const checkedItems = document.querySelectorAll('#rejectionChecklistSection input[type="checkbox"]:checked');
            if (checkedItems.length === 0) {
                e.preventDefault();
                alert('Please select at least one reason for rejection');
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('verificationAction')?.addEventListener('change', function() {
    const submitBtn = document.getElementById('submitBtn');
    if (this.value === 'approve') {
        submitBtn.className = 'btn btn-success w-100';
        submitBtn.innerHTML = '<i class="bi bi-check-lg me-2"></i>Approve & Verify Business';
    } else if (this.value === 'reject') {
        submitBtn.className = 'btn btn-danger w-100';
        submitBtn.innerHTML = '<i class="bi bi-x-lg me-2"></i>Reject Application';
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/businesses/verify.blade.php ENDPATH**/ ?>