

<?php $__env->startSection('title', $team->name); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0"><?php echo e($team->name); ?></h1>
            <p class="text-muted"><?php echo e($team->description); ?></p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?php echo e(route('admin.teams.edit', $team)); ?>" class="btn btn-warning">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="<?php echo e(route('admin.teams.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Team Info -->
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Team Information</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="text-muted small">Business</label>
                        <p class="mb-0">
                            <a href="<?php echo e(route('admin.businesses.show', $team->business)); ?>">
                                <?php echo e($team->business->business_name); ?>

                            </a>
                        </p>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Status</label>
                        <div>
                            <span class="badge bg-<?php echo e($team->status === 'active' ? 'success' : 'secondary'); ?>">
                                <?php echo e(ucfirst($team->status)); ?>

                            </span>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Members</label>
                        <h5 class="mb-0"><?php echo e($team->member_count); ?></h5>
                    </div>
                    <div class="mb-3">
                        <label class="text-muted small">Created</label>
                        <h6 class="mb-0"><?php echo e($team->created_at->format('M d, Y H:i')); ?></h6>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Quick Actions</h6>
                </div>
                <div class="card-body">
                    <a href="<?php echo e(route('admin.chats.index', ['team_id' => $team->id])); ?>" class="btn btn-sm btn-outline-primary w-100 mb-2">
                        <i class="fas fa-comments"></i> View Chats
                    </a>
                </div>
            </div>
        </div>

        <!-- Team Members -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Team Members</h5>
                    <a href="<?php echo e(route('admin.teams.add-member', $team)); ?>" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> Add Member
                    </a>
                </div>

                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Role</th>
                                <th>Status</th>
                                <th>Joined</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $team->members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <strong><?php echo e($member->first_name); ?> <?php echo e($member->last_name); ?></strong>
                                </td>
                                <td><?php echo e($member->email); ?></td>
                                <td>
                                    <?php if($member->pivot->role_id): ?>
                                        <span class="badge bg-primary">
                                            <?php echo e(\App\Models\Role::find($member->pivot->role_id)?->display_name ?? 'N/A'); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($member->pivot->status === 'active' ? 'success' : 'warning'); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $member->pivot->status))); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php if($member->pivot->joined_at): ?>
                                        <small><?php echo e($member->pivot->joined_at->format('M d, Y')); ?></small>
                                    <?php else: ?>
                                        <small class="text-muted">Pending</small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <form action="<?php echo e(route('admin.teams.remove-member', [$team, $member])); ?>" method="POST" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Remove this member?')">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center text-muted py-4">
                                    No members yet.
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Team Chats -->
            <div class="card mt-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Team Chats</h5>
                    <a href="<?php echo e(route('admin.chats.create', ['team_id' => $team->id])); ?>" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus"></i> New Chat
                    </a>
                </div>

                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Chat Name</th>
                                <th>Participants</th>
                                <th>Messages</th>
                                <th>Last Message</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $team->chats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><strong><?php echo e($chat->name); ?></strong></td>
                                <td><?php echo e($chat->participants->count()); ?></td>
                                <td><?php echo e($chat->message_count); ?></td>
                                <td>
                                    <?php if($chat->last_message_at): ?>
                                        <small><?php echo e($chat->last_message_at->diffForHumans()); ?></small>
                                    <?php else: ?>
                                        <small class="text-muted">-</small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.chats.show', $chat)); ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted py-4">
                                    No chats yet.
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/teams/show.blade.php ENDPATH**/ ?>